/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceProgressBarUI
extends BasicProgressBarUI {
    protected Set lafWidgets;
    private static Map<String, BufferedImage> stripeMap = new HashMap<String, BufferedImage>();
    private float animationIndex;
    protected ChangeListener substanceValueChangeListener;
    protected float speed;
    public static final FadeKind PROGRESS_BAR_VALUE_CHANGED = new FadeKind("substancelaf.progressBarValueChanged");
    private static final String PROGRESS_BAR_FROM = "substancelaf.internal.from";
    private static final String PROGRESS_BAR_TO = "substancelaf.internal.to";

    public void __org__jvnet__substance__SubstanceProgressBarUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceProgressBarUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceProgressBarUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        stripeMap.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceProgressBarUI();
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installDefaults() {
        super.installDefaults();
        this.progressBar.putClientProperty(PROGRESS_BAR_TO, this.progressBar.getValue());
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.speed = 20.0f * (float)UIManager.getInt("ProgressBar.repaintInterval") / (float)UIManager.getInt("ProgressBar.cycleTime");
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installListeners() {
        super.installListeners();
        final BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            this.substanceValueChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int oldValue = (Integer)SubstanceProgressBarUI.this.progressBar.getClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO);
                    int currValue = model.getValue();
                    int span = model.getMaximum() - model.getMinimum();
                    Insets b = SubstanceProgressBarUI.this.progressBar.getInsets();
                    int barRectWidth = SubstanceProgressBarUI.this.progressBar.getWidth() - (b.right + b.left);
                    int barRectHeight = SubstanceProgressBarUI.this.progressBar.getHeight() - (b.top + b.bottom);
                    int totalPixels = SubstanceProgressBarUI.this.progressBar.getOrientation() == 0 ? barRectWidth : barRectHeight;
                    int pixelDelta = span <= 0 ? 0 : (currValue - oldValue) * totalPixels / span;
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (!fadeTracker.isTracked(SubstanceProgressBarUI.this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
                        SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_FROM, SubstanceProgressBarUI.this.progressBar.getClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO));
                    }
                    SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO, SubstanceProgressBarUI.this.progressBar.getValue());
                    if (Math.abs(pixelDelta) > 5) {
                        FadeTracker.getInstance().trackFadeIn(PROGRESS_BAR_VALUE_CHANGED, SubstanceProgressBarUI.this.progressBar, false, null);
                    }
                }
            };
            ((DefaultBoundedRangeModel)model).addChangeListener(this.substanceValueChangeListener);
        }
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners() {
        BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            ((DefaultBoundedRangeModel)model).removeChangeListener(this.substanceValueChangeListener);
        }
        super.uninstallListeners();
    }

    private static synchronized BufferedImage getStripe(int baseSize, boolean isRotated, ColorScheme colorScheme) {
        String key = "" + baseSize + ":" + isRotated + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme);
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = SubstanceImageCreator.getRotated(result, 1);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        BufferedImage bg;
        GeneralPath contour;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D graphics = (Graphics2D)g;
        SubstanceTheme bgTheme = SubstanceCoreUtilities.getTheme(this.progressBar, true);
        bgTheme = this.progressBar.isEnabled() ? bgTheme.getDefaultTheme() : bgTheme.getDisabledTheme();
        StandardGradientPainter gp = new StandardGradientPainter();
        if (this.progressBar.getOrientation() == 0) {
            contour = BaseButtonShaper.getBaseOutline(barRectWidth + 1, barRectHeight + 1, 0.0f, null);
            bg = gp.getContourBackground(barRectWidth + 1, barRectHeight + 1, contour, false, bgTheme.getColorScheme(), bgTheme.getColorScheme(), 0.0f, true, false);
            graphics.drawImage((Image)bg, 1, 1, null);
        } else {
            contour = BaseButtonShaper.getBaseOutline(barRectHeight + 1, barRectWidth + 1, 0.0f, null);
            bg = gp.getContourBackground(barRectHeight + 1, barRectWidth + 1, contour, false, bgTheme.getColorScheme(), bgTheme.getColorScheme(), 0.0f, true, false);
            graphics.drawImage((Image)SubstanceImageCreator.getRotated(bg, 3), 1, 0, null);
        }
        if (amountFull > 0) {
            ColorScheme fillColorScheme;
            ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
            if (this.progressBar.getOrientation() == 0) {
                int barWidth = amountFull;
                int barHeight = barRectHeight;
                if (barWidth > 0 && barHeight > 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        SubstanceImageCreator.paintProgressBar(g, b.left, b.top, barWidth, barHeight, fillColorScheme, false);
                    } else {
                        SubstanceImageCreator.paintProgressBar(g, b.left + barRectWidth - amountFull, b.top, barWidth, barHeight, fillColorScheme, false);
                    }
                }
            } else {
                int barWidth = this.progressBar.getHeight() - b.bottom - amountFull;
                int barHeight = barRectWidth;
                if (barWidth > 0 && barHeight > 0) {
                    SubstanceImageCreator.paintProgressBar(g, b.left, barWidth, barHeight, amountFull, fillColorScheme, true);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    protected Color getSelectionBackground() {
        SubstanceTheme bgTheme = SubstanceCoreUtilities.getTheme(this.progressBar, true);
        bgTheme = this.progressBar.isEnabled() ? bgTheme.getDefaultTheme() : bgTheme.getDisabledTheme();
        return bgTheme.getForegroundColor();
    }

    protected Color getSelectionForeground() {
        ColorScheme fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
        return fillColorScheme.getForegroundColor();
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        ColorScheme fillColorScheme;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int valComplete = (int)this.animationIndex;
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, true);
        }
        ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectHeight, false, fillColorScheme), valComplete, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectWidth, true, fillColorScheme), 2 * barRectWidth - valComplete, true);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
        }
    }

    protected Rectangle getBox(Rectangle r) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        return new Rectangle(b.left, b.top, barRectWidth, barRectHeight);
    }

    protected void incrementAnimationIndex() {
        float newValue = this.animationIndex + this.speed;
        Insets b = this.progressBar.getInsets();
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int threshold = 0;
        threshold = this.progressBar.getOrientation() == 0 ? 2 * barRectHeight + 1 : 2 * barRectWidth + 1;
        this.animationIndex = newValue % (float)threshold;
        this.progressBar.repaint();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceProgressBarUI: \n");
        sb.append("\t" + stripeMap.size() + " stripes");
        return sb.toString();
    }

    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        long span = model.getMaximum() - model.getMinimum();
        double currentValue = model.getValue();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
            double fade10 = fadeTracker.getFade10(this.progressBar, PROGRESS_BAR_VALUE_CHANGED);
            int from = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_FROM);
            int to = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_TO);
            currentValue = from + (int)(fade10 * (double)(to - from) / 10.0);
        }
        double percentComplete = (currentValue - (double)model.getMinimum()) / (double)span;
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * percentComplete) : (int)Math.round((double)height * percentComplete);
        }
        return amountFull;
    }
}

