/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableHeaderUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceDefaultTableHeaderCellRenderer
extends DefaultTableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color backgroundToSet;
        if (table == null) {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            this.setValue(value);
            this.setOpaque(false);
            return this;
        }
        if (table.getTableHeader() == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        TableHeaderUI tableHeaderUI = table.getTableHeader().getUI();
        if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
            SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
            ComponentState state = ui.getColumnState(column);
            ComponentState prevState = ui.getPrevColumnState(column);
            JTableHeader header = table.getTableHeader();
            SubstanceTheme theme = SubstanceCoreUtilities.getTheme((Component)header, state, true, true);
            Color color = SubstanceCoreUtilities.getInterpolatedForegroundColor(header, Integer.valueOf(column), theme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(color);
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
        }
        Color color = backgroundToSet = this.unselectedBackground != null ? this.unselectedBackground : table.getBackground();
        if (backgroundToSet != null) {
            if (row % 2 != 0) {
                int r = backgroundToSet.getRed();
                int g = backgroundToSet.getGreen();
                int b = backgroundToSet.getBlue();
                double coef = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 0.8 : 0.96;
                backgroundToSet = new ColorUIResource((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
            }
            super.setBackground(backgroundToSet);
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
        }
        this.setValue(value);
        this.setOpaque(false);
        return this;
    }
}

