/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.combo.SubstanceComboPopup;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    protected Set lafWidgets;
    public static final Map<String, Icon> COMBO_ARROWS = new HashMap<String, Icon>();
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();
    protected FadeStateListener substanceFadeStateListener;

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceComboBoxUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installComponents() {
        super.installComponents();
    }

    public void installComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceComboBoxUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__installDefaults() {
        super.installDefaults();
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents() {
        super.uninstallComponents();
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceComboBoxUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        COMBO_ARROWS.clear();
    }

    public static synchronized Icon getArrowIcon(SubstanceTheme theme, int orientation) {
        String key = theme.getDisplayName() + ":" + orientation;
        Icon result = COMBO_ARROWS.get(key);
        if (result != null) {
            return result;
        }
        result = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth(), orientation == 0 ? 2 * SubstanceSizeUtils.getArrowIconHeight() : SubstanceSizeUtils.getArrowIconHeight(), SubstanceSizeUtils.getArrowStrokeWidth(), orientation, theme);
        COMBO_ARROWS.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI();
        ui.comboBox = (JComboBox)b;
        return ui;
    }

    protected JButton createArrowButton() {
        SubstanceTheme theme = this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(this.comboBox, true);
        return new SubstanceComboBoxButton(this.comboBox, SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox)));
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__installListeners() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceFadeStateListener = new FadeStateListener(this.comboBox, null, null);
        this.substanceFadeStateListener.registerListeners();
    }

    protected void __org__jvnet__substance__SubstanceComboBoxUI__uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        super.uninstallListeners();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        int dy = ((JComboBox)c).isEditable() ? 0 : 2;
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + dy);
        return res;
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof SubstanceComboBoxButton) {
            SubstanceComboBoxButton button = (SubstanceComboBoxButton)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width = (int)((double)size.width + button.getMinimumSize().getWidth());
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
            size.width += margin.left + margin.right;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean isSelected;
        ListUI listUI = this.popup.getList().getUI();
        SubstanceListUI ui = (SubstanceListUI)listUI;
        ComponentState state = ui.getCellState(-1);
        boolean isEnabled = this.comboBox.isEnabled();
        boolean bl = isSelected = hasFocus || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox);
        if (isSelected && isEnabled) {
            state = ComponentState.SELECTED;
        }
        if (!isEnabled) {
            state = ComponentState.DISABLED_UNSELECTED;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        float alpha = SubstanceCoreUtilities.getTheme(this.comboBox, true).getThemeAlpha(this.comboBox, state);
        if (!SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox)) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, 0.8f * alpha, g));
        } else {
            graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, alpha, g));
        }
        Rectangle newBounds = bounds;
        if (this.comboBox.getBorder() != null) {
            newBounds = new Rectangle(bounds.x, bounds.y + 1, bounds.width, bounds.height - 2);
        }
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(this.popup.getList(), state, true, true);
        backgroundDelegate.update(graphics, this.comboBox, newBounds, theme, false);
        graphics.dispose();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState state = this.comboBox.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        float alpha = SubstanceCoreUtilities.getTheme(this.comboBox, true).getThemeAlpha(this.comboBox, state);
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.comboBox, alpha, g));
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (renderer instanceof SubstanceDefaultListCellRenderer) {
            Component c = hasFocus || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox) ? renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, hasFocus) : renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, hasFocus);
            c.setFont(this.comboBox.getFont());
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            SubstanceCoreUtilities.workaroundBug6576507(graphics);
            this.currentValuePane.paintComponent(graphics, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
        } else {
            super.paintCurrentValue(g, bounds, hasFocus);
        }
        graphics.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable() && this.hasFocus) {
            Rectangle r = this.rectangleForCurrentValue();
            ++r.y;
            r.height -= 2;
            this.paintFocus(g, r);
        }
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
        SubstanceCoreUtilities.paintFocus(g, this.comboBox, this.comboBox, null, bounds, 0.4f, 2 + SubstanceSizeUtils.getExtraPadding());
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    public void __org__jvnet__substance__SubstanceComboBoxUI__update(Graphics g, JComponent c) {
        if (SubstanceCoreUtilities.hasSubstanceBorder(c)) {
            if (c.isOpaque()) {
                g.setColor(c.getBackground());
                g.fillRect(1, 1, c.getWidth() - 2, c.getHeight() - 2);
            }
            this.paint(g, c);
        } else {
            super.update(g, c);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceComboBoxUI: \n");
        sb.append("\t" + COMBO_ARROWS.size() + " arrows");
        return sb.toString();
    }

    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
    }

    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder(new EmptyBorder(0, 1, 0, 1));
        }
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(final PropertyChangeEvent e) {
            SubstanceTheme theme;
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled") && SubstanceComboBoxUI.this.arrowButton != null) {
                theme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(SubstanceComboBoxUI.this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(SubstanceComboBoxUI.this.comboBox, true);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                        SubstanceComboBoxUI.this.arrowButton.putClientProperty("substancelaf.buttonside", newOrientation.isLeftToRight() ? SubstanceConstants.Side.LEFT.name() : SubstanceConstants.Side.RIGHT.name());
                        ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                theme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveTheme(SubstanceComboBoxUI.this.comboBox, true) : SubstanceCoreUtilities.getDefaultTheme(SubstanceComboBoxUI.this.comboBox, true);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(theme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = SubstanceSizeUtils.getScrollBarWidth();
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

