/*
 * Decompiled with CFR 0.152.
 */
package name.yumao.douyu.mina;

import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JTextField;
import name.yumao.douyu.swing.ToolSub;
import name.yumao.douyu.swing.ToolTip;
import name.yumao.douyu.utils.BigHexStringUtils;
import name.yumao.douyu.utils.HexUtils;
import name.yumao.douyu.utils.SttDecoder;
import org.apache.log4j.Logger;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;

public class ContentMinaHandler
implements IoHandler {
    private ToolSub sub = null;
    private ToolTip tip = null;
    private String filepath;
    private JTextField inNum;
    private JButton butnSure;
    private IoSession loginSession;
    private SttDecoder sttDecoder;
    private BigHexStringUtils bigHexStringUtils;
    private static Logger logger = Logger.getLogger(ContentMinaHandler.class);

    public ContentMinaHandler(String filepath, JTextField inNum, JButton butnSure, ToolTip tip, IoSession loginSession) {
        this.filepath = filepath;
        this.inNum = inNum;
        this.butnSure = butnSure;
        this.tip = tip;
        this.loginSession = loginSession;
        this.sttDecoder = new SttDecoder();
        this.bigHexStringUtils = new BigHexStringUtils();
    }

    public void exceptionCaught(IoSession session, Throwable arg1) throws Exception {
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        String hexMessage = message.toString().replace(" ", "");
        while (hexMessage.length() > 0) {
            int msgLength = Math.abs(HexUtils.getHexStringLength(hexMessage));
            if (msgLength + 16 > hexMessage.length()) {
                if (this.bigHexStringUtils.getHexStr().equals("")) {
                    this.bigHexStringUtils.addHexStr(hexMessage);
                    hexMessage = hexMessage.substring(hexMessage.length());
                } else {
                    int pLength = HexUtils.getHexStringLength(this.bigHexStringUtils.getHexStr()) + 16 - this.bigHexStringUtils.getHexStr().length();
                    this.bigHexStringUtils.addHexStr(hexMessage.substring(0, pLength));
                    hexMessage = hexMessage.substring(pLength);
                }
            } else {
                String hexMsg = hexMessage.substring(0, msgLength + 16);
                this.bigHexStringUtils.addHexStr(hexMsg);
                hexMessage = hexMessage.substring(msgLength + 16);
            }
            if (this.bigHexStringUtils.isFullHexStr()) {
                String snick;
                byte[] msgBytes = HexUtils.HexString2Bytes(this.bigHexStringUtils.getHexStr());
                String msgStr = new String(Arrays.copyOfRange(msgBytes, 12, msgBytes.length - 1), "UTF-8");
                this.bigHexStringUtils.clear();
                this.sttDecoder.Parse(msgStr);
                if (this.sttDecoder.GetItem("type").equals("chatmessage")) {
                    String content;
                    if (this.filepath != null && !this.filepath.equals("")) {
                        content = this.sttDecoder.GetItem("content");
                        this.sub.addSubString(content);
                    } else {
                        content = this.sttDecoder.GetItem("content");
                        snick = this.sttDecoder.GetItem("snick");
                        logger.info((Object)("\u63a5\u6536\u5230\u5f39\u5e55\u6d88\u606f\t" + snick + " : " + content));
                        if (this.tip == null) {
                            this.tip = new ToolTip();
                        }
                        this.tip.setToolTip(String.valueOf(snick) + " : " + content);
                    }
                }
                if (!this.sttDecoder.GetItem("type").equals("donateres")) continue;
                String sui = this.sttDecoder.GetItem("sui");
                this.sttDecoder.Clear();
                this.sttDecoder.Parse(sui);
                snick = this.sttDecoder.GetItem("nick");
                logger.info((Object)("\u63a5\u6536\u5230\u793c\u7269\u6d88\u606f\t" + snick + " \u8d60\u9001\u7ed9\u4e3b\u64ad100\u4e2a\u9c7c\u4e38"));
                if (this.tip == null) {
                    this.tip = new ToolTip();
                }
                this.tip.setToolTip(String.valueOf(snick) + " \u8d60\u9001\u7ed9\u4e3b\u64ad100\u4e2a\u9c7c\u4e38");
                continue;
            }
            if (!this.bigHexStringUtils.getHexStr().replace(" ", "").endsWith("40532F00")) continue;
            this.bigHexStringUtils.clear();
        }
    }

    public void messageSent(IoSession session, Object massage) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.tip.setToolTip("\u5931\u53bb\u4e0e\u5f39\u5e55\u670d\u52a1\u5668\u7684\u8fde\u63a5");
        logger.info((Object)"\u5931\u53bb\u4e0e\u5f39\u5e55\u670d\u52a1\u5668\u7684\u8fde\u63a5");
        this.inNum.setEditable(true);
        this.butnSure.setEnabled(true);
        this.loginSession.close();
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (this.filepath != null && !this.filepath.equals("") && this.sub == null) {
            this.sub = new ToolSub(this.filepath);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }
}

