/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.panel.CertificatesDialog;
import com.sun.deploy.panel.RuleSetViewerDialog;
import com.sun.deploy.panel.SecurityLevelPanel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SecurityPanel
extends JPanel
implements SecurityProperties.JavaEnableListener {
    private JCheckBox enableBrowserCheckbox;
    private JLabel disabledForUserOnlyLabel;

    public SecurityPanel() {
        this.initComponents();
        SecurityProperties.addJavaEnableListener(this);
    }

    public final void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Box box = Box.createVerticalBox();
        box.add(this.createEnableJavaInBrowser());
        box.add(this.createSecurityLevelPanel());
        if (DeploymentRuleSet.isRuleSetFileExists()) {
            box.add(this.createRuleSetViewerButtonPanel());
        }
        box.add(this.createCertificationPanel());
        this.add((Component)box, "North");
        this.enableBrowserCheckbox.setEnabled(!Config.get().isPropertyLocked("deployment.webjava.enabled"));
    }

    private void certsBtnActionPerformed(ActionEvent actionEvent) {
        CertificatesDialog certificatesDialog = new CertificatesDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        certificatesDialog.setLocationRelativeTo(this);
        certificatesDialog.setVisible(true);
    }

    private void certsRestoreBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        int n = ToolkitStore.getUI().showMessageDialog(this.getTopLevelAncestor(), null, 2, ResourceManager.getString("cert.restore_dialog.title"), ResourceManager.getString("cert.restore_dialog.masthead"), ResourceManager.getString("cert.restore_dialog.message"), null, ResourceManager.getString("cert.restore_dialog.btn_restore.text"), ResourceManager.getString("cert.restore_dialog.btn_cancel.text"), null, null, null, 1);
        if (n == 0 && !(bl = this.restoreSecurityPrompt())) {
            this.showRestoringSecurityPromptFailDialog();
        }
    }

    private boolean restoreSecurityPrompt() {
        CertStore[] certStoreArray = new CertStore[]{DeploySigningCertStore.getUserCertStore(), DeploySigningCertStore.getSandboxCertStore()};
        boolean bl = true;
        for (int i = 0; i < certStoreArray.length; ++i) {
            bl = bl && this.clearCertStore(certStoreArray[i]);
        }
        bl = bl && Cache.removeRemeberedDecisions();
        return bl;
    }

    private boolean clearCertStore(CertStore certStore) {
        boolean bl = true;
        try {
            certStore.load(true);
            Collection collection = certStore.getCertificates();
            if (collection != null && collection.size() > 0) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    certStore.remove((Certificate)iterator.next());
                }
                certStore.save();
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            bl = false;
        }
        return bl;
    }

    private void showRestoringSecurityPromptFailDialog() {
        String string = ResourceManager.getString("common.ok_btn");
        String string2 = ResourceManager.getString("common.detail.button");
        ToolkitStore.getUI().showMessageDialog(this.getTopLevelAncestor(), null, 0, ResourceManager.getMessage("cert.restore_dialog.fail.caption"), ResourceManager.getMessage("cert.restore_dialog.fail.masthead"), ResourceManager.getMessage("cert.restore_dialog.fail.text"), null, string, string2, null);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private JPanel createSecurityLevelPanel() {
        return new SecurityLevelPanel();
    }

    private JPanel createRuleSetViewerButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        FancyButton fancyButton = new FancyButton(ResourceManager.getMessage("deployment.ruleset.view.button"), ResourceManager.getMnemonic("deployment.ruleset.view.button"), Color.BLUE);
        fancyButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.showCurrentRuleSetDialog();
            }
        });
        jPanel.add((Component)fancyButton, "South");
        return jPanel;
    }

    private void showCurrentRuleSetDialog() {
        RuleSetViewerDialog ruleSetViewerDialog = new RuleSetViewerDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        ruleSetViewerDialog.setLocationRelativeTo(this);
        ruleSetViewerDialog.setVisible(true);
    }

    private JPanel createCertificationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.getMessage("security.certificates.restore_button.text"));
        jButton.setMnemonic(ResourceManager.getMnemonic("security.certificates.restore_button.text"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsRestoreBtnActionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText(this.getMessage("security.certs_restore_btn.tooltip"));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(this.getMessage("security.certificates.button.text"));
        jButton2.setMnemonic(ResourceManager.getMnemonic("security.certificates.button.text"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsBtnActionPerformed(actionEvent);
            }
        });
        jButton2.setToolTipText(this.getMessage("security.certs_btn.tooltip"));
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void decreaseFont(JComponent jComponent, int n) {
        Font font = jComponent.getFont();
        jComponent.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - n));
    }

    private JComponent createEnableJavaInBrowser() {
        Box box = Box.createHorizontalBox();
        this.enableBrowserCheckbox = new JCheckBox(ResourceManager.getMessage("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setMnemonic(ResourceManager.getAcceleratorKey("deployment.security.enable.java.browser"));
        this.enableBrowserCheckbox.setSelected(SecurityProperties.isJavaInBrowserEnabled());
        this.enableBrowserCheckbox.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SecurityPanel.this.enableBrowserCheckbox.isSelected();
                SecurityProperties.enableJavaInBrowser(bl);
                SecurityPanel.this.setTextForUserDisabledLabel();
            }
        });
        box.add(this.enableBrowserCheckbox);
        this.disabledForUserOnlyLabel = new JLabel("");
        this.decreaseFont(this.disabledForUserOnlyLabel, 2);
        this.setTextForUserDisabledLabel();
        box.add(this.disabledForUserOnlyLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void setTextForUserDisabledLabel() {
        if (SecurityProperties.isJavaInBrowserDisabledForUser()) {
            this.disabledForUserOnlyLabel.setText(ResourceManager.getMessage("deployment.security.java.browser.user.disabled"));
        } else {
            this.disabledForUserOnlyLabel.setText("");
        }
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        this.setTextForUserDisabledLabel();
        this.enableBrowserCheckbox.setSelected(javaEnableEvent.isEnabled());
    }
}

