define("$calendar",["$s"],function(){

	/*******************************************************************************
	 * 
	 ******************************************************************************/
	
	var g_monthName = new Array("","","","","","","","","","ʮ","ʮһ","");
	
	var tInfo = new Array(0x04bd8, 0x04ae0, 0x0a570, 0x054d5, 0x0d260, 0x0d950,
		0x16554, 0x056a0, 0x09ad0, 0x055d2, 0x04ae0, 0x0a5b6, 0x0a4d0, 0x0d250,
		0x1d255, 0x0b540, 0x0d6a0, 0x0ada2, 0x095b0, 0x14977, 0x04970, 0x0a4b0,
		0x0b4b5, 0x06a50, 0x06d40, 0x1ab54, 0x02b60, 0x09570, 0x052f2, 0x04970,
		0x06566, 0x0d4a0, 0x0ea50, 0x06e95, 0x05ad0, 0x02b60, 0x186e3, 0x092e0,
		0x1c8d7, 0x0c950, 0x0d4a0, 0x1d8a6, 0x0b550, 0x056a0, 0x1a5b4, 0x025d0,
		0x092d0, 0x0d2b2, 0x0a950, 0x0b557, 0x06ca0, 0x0b550, 0x15355, 0x04da0,
		0x0a5b0, 0x14573, 0x052b0, 0x0a9a8, 0x0e950, 0x06aa0, 0x0aea6, 0x0ab50,
		0x04b60, 0x0aae4, 0x0a570, 0x05260, 0x0f263, 0x0d950, 0x05b57, 0x056a0,
		0x096d0, 0x04dd5, 0x04ad0, 0x0a4d0, 0x0d4d4, 0x0d250, 0x0d558, 0x0b540,
		0x0b6a0, 0x195a6, 0x095b0, 0x049b0, 0x0a974, 0x0a4b0, 0x0b27a, 0x06a50,
		0x06d40, 0x0af46, 0x0ab60, 0x09570, 0x04af5, 0x04970, 0x064b0, 0x074a3,
		0x0ea50, 0x06b58, 0x055c0, 0x0ab60, 0x096d5, 0x092e0, 0x0c960, 0x0d954,
		0x0d4a0, 0x0da50, 0x07552, 0x056a0, 0x0abb7, 0x025d0, 0x092d0, 0x0cab5,
		0x0a950, 0x0b4a0, 0x0baa4, 0x0ad50, 0x055d9, 0x04ba0, 0x0a5b0, 0x15176,
		0x052b0, 0x0a930, 0x07954, 0x06aa0, 0x0ad50, 0x05b52, 0x04b60, 0x0a6e6,
		0x0a4e0, 0x0d260, 0x0ea65, 0x0d530, 0x05aa0, 0x076a3, 0x096d0, 0x04bd7,
		0x04ad0, 0x0a4d0, 0x1d0b6, 0x0d250, 0x0d520, 0x0dd45, 0x0b5a0, 0x056d0,
		0x055b2, 0x049b0, 0x0a577, 0x0a4b0, 0x0aa50, 0x1b255, 0x06d20, 0x0ada0,
		0x14b63);
		
	var minYear = 1901;
	var maxYear = 2049;
	var solarMonth = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	var Gan = new Array("", "", "", "", "", "", "", "", "", "");
	var Zhi = new Array("", "", "", "î", "", "", "", "δ", "", "", "", "");
	var Animals = new Array("", "ţ", "", "", "", "", "", "", "", "", "",
			"");
	var solarTerm = new Array("С", "", "", "ˮ", "", "", "", "", "",
			"С", "â", "", "С", "", "", "", "¶", "", "¶", "˪", "",
			"Сѩ", "ѩ", "");
	var sTermInfo = new Array(0, 21208, 42467, 63836, 85337, 107014, 128867,
			150921, 173149, 195551, 218072, 240693, 263343, 285989, 308563, 331033,
			353350, 375494, 397447, 419210, 440795, 462224, 483532, 504758);
	var nStr1 = new Array('', 'һ', '', '', '', '', '', '', '', '', 'ʮ');
	var nStr2 = new Array('', 'ʮ', 'إ', 'ئ', '');

	var sFtv = new Array("0101*Ԫ&Ԫ()", "0106 &й13˿", "0108 &ܶ",
		"0121 & ԮϷ", "0202 &ʪ", "0207 &·չ(1923)",
		"0210 &", "0214 ˽&˽(ʥ׶)", "0215 &й12˿(1995)",
		"0219 &Сƽ(1997)", "0221 &ĸ(2000) ֳƶȶ(1949)",
		"0224 &", "0228 &ס(2003)", "0301 &ʺ(1983)",
		"0303 &ȫ(2000) һ(ձŮ)",
		"0305 &ѧ׷(1963) й־Ը߷(2000) ܶ(1898)",
		"0308 Ů&ͶŮ(1910)", "0309 &ĸ׺", "0311 &",
		"0312 ֲ&йֲ(1979) ɽ(1925)",
		"0314 &ʾ ɫ˽ ˼(1883)", "0315 &Ȩ(1983)",
		"0316 &ϵƶСȫͳһж", "0317 &йҽ(1929) ʺ ʥ˽",
		"0318 &ȫƼ˲Ż",
		"0321 &ɭ(1972) ӹ(1966) (1976) ˯(2001)",
		"0322 &ˮ(1993)", "0323 &(1960)", "0324 &ν˲(1996)",
		"0329 &йƻʮʿѳѼ", "0330 &˹̹(1962)",
		"0401 ˽&˽ ȫ˶() ˰()", "0402 &ʶͯͼ",
		"0407 &(1955)", "0411 &ɭ", "0421 &ȫҵһ(1994)",
		"0422 &(1970) 編 (1870)", "0423 &ͼͰȨ(1995)",
		"0424 &ǷŹ 귴ֳ(1957)", "0425 &ȫͯԤ(1986)",
		"0426 &֪ʶȨ(2001)", "0430 &罻ͨȫ˼", "0501*Ͷ&Ͷ(1889)",
		"0503 &", "0504 &й(1939) Ƽ",
		"0505 &ȱ ձк ˼(1818) ȫ(1992)",
		"0508 &΢Ц ʮ(1948)", "0512 &ʻʿ 봨(2008)",
		"0515 &ʼͥ(1994) ȫȱ(1994)", "0517 &ʵ(1969)",
		"0518 &ʲ(1977)", "0520 &ȫѧӪ(1990) ȫĸι(1990)",
		"0522 &Թ(2000)", "0525 &޽(1963)", "0526 &ս",
		"0530 &ئԵ۹˶(1925)", "0531 &(1988) Ӣݼ",
		"0601 ͯ&ʶͯ(1949)", "0605 &绷(1974)", "0606 &簮գ1996",
		"0611 &й˿գ1974", "0614 &Ѫ(2005)", "0617 &λĮ͸ɺ(1995)",
		"0620 &(2001)", "0622 &йͯƻ", "0623 &ʰƥ(1948)",
		"0625 &ȫ(1991)",
		"0626 &ʽ(1987) (1945) ֹҩúͷǷ˹(1987) ֧Ԯܺ߹(1997)",
		"0630 &", "0701 &й(1921) ۻع(1997) ʽ(1985)",
		"0702 &", "0706 &", "0707 &йս(1937)",
		"0711 &˿(1987) й", "0726 &ﴴ", "0728 &һս(1914)",
		"0730 &޸Ů(1962)", "0801 &йž(1927)",
		"0805 &˹(1895)", "0806 &ʵӰ(1932)", "0808 &йӽ(ְֽ)(1988)",
		"0812 &", "0813 &Ʋ(1976)", "0815 &ձʽͶ(1945)",
		"0822 &Сƽ(1904)", "0823 &ūϳĹʼ", "0826 &ȫʦѯ(1993)",

		"0902 &ձǩͶ(1945)", "0903 &йսʤ(1945)",
		"0908 &ɨä(1966) Ź(1958)", "0909 &ë(1976)",
		"0910 ʦ&йʦ(1985) Ԥɱ(2003)", "0914 &",
		"0916 &ʳ㱣(1994) йԽ", "0918 &šһ±(1931)",
		"0920 &ʰ(1989)", "0921 &ʺƽ(1981) ԤԳմ(1994)",
		"0927 &(1980)", "0928 &ӵ", "0930 &ʷ(1991)",

		"1001*&(1949) (1980) ˽(1990)",
		"1002*&ڼ ʺƽɶ", "1003*&ڼ", "1004 &綯",
		"1005 &ʦ(1944)", "1008 &ȫѪѹ(1998) Ӿ", "1009 &",
		"1010 &(1911) (1992) ", "1011 &ʹ(2004)",
		"1012 &60˿(1999)",
		"1013 &籣(1950) йȷӵ(1949) 籣(1950)", "1014 &׼(1969)",
		"1015 &ä˽(Ƚ)", "1016 &ʳ", "1017 &ƶ",
		"1020 &(1997)", "1022 &紫ͳҽҩ", "1024 &Ϲ 緢չ",
		"1025 &Ԯ(1950)", "1028 &йԽ(2000)", "1031 &ڼ",
		"1101 ʥ&ʥ ֲ", "1106 &ֹսװͻ̣(2001)",
		"1107 &ʮ(1917)", "1108 &й߽", "1109 &ȫȫ",
		"1110 &", "1111 & ʿѧƽ",
		"1112 &ɽ(1866) (1969)", "1114 &(1995)",
		"1116 &ʿ(1995)", "1117 &ʴѧ", "1120 &ʶͯ",
		"1121 &ʺ(1973) ", "1125 &ԸŮıΪ(1999)",
		"1128 &˹(1820)", "1129 &Ԯ˹̹(1977)",

		"1201 &簬̲", "1202 &ϳū", "1203 &м", "1204 &ȫ",
		"1205 &ʾúᷢչ־ԸԱ ǿ ʿ", "1207 &", "1208 &ʶͯ",
		"1209 &һ˶(1935) (1863) ʷ", "1210 &Ȩ(1950)",
		"1211 &(2001)", "1212 &±(1935)", "1213 &Ͼɱ(1937)",
		"1215 &ǿ", "1218 &(2000)", "1220 &Żع(1999)",
		"1221 &(1981)", "1224 ƽҹ&ƽҹ", "1225 ʥ&ʥ",
		"1226 &ë󶫵(1893)", "1229 &(1994)")

	// ũ *ʾż
	var lFtv = new Array("0101*& һ շ𵮳",
			//, "0102*&",
			"0115 Ԫ&Ԫ", "0505*&", "0707 Ϧ&Ϧ˽",
			"0715 Ԫ&Ԫ", "0815*&", "0909 &",
			"1208 ˽&˽(ɵ)", "1223 С&С", "0100*Ϧ&Ϧ")

	// ĳµĵڼڼ
	var wFtv = new Array(
			"0150 &", // һµһգµһգ
			"0351 &ȫСѧȫ(1996)", "0440 &ͯ(1986)", "0453 &",
			"0512 &(1998)", "0520 ĸ׽&ĸ׽ ƶĸ", "0530 &ȫ(1990)",
			"0532 &ţ(1961)", "0626 &йĻŲ(2006)", "0630 ׽&ʸ׽(1934)",
			"0716 &ʺ(1995)", "0932 &ʺƽ(1981)", "0936 &ȫ(2001)",
			"0940 &˽(1958)", "0950 &纣 ಡ(2000)", "1011 &ס(1986)",
			"1024 &Ӿ", "1023 &ʼȻֺ(1990)", "1144 ж&ж",
			"1220 &ʶͯӹ㲥")
	var constellationArr = new Array("ˮƿ", "˫", "", "ţ", "˫", "з", "ʨ", "Ů", "",   
		 "Ы", "", "Ħ");
	

	var constellationLinkArr = new Array(	
		"http://astro.women.sohu.com/aquarius.shtml",
		"http://astro.women.sohu.com/pisces.shtml",
		"http://astro.women.sohu.com/aries.shtml",
		"http://astro.women.sohu.com/taurus.shtml",
		"http://astro.women.sohu.com/gemini.shtml",
		"http://astro.women.sohu.com/cancer.shtml",
		"http://astro.women.sohu.com/leo.shtml",
		"http://astro.women.sohu.com/virgo.shtml",
		"http://astro.women.sohu.com/libra.shtml",
		"http://astro.women.sohu.com/scorpius.shtml",
		"http://astro.women.sohu.com/sagittarius.shtml ",
		"http://astro.women.sohu.com/capricornus.shtml");
	
	var constellationEdgeDay = new Array (21, 19, 21, 21, 22, 22, 23, 24, 24, 24, 23, 22);
	
	
	function Ajax(args) {
		this.url = args.url || "";
		this.params = args.params || "";
		this.mime = args.mime || "text/html";
		this.onComplete = args.onComplete || this.defaultOnCompleteFunc;
		this.onLoading= args.onLoading || this.defaultOnLoadingFunc;
		this.onError = args.onError || this.defaultOnErrorFunc;
		this.method = args.method || "post";
		this.loadData();
	}

	Ajax.prototype = {
		READY_STATE_COMPLETE : 4,
		getRequest : function () {
		var funcs = [
			function() {return new ActiveXObject('Msxml2.XMLHTTP')},
			function() {return new ActiveXObject('Microsoft.XMLHTTP')},
			function() {return new XMLHttpRequest()}
		];

		var req = null;
		for (var i = 0; i < funcs.length; i++) {
			var f = funcs[i];
			try {
			req = f();
			break;
			} catch (e) {}
		}

		return req || false;
		},

		parseParams : function () {
		if (typeof (this.params) == "string") {
			return this.params;
		} else {
			var s = "";
			for (var k in this.params) {
			s += k + "=" + this.params[k] + "&";
			}
			return s;
		}
		},

		loadData : function () {
		this.req = this.getRequest();
		
		if (this.req) {
			this.onLoading();
			try {
			var loader = this;
			this.req.onreadystatechange = function () {
				if (loader.req.readyState == loader.READY_STATE_COMPLETE) {
					loader.onComplete.call(loader, loader.req);
				}
			}
			this.req.open(this.method, this.url, true);

			if (this.method == "post") {
				this.req.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
			}

			if (this.req.overrideMimeType) {
				this.req.overrideMimeType(this.mime);
			}
			//this.req.send(this.method == "post" ? this.parseParams(this.params) : null);
			} catch (e) {
			// throw e
			this.onError.call(this, e);
			}
		}
		},

		defaultOnCompleteFunc : function () {
		alert(this.req.responseText);
		},

		defaultOnLoadingFunc : function () {
		},

		defaultOnErrorFunc : function (error) {
		alert(error);
		}
	}
	
	/*******************************************************************************
	 * ڼ
	 ******************************************************************************/

	// ====================================== ·ݺڷ
	function constellate(month , day ) {
		if (day < constellationEdgeDay[month]) {   
			month = month - 1;   
		}   
		if (month >= 0) {   
			return new Array(constellationArr[month],constellationLinkArr[month]);   
		}   
		return new Array(constellationArr[11],constellationLinkArr[11]);
	}
	// ====================================== ũ y
	function lYearDays(y) {
		var i, sum = 348;
		for (i = 0x8000; i > 0x8; i >>= 1)
			sum += (tInfo[y - 1900] & i) ? 1 : 0;
		return (sum + leapDays(y));
	}

	// ====================================== ũ yµ
	function leapDays(y) {
		if (leapMonth(y))
			return ((tInfo[y - 1900] & 0x10000) ? 30 : 29);
		else
			return (0);
	}

	// ====================================== ũ yĸ 1-12 , û򷵻 0
	function leapMonth(y) {
		return (tInfo[y - 1900] & 0xf);
	}

	// ====================================== ũ ymµ
	function monthDays(y, m) {
		return ((tInfo[y - 1900] & (0x10000 >> m)) ? 30 : 29);
	}

	// ====================================== ũ, ڿؼ, ũڿؼ
	// ÿؼ .year .month .day .isLeap
	function Lunar(objDate) {

		var i, leap = 0, temp = 0;
		var offset = (Date.UTC(objDate.getFullYear(), objDate.getMonth(), objDate
				.getDate()) - Date.UTC(1900, 0, 31)) / 86400000;

		for (i = 1900; i <= maxYear && offset > 0; i++) {
			temp = lYearDays(i);
			offset -= temp;
		}

		if (offset < 0) {
			offset += temp;
			i--;
		}

		this.year = i;

		leap = leapMonth(i); // ĸ
		this.isLeap = false;

		for (i = 1; i < 13 && offset > 0; i++) {
			// 
			if (leap > 0 && i == (leap + 1) && this.isLeap == false) {
				--i;
				this.isLeap = true;
				temp = leapDays(this.year);
			} else {
				temp = monthDays(this.year, i);
			}

			// 
			if (this.isLeap == true && i == (leap + 1))
				this.isLeap = false;

			offset -= temp;
		}

		if (offset == 0 && leap > 0 && i == leap + 1)
			if (this.isLeap) {
				this.isLeap = false;
			} else {
				this.isLeap = true;
				--i;
			}

		if (offset < 0) {
			offset += temp;
			--i;
		}

		this.month = i;
		this.day = offset + 1;
	}

	// ==============================ع yĳm+1µ
	function solarDays(y, m) {
		if (m == 1)
			return (((y % 4 == 0) && (y % 100 != 0) || (y % 400 == 0)) ? 29 : 28);
		else
			return (solarMonth[m]);
	}
	// ==============================  offset ظ֧, 0=
	function cyclical(num) {
		return (Gan[num % 10] + Zhi[num % 12]);
	}

	// ============================== 
	function calElement(sYear, sMonth, sDay, week, lYear, lMonth, lDay, isLeap,
			cYear, cMonth, cDay) {

		this.isToday = false;
		// 
		this.sYear = sYear; // Ԫ4λ
		this.sMonth = sMonth; // Ԫ
		this.sDay = sDay; // Ԫ
		this.week = week; // , 1
		// ũ
		this.lYear = lYear; // Ԫ4λ
		this.lMonth = lMonth; // ũ
		this.lDay = lDay; // ũ
		this.isLeap = isLeap; // ǷΪũ?
		// 
		this.cYear = cYear; // , 2
		this.cMonth = cMonth; // , 2
		this.cDay = cDay; // , 2

		this.color = '';

		this.lunarFestival = ''; // ũ
		this.solarFestival = ''; // 

		this.estDayFestival = ''; // Ҳʾĸ
		this.weekFestival = ''; // ҲʾصĽ
		this.dateFestival = '';// ҲʾصĹ
		this.lliFestival = '';// Ҳʾصũ

		this.solarTerms = ''; // 
	}

	// ===== ĳĵnΪ(0С)
	var fixsTerm={"19091":21, "19102":5, "19106":6, "19118":7, "19120":7, "191218":9, "191221":23, "191317":24, "19179":21, "192716":8, "192811":21, "193510":6, "19421":21, "19432":5, "19436":6, "19450":6, "194723":23, "19507":20, "195022":8, "195123":23, "19525":21, "195513":23, "19563":20, "195720":8, "195812":7, "195815":23, "196016":7, "196111":21, "19738":5, "197421":23, "19751":21, "197517":23, "19762":5, "19774":6, "197714":7, "19780":6, "197821":23, "19799":21, "19802":5, "198023":22, "19814":6, "19820":6, "198322":8, "198413":22, "198423":22, "19855":21, "198712":7, "198813":22, "19893":19, "198916":7, "199011":21, "199020":8, "199112":7, "199115":23, "199411":21, "199710":5, "20068":5, "200614":7, "200721":23, "20081":21, "200817":22, "20092":4, "20104":6, "201014":7, "20110":6, "201121":23, "20121":21, "20129":20, "201222":7, "20132":4, "201313":22, "201323":22, "20144":6, "20150":6, "201622":7, "201713":22, "201723":22, "20183":19, "20185":21, "201911":21, "202012":6, "202015":22, "202022":7, "20223":19, "202216":7, "202311":21, "202319":24, "202320":8, "202415":22, "202610":5, "203010":5, "20358":5, "203514":7, "20371":20, "203914":7, "20400":6, "204018":8, "204021":22, "20411":20, "20419":20, "20422":4, "20434":6, "204314":7, "20440":6, "204421":22, "20451":20, "20457":19, "20459":20, "204522":7, "20462":4, "204613":22, "204623":22, "20474":6, "20480":6, "204811":20, "204912":6, "204915":22, "204922":7};
	function sTerm(y, n) {
		if (fixsTerm[y+""+n]){
			return fixsTerm[y+""+n];
		}
		var offDate = new Date((31556925974.7 * (y - 1900) + sTermInfo[n] * 60000)
				+ Date.UTC(1900, 0, 6, 2, 5));
		return (offDate.getUTCDate());
	}

	// ============================== ؼ (y,m+1)
	/*
	 * ˵: µϿؼ
	 * 
	 * ʹ÷ʽ: OBJ = new calendar(,);
	 * 
	 * OBJ.length ص OBJ.firstWeek صһ OBJ.lastWeek صһ
	 * 
	 *  OBJ[]. ȡøֵ
	 * 
	 * OBJ[].isToday ǷΪ true  false
	 * 
	 *  OBJ[] Բμ calElement() еע
	 */
	function calendar(y, m, tY, tM, tD) {

		var sDObj, lDObj, lY, lM, lD = 1, lL, lX = 0, tmp1, tmp2, tmp3, tmp4, tmp5;
		var cY, cM, cD; // ,,
		var lDPOS = new Array(3);
		var n = 0;
		var firstLM = 0;

		sDObj = new Date(y, m, 1, 0, 0, 0, 0); // һ

		this.length = solarDays(y, m); // 
		this.firstWeek = sDObj.getDay(); // 1ڼ
		this.lastWeek = new Date(y, m, this.length, 0, 0, 0, 0).getDay();

		// ////// 1900Ϊ(6036)
		if (m < 2)
			cY = cyclical(y - 1900 + 36 - 1);
		else
			cY = cyclical(y - 1900 + 36);
		var term2 = sTerm(y, 2); // 

		// ////// 19001СǰΪ (6012)
		var firstNode = sTerm(y, m * 2) // ص¡ڡΪտʼ
		cM = cyclical((y - 1900) * 12 + m + 12);

		// һ 1900/1/1 
		// 1900/1/1 1970/1/1 25567, 1900/1/1 Ϊ(6010)
		var dayCyclical = Date.UTC(y, m, 1, 0, 0, 0, 0) / 86400000 + 25567 + 10;

		for ( var i = 0; i < this.length; i++) {

			if (lD > lX) {
				sDObj = new Date(y, m, i + 1); // һ
				lDObj = new Lunar(sDObj); // ũ
				lY = lDObj.year; // ũ
				lM = lDObj.month; // ũ
				lD = lDObj.day; // ũ
				lL = lDObj.isLeap; // ũǷ
				lX = lL ? leapDays(lY) : monthDays(lY, lM); // ũһ

				if (n == 0)
					firstLM = lM;
				lDPOS[n++] = i - lD + 1;
			}

			// ·ֵ, Ϊ
			if (m == 1 && (i + 1) == term2)
				cY = cyclical(y - 1900 + 36);
			// , ԡڡΪ
			if ((i + 1) == firstNode)
				cM = cyclical((y - 1900) * 12 + m + 13);
			// 
			cD = cyclical(dayCyclical + i);

			// sYear,sMonth,sDay,week,
			// lYear,lMonth,lDay,isLeap,
			// cYear,cMonth,cDay
			this[i] = new calElement(y, m + 1, i + 1,
					nStr1[(i + this.firstWeek) % 7], lY, lM, lD++, lL, cY, cM, cD);
		}

		// 
		tmp1 = sTerm(y, m * 2) - 1;
		tmp2 = sTerm(y, m * 2 + 1) - 1;
		this[tmp1].solarTerms = solarTerm[m * 2];
		this[tmp2].solarTerms = solarTerm[m * 2 + 1];

		if (m == 3)
			this[tmp1].color = 'red'; // ɫ

		// ֻ34
		if (m == 2 || m == 3) {
			var estDay = new easter(y);
			if (m == estDay.m) {
				this[estDay.d - 1].solarFestival = '';
				this[estDay.d - 1].estDayFestival = "";
			}
		}

		// ܽ
		for (i in wFtv)
			if (wFtv[i].match(/^(\d{2})(\d)(\d)([\s\*])(.+)$/))
				if (Number(RegExp.$1) == (m + 1)) {
					tmp1 = Number(RegExp.$2);
					tmp2 = Number(RegExp.$3);
					tmp4 = RegExp.$5;
					tmp5 = tmp4.split('&');
					if (tmp5[0].length > 0) {
					if (tmp1 < 5) {
						this[((this.firstWeek > tmp2) ? 7 : 0) + 7 * (tmp1 - 1)
								+ tmp2 - this.firstWeek].solarFestival = tmp5[0];
						this[((this.firstWeek > tmp2) ? 7 : 0) + 7 * (tmp1 - 1)
								+ tmp2 - this.firstWeek].weekFestival = tmp5[1];
					} else {
						tmp1 -= 5;
						tmp3 = (this.firstWeek + this.length - 1) % 7; // һ?
						this[this.length - tmp3 - 7 * tmp1 + tmp2
								- (tmp2 > tmp3 ? 7 : 0) - 1].solarFestival = tmp5[0];
						this[this.length - tmp3 - 7 * tmp1 + tmp2
								- (tmp2 > tmp3 ? 7 : 0) - 1].weekFestival = tmp5[1];
					}
					}
				}

		// 
		for (i in sFtv)
			if (sFtv[i].match(/^(\d{2})(\d{2})([\s\*])(.+)$/)){
				tmp4 = RegExp.$4;
				if (Number(RegExp.$1) == (m + 1)) {
					var tmpDay = Number(RegExp.$2) - 1;
					var tmpStar = RegExp.$3;
					tmp5 = tmp4.split('&');
					if (tmp5[0].length >0) {
					this[tmpDay].solarFestival = tmp5[0];
					
					if (tmpStar == '*')
						this[tmpDay].color = 'red';
					}
					if(tmp5[1].length>0)
						this[tmpDay].dateFestival = tmp5[1];
			}
		}

		// ũ
		for (i in lFtv)
			if (lFtv[i].match(/^(\d{2})(.{2})([\s\*])(.+)$/)) {
				tmp1 = Number(RegExp.$1) - firstLM;
				if (tmp1 == -11)
					tmp1 = 1;
				if (tmp1 >= 0 && tmp1 < n) {
					tmp2 = lDPOS[tmp1] + Number(RegExp.$2) - 1;
					if (tmp2 >= 0 && tmp2 < this.length
							&& this[tmp2].isLeap != true) {
						tmp4 = RegExp.$4;
						var tmpStar = RegExp.$3;
						tmp5 = tmp4.split('&');
						this[tmp2].lunarFestival += tmp5[0];
						this[tmp2].lliFestival += tmp5[1];
						if (tmpStar == '*')
							this[tmp2].color = 'red';
					}
				}
			}

		// 
		//alert(y+","+tY+" -- "+m+","+tM);
		//alert(tD)
		if (y == tY && m == tM)
			this[tD - 1].isToday = true;
	}

	// ======================================= ظĸ(ֺһܺĵһ)
	function easter(y) {

		var term2 = sTerm(y, 5); // ȡô
		var dayTerm2 = new Date(Date.UTC(y, 2, term2, 0, 0, 0, 0)); // ȡôֵĹڿؼ(һ3)
		var lDayTerm2 = new Lunar(dayTerm2); // ȡȡôũ

		if (lDayTerm2.day < 15) // ȡ¸Բ
			var lMlen = 15 - lDayTerm2.day;
		else
			var lMlen = (lDayTerm2.isLeap ? leapDays(y) : monthDays(y,
					lDayTerm2.month))
					- lDayTerm2.day + 15;

		// һ 1000*60*60*24 = 86400000 
		var l15 = new Date(dayTerm2.getTime() + 86400000 * lMlen); // һԲΪ
		var dayEaster = new Date(l15.getTime() + 86400000 * (7 - l15.getUTCDay())); // ¸

		this.m = dayEaster.getUTCMonth();
		this.d = dayEaster.getUTCDate();

	}

	// ====================== 
	function cDay(d) {
		var s;

		switch (d) {
		case 10:
			s = 'ʮ';
			break;
		case 20:
			s = 'ʮ';
			break;
		case 30:
			s = 'ʮ';
			break;
		default:
			s = nStr2[Math.floor(d / 10)];
			s += nStr1[d % 10];
		}
		return (s);
	}
	
	
	/****************************************************************/
	
	function GC(elem,cn,tag){
		if(!elem)	return [];
		tag = tag || "*";
		var list = elem.getElementsByTagName(tag);
		var arr = [];
		for(var i=0;i<list.length;i++){
			var item = list[i];
			var classNames = " "+item.className+" ";
			if(classNames.indexOf(" "+cn+" ") > -1)
				arr.push(item);
		}
		return arr;
	}
	
	function jumpMonth(step,year,month){
		month = +month;
		year = +year;
		month = month + step;
		if(month < 1) return {year:year-1,month:12};
		else if(month > 12) return {year:year+1,month:1};
		return {year:year,month:month};
	}
	
	function cutFestival(str){
		if(str.length <= 4) return str;
		return str.substring(0,3)+"...";
	}
	
	//ȡũڻ
	function getLunarDay(src){
		var item = {};
		if(src.solarTerms) item.fest = src.solarTerms;
		else if(src.solarFestival) item.fest = src.solarFestival;
		else if(src.lunarFestival) item.fest = src.lunarFestival;
		else {item.fest = cDay(src.lDay); item.className="";}
		if(item.className !== "") item.className = "calendar_jie";
		return item;
	}
	
	function getAnimal(year){
		var index = (year-1900)%12;
		return Animals[index];
	}
	
	/*******ȾHTML*******/
	function renderCalendar(){
		var html = [];
		html.push('<div class="datebox cf" id="'+this.id+'">');
		html.push(renderLeft.call(this));
		html.push(renderRight.call(this));
		html.push('</div>');
		return html.join('');
	}
	
//	function renderRightCont(src){
//		var right = $s.$(this.rightId);
//		var year = this.year;
//		var month = this.month;
//		var day = this.day;
//		if(!src){
//			var tmp = new calendar(year,month-1,2000,1,1);
//			src = tmp[day-1];
//		}
//		if(src){
//			year = src.sYear;
//			month = src.sMonth;
//			day = src.sDay;
//		}
//		
//		var animal = getAnimal(src.lYear);
//		var xingzuo = constellate(month-1,day)[0];
//		
////		var html = [];
////		html.push('<div class="top_txt">');
////		html.push('<div>Ԥ</div>');
////		html.push('<h2>'+year+''+month+'</h2>');
////		html.push('<p class="calendar_right_day">'+day+'</p>');
////		html.push('<p class="calendar_right_lunar">');
////		html.push('<span>'+src.week+'</span>');
////		html.push('<span>'+src.cYear+'꡾'+animal+'꡿</span>');
////		html.push('<span>'+g_monthName[src.lMonth-1]+cDay(src.lDay)+'</span>');
////		html.push('<span>'+xingzuo+'</span>');
////		html.push('</p>');
////		html.push('</div>');
////		html.push('<div id="'+this.fitId+'" class="calendar_right_yi cf"></div>');
////		html.push('<div id="'+this.badId+'" class="calendar_right_yi cf"></div>');
////		right.innerHTML = html.join('');
//		gethuangli.call(this,year,month,day);
//	}
	
	/*****ȾҲ*****/
	function renderRight(){
		var html = [];
		html.push('<div id="'+this.rightId+'" class="calendar_right">');
		html.push('</div>');
		return html.join('');
	}
	
	/*******Ⱦ********/
	function renderLeft(){
		var html  = [];
		html.push('<div class="calendar_left">');
		html.push(renderTop.call(this));
		html.push(renderCenter.call(this));
		html.push('</div>')
		return html.join('');
	}
	
	/************ȡ*************/
	function getGuide(holidays){
		var guides = [];
		for(var i=0;i<holidays.length;i++){
			var item = holidays[i].guide;
			guides = guides.concat(item);
		}
		return guides;
	}
	
	/************жϹ*************/
	function testGuide(year,month,day){
		var guide = this.guide;
		var txt = {vacation:"",work:"",leave:""};
		for(var i=0;i<guide.length;i++){
			var item = guide[i];
			if(item.year == year && item.month == month && item.day == day){
				return {className:"calendar_"+item.type,txt:txt[item.type],type:item.type};
			}
		}
		return "";
	}
	
	/************ȡ*************/
	function getClass(src){
		var opts = this.options;
		var month = this.month;
		var cls = [];
		if(src.sMonth != month) cls.push('calendar_other');
		else if( "".indexOf(src.week) != -1 ) cls.push('calendar_red');
		var c = testGuide.call(this,src.sYear,src.sMonth,src.sDay);
		if(c) cls.push(c.className);
		if(src.sYear == opts.nyear && src.sMonth == opts.nmonth && src.sDay == opts.nday){
			cls.push('calendar_today');
		}
		if(src.sYear == this.year && src.sMonth == this.month && src.sDay == this.day)
			cls.push('on_date');
		return cls.join(' ');
	}
	
	
	function getCellHTML(item){
		var inner = [];
		inner.push('<div style="width:42px;height:36px;overflow:hidden;" class="calendar_new">');
		inner.push('<a class="'+getClass.call(this,item)+'" href="#" data-year="'+item.sYear+'" data-month="'+item.sMonth+'" data-day="'+item.sDay+'">');
		var guide = testGuide.call(this,item.sYear,item.sMonth,item.sDay);
		if(guide) inner.push('<em class="'+guide.type+'_icon">'+guide.txt+'</em>');
		inner.push('<span class="calendar_new_daynumber">'+item.sDay+'</span>')
		var festObj = getLunarDay(item);
		var festival = festObj.fest;
		inner.push('<span title="'+(festival.length>4?festival:'')+'" class="calendar_new_almanac '+festObj.className+'">'+cutFestival(festival)+'</span>')
		inner.push('</a>')
		inner.push('</div>');
		return inner.join('');
	}
	
	/******Ⱦڱ*****/
	function renderTable(flag){
	
		var year = this.year;
		var month = this.month;
		var day = this.day;
		var opt = this.options;
		var nyear = opt.nyear;
		var nmonth = opt.nmonth;
		var nday = opt.nday;
	
	
		var week = "һ".split("");
		week[5] = "<span id=\"vocation_week_title\"></span>";
		week[6] = "<span id=\"vocation_week_title\"></span>";
	
		var table = $s.$(this.tableId);
		var children = table.childNodes;
		for(var i=children.length-1;i>=0;i--){
			if(children[i].nodeType == 1){
				table.removeChild(children[i]);
			}
		}
		
		var tbody = document.createElement("tbody");
		table.appendChild(tbody);
		
		var tr = document.createElement("tr");
		for(var i=0;i<week.length;i++){
			var th = document.createElement("th");
			th.innerHTML = '<span>'+week[i]+'</span>';
			tr.appendChild(th);
		}
		tbody.appendChild(tr);
		
		var rows = 0;
		var curMonth = new calendar(year,month-1,nyear,nmonth-1,nday);
		this.day = this.day<curMonth.length?this.day:curMonth.length;
		tr = document.createElement("tr");
		tr.className = "pd";
		if(curMonth.firstWeek != 1){
			var prev = jumpMonth(-1,year,month);
			var lastMonth = new calendar(prev.year,prev.month-1,nyear,nmonth-1,nday);
			for(var i=0;i<lastMonth.lastWeek;i++){
				var len = lastMonth.length;
				var item = lastMonth[len-lastMonth.lastWeek+i];
				var td = document.createElement("td");
				td.innerHTML = getCellHTML.call(this,item);
				tr.appendChild(td);
			}
		}
		
		for(var i=0;i<curMonth.length;i++){
			var item = curMonth[i];
			var td = document.createElement("td");
			td.innerHTML = getCellHTML.call(this,item);
			tr.appendChild(td);
			if(item.week == ""){
				tbody.appendChild(tr);
				rows++;
				tr = document.createElement("tr");
			}
		}
		
		var sy = 7;
		if(curMonth.lastWeek == 0 && rows > 4) sy = 0;
		
		var tableClass = (rows>5||(rows==5&&sy==7))?"calenda_table":"calenda_table calenda_table_mr";
		table.parentNode.className = tableClass;
		
		var current_nextMonth_day = 1;
		var next = jumpMonth(1,year,month);
		var nextMonth = new calendar(next.year,next.month-1,nyear,nmonth-1,nday);
		if(sy > 0){
			for(var i=0;i<7-curMonth.lastWeek;i++){
				var item = nextMonth[i];
				current_nextMonth_day = i;
				var td = document.createElement("td");
				td.innerHTML = getCellHTML.call(this,item);
				tr.appendChild(td);
				if(item.week == ""){
					tbody.appendChild(tr);
					
					rows++;
					tr = document.createElement("tr");
				}
			}
		}
		
		if(rows < 6){
			//һУֻе
			for(var j=0;j<7;j++){
				i = ++current_nextMonth_day;
				var item = nextMonth[i];
				var td = document.createElement("td");
				td.innerHTML = getCellHTML.call(this,item);
				tr.appendChild(td);
				if(item.week == ""){
					tbody.appendChild(tr);
				}
			}
		}
			
		var holidayName = getHolidayName.call(this);
		renderTipCont.call(this,holidayName);
		if(flag){
			renderHolidayHTML.call(this,year);
			renderSelect(this.yselId,"data-year",year);
		}
		renderSelect(this.mselId,"data-month",month);
	}
	
	/****Ⱦм䲿***/
	function renderCenter(){
		var html = [];
		html.push('<div class="calenda_table calenda_table_mr">');
		html.push('<table id="'+this.tableId+'" width="100%" border="0">');
		html.push('</table>');
		html.push('</div>');
		return html.join('');
	}
	
	function renderHolidayHTML(year){
		
		var html = [];
		var holi = [];
		var elem = $s.$(this.holiId);
		
		var holidays = this.options.holiday;
		for(var i=0;i<holidays.length;i++){
			var item = holidays[i];
			var date = item.date.substring(0,4);
			if(date == year) holi.push(item);
		}
		if(holi.length == 0){
			elem.parentNode.style.visibility = "hidden";
			return;
		}
		elem.parentNode.style.visibility = "visible";
		var span = $s.$$(elem,"span")[0];
		
		span.innerHTML = "";
		var ul = $s.$$(elem.parentNode,"ul")[0];
		html.push('<li><a href="#"></a></li>');
		for(var i=0;i<holi.length;i++){
			html.push('<li><a href="#" data-holi="'+holi[i].content+'" data-date="'+holi[i].date+'">'+holi[i].content+'</a></li>');
		}
		ul.innerHTML = html.join('');
	}
	
	/*Ⱦͷ*/
	function renderTop(){
		var year = this.year;
		var month = this.month;
		var holidays = this.options.holiday;
		var sYear = this.sYear;
		var eYear = this.eYear;
		
		var html = [];
		
		html.push('<div id="'+this.topId+'" class="calendar_top cf">');
		/*****************************/
		html.push('<div class="ca_tag">');
		html.push('<p class="ca_tagT _ySelect" style="*font-size:12px;cursor:pointer;width:72px;overflow:hidden;"><span data-year="'+year+'">'+year+'</span><i></i></p>');
		html.push('<ul id="'+this.yselId+'" class="ca_taglist" style="width:72px;display:none;">');
		for(var i=sYear;i<=eYear;i++){
			var cls = i==year?"on":"";
			html.push('<li class="'+cls+'"><a data-year="'+i+'" href="#">'+i+'</a></li>');
		}
		html.push('</ul>');
		html.push('</div>');
		/*****************************/
		html.push('<div class="ca_tag ca_tag2 cf" style="">');
		html.push('<a class="left_btn" href="#"></a>');
		html.push('<a class="right_btn" href="#"></a>');
		html.push('<p class="ca_tagT _mSelect" style=""><span data-month="'+month+'">'+month+'</span><i></i></p>');
		html.push('<ul id="'+this.mselId+'" class="ca_taglist" style="display:none;">');
		for(var i=1;i<=12;i++){
			var cls = i==month?"on":"";
			html.push('<li class="'+cls+'"><a data-month="'+i+'" href="#">'+i+'</a></li>');
		}
		html.push('</ul>');
		html.push('</div>');
		/*****************************/
		html.push('<div class="black_td" style="cursor:pointer"></div>');
		html.push('<div class="ca_tag ca_tag3 cf">');
		html.push('<p id="'+this.holiId+'" class="ca_tagT _hSelect" style=""><span style="*height:18px;overflow:hidden;">żٰ</span><i style="*height:18px;overflow:hidden;"></i></p>');
		html.push('<ul class="ca_taglist" style="width:70px;display:none;">');
		html.push('<li><a href="#"></a></li>');
		for(var i=0;i<holidays.length;i++){
			var item = holidays[i];
			html.push('<li><a data-date='+item.date+' href="#">'+item.content+'</a></li>');
		}
		html.push('</ul>');
		html.push('</div>');
		html.push('</div>');
		
		return html.join('');
	}
	
	function renderTip(){
		var tip = document.createElement("div");
		tip.id = this.tipId;
		tip.className = "calendar_text";
		tip.style.display = "none";
		var main = $s.$(this.id);
		var parent = main.parentNode;
		parent.appendChild(tip);
	}
	
	function renderTipHtml(item){
		var tip = item.tips;
		var tipBox = $s.$(this.tipId);
		var html = [];
		for(var i=0;i<tip.length;i++){
			var t = tip[i];
			html.push('<dl>');
			html.push('<dt>'+t.col1+'</dt>');
			if(t.col2) html.push('<dd>'+t.col2+'</dd>');
			html.push('</dl>');
		}
		tipBox.innerHTML = html.join('');
		tipBox.style.display = "";
	}
	
	function renderTipCont(name){
		var holiday = this.options.holiday;
		$s.$(this.tipId).style.display = "none";
		for(var i=0;i<holiday.length;i++){
			var item = holiday[i];
			var _name = item.content;
			if(_name == name){
				renderTipHtml.call(this,item);
				break;
			}
		}
	}
	
	function renderSelect(id,attr,val){
		var sel = $s.$(id);
		var list = $s.$$(sel,"li");
		for(var i=0;i<list.length;i++){
			var v = $s.$$(list[i],"a")[0].getAttribute(attr);
			if(v == val) list[i].className = "on";
			else list[i].className = "";
		}
	}
	
	
	/*
		options:{
			year:2013,
			month:12,
			day:1,
			nyear:2013,
			nmonth:12,
			nday:13,
			holiday:[
				{
					content:"",
					date:"2013-10-1",
					tips:[
							{col1:"",col2:""}
						],
					guide:[
						{year:2013,month:10,day:1,type:"vacation"},
						{year:2013,month:10,day:2,type:"work"},
						{year:2013,month:10,day:3,type:"leave"}
					]
				}
			],
			dateClick:function(){
				//thisʾԪ
			},
			yearClick:function(){
				//thisʾԪ
			},
			monthClick:function(){
				//thisʾ·Ԫ
			},
			backClick:function(){
				//thisʾԪ
			},
			holidayClick:function(){
				//thisʾԪ
			},
			jumpClick:function(){
				//thisʾťԪ
			}
		}
	*/
	function $calendar(id,options){
		this.id = id;
		this.options = options || {};
		var opt = this.options;
		opt.holiday = opt.holiday || {};
		this.guide = getGuide(opt.holiday);
		//set id
		this.topId = id+"_top";
		this.cenId = id+"_cenId";
		this.rightId = id+"_rId";
		this.tableId = id+"_table";
		this.fitId = id+"_fit";
		this.badId = id+"_bad";
		this.tipId = id+"_tip";
		this.holiId = id+"_holi";
		this.yselId = id+"_ysel";
		this.mselId = id+"_msel";
		
		//set time
		this.sYear = 1901;
		this.eYear = 2049;
		this.year = opt.year;
		this.month = opt.month;
		this.day = opt.day || 1;
		
		var html = renderCalendar.call(this);
		$s.$(this.id).outerHTML = html;
		
		renderTip.call(this);
		renderTable.call(this,true);
//		renderRightCont.call(this);
		
		bindEvent.call(this);
	}
	
	/**************/
	var _sel = "1223";
	
	function selClick(sel){
		return function(){
			var parent = this.parentNode;
			var list = GC(parent,"ca_taglist","ul")[0];
			list.style.display = list.style.display != "none"?"none":"";
			_sel = sel;
			if(sel == "_ySelect"){
				var year = $s.$$(this,"span")[0].getAttribute("data-year");
				var diff = year-1900-3;
				diff = diff>0?diff:0;
				setTimeout(function(){
					list.scrollTop = diff*22;
				},50);
			}
			return false;
		}
	}
	
	function yliClick(cal){
		return function(){
			
			if(this.className == "on") return false;
			
			var link = $s.$$(this,"a")[0];
			var year = +link.getAttribute("data-year");
			var span = $s.$$(this.parentNode.parentNode,"span")[0];
			span.innerHTML = year+"";
			span.setAttribute("data-year",year);
			var flag = cal.year==year?false:true;
			cal.year = year;
			this.parentNode.style.display = "none";
			renderTable.call(cal,flag);
            //alert(123); return;
//			renderRightCont.call(cal);
			if(typeof cal.options.yearClick == "function") cal.options.yearClick.call(this);
			return false;
		}
	}
	
	function mliClick(cal){
		return function(){
			if(this.className == "on") return false;
			
			var link = $s.$$(this,"a")[0];
			var month = +link.getAttribute("data-month");
			var span = $s.$$(this.parentNode.parentNode,"span")[0];
			span.innerHTML = month+'';
			span.setAttribute("data-month",month);
			cal.month = month;
			this.parentNode.style.display = "none";
			renderTable.call(cal);
//			renderRightCont.call(cal);
			if(typeof cal.options.monthClick == "function") cal.options.monthClick.call(this);
			return false;
		}
	}
	
	
	
	function hliClick(cal){
		return function(e){
			e = e || window.event;
			var target = e.target || e.srcElement;
//			var link = $s.$$(this,"a")[0];
			var link = target;
			var date = link.getAttribute("data-date");
			if(!date) { // 2014-03-27 20:06 modify by formal 
                $("#sogou_vr_20008605_calendar_0_holi").children("span").text('');
                return false;
            }
			var list = date.split("-");
			cal.year = +list[0];
			cal.month = +list[1];
			cal.day = +list[2];
			var span = $s.$$(this.parentNode,"span")[0];
			var holiday = link.getAttribute("data-holi")
			span.innerHTML = holiday;
			this.style.display = "none";
			
			var li = link.parentNode;
			var lis = $s.$$(li.parentNode,"li");
			for(var i=0;i<lis.length;i++){
				if(lis[i] == li) lis[i].className = "on";
				else lis[i].className = "";
			}
			
			var main = $s.$(cal.id);
			var ys = GC(main,"_ySelect","p")[0];
			ys = $s.$$(ys,"span")[0];
			ys.innerHTML = list[0]+"";
			ys.setAttribute("data-year",list[0]);
			var ms = GC(main,"_mSelect","p")[0];
			ms = $s.$$(ms,"span")[0];
			ms.innerHTML = list[1]+"";
			ms.setAttribute("data-month",list[1]);
			
			renderTable.call(cal);
//			renderRightCont.call(cal);
			renderTipCont.call(cal,link.innerHTML);
			if(typeof cal.options.holidayClick == "function") cal.options.holidayClick.call(link);
			return false;
		}
	}
	
	function backToday(cal){
		return function(){
			var ops = cal.options;
			var flag = cal.year==ops.nyear?false:true;
			cal.year = ops.nyear;
			cal.month = ops.nmonth;
			cal.day = ops.nday;
			
			var main = $s.$(cal.id);
			var ys = GC(main,"_ySelect","p")[0];
			ys = $s.$$(ys,"span")[0];
			ys.innerHTML = ops.nyear+"";
			ys.setAttribute("data-year",ops.nyear);
			var ms = GC(main,"_mSelect","p")[0];
			ms = $s.$$(ms,"span")[0];
			ms.innerHTML = ops.nmonth+"";
			ms.setAttribute("data-month",ops.nmonth);
			
			renderTable.call(cal,flag);
//			renderRightCont.call(cal);
			if(typeof cal.options.backClick == "function") cal.options.backClick.call(this);
			return false;
		}
	}
	
	function isCell(dom){
		if(!dom) return null;
		while(dom){
			if(dom.className === "calendar_new") return dom;
			dom = dom.parentNode;
		}
		return null;
	}
	
	function getHolidayName(){
		var year = this.year,
			month = this.month,
			day = this.day,
			holidays = this.options.holiday;
		for(var i=0;i<holidays.length;i++){
			var guides = holidays[i].guide;
			var name = holidays[i].content;
			for(var j=0;j<guides.length;j++){
				var guide = guides[j];
				if(guide.year == year && guide.month == month && guide.day == day)
					return name;
			}
		}
		return "";
	}
	
	function cellClick(cal){
		return function(e){
			
			var e = e || window.event;
			var target = e.target || e.srcElement;
			
			var dom = isCell(target);
			if(dom == null) return;
			
			var link = $s.$$(dom,"a")[0];
			
			var year = link.getAttribute("data-year");
			var month = link.getAttribute("data-month");
			var day = link.getAttribute("data-day");
			
			var flag = cal.year==year?false:true;
			cal.year = year;
			cal.month = month;
			cal.day = day;
			
			
			var main = $s.$(cal.id);
			var ys = GC(main,"_ySelect","p")[0];
			ys = $s.$$(ys,"span")[0];
			ys.innerHTML = year+"";
			ys.setAttribute("data-year",year);
			var ms = GC(main,"_mSelect","p")[0];
			ms = $s.$$(ms,"span")[0];
			ms.innerHTML = month+"";
			ms.setAttribute("data-month",month);
			
			renderTable.call(cal,flag);
//			renderRightCont.call(cal);
			if(typeof cal.options.dateClick == "function") cal.options.dateClick.call(link);
			return false;
		}
	}
	
	function jump(cal,step){
		return function(){
			var year = cal.year;
			var month = cal.month;
			var d = jumpMonth(step,year,month);
			var flag = cal.year==d.year?false:true;
			cal.year = d.year;
			cal.month = d.month;
			
			var main = $s.$(cal.id);
			var ys = GC(main,"_ySelect","p")[0];
			ys = $s.$$(ys,"span")[0];
			ys.innerHTML = d.year+"";
			ys.setAttribute("data-year",d.year);
			var ms = GC(main,"_mSelect","p")[0];
			ms = $s.$$(ms,"span")[0];
			ms.innerHTML = d.month+"";
			ms.setAttribute("data-month",d.month);
			
			renderTable.call(cal,flag);
//			renderRightCont.call(cal);
			if(typeof cal.options.jumpClick == "function") cal.options.jumpClick.call(this,step);
			return false;
		}
	}
	
	function bind(elem,type,cb){
		if(!elem) return;
		if(elem.addEventListener) elem.addEventListener(type,cb,false);
		else if(elem.attachEvent) elem.attachEvent("on"+type,cb);
	}
	
	function windowClick(cal){
		return function(){
			var main = $s.$(cal.id);
			var select = GC(main,"ca_tagT","p");
			for(var i=0;i<select.length;i++){
				var className = select[i].className;
				if(className.indexOf(_sel)==-1){
					var ul = $s.$$(select[i].parentNode,"ul")[0];
					ul.style.display = "none";
				}
			}
			_sel = "1234";
			
		}
	}
	
	function bindEvent(){
		var main = $s.$(this.id);
		var ysel = GC(main,"_ySelect","p")[0];
		ysel.onclick = selClick("_ySelect");
		var lis = $s.$$(ysel.parentNode,"li");
		for(var i=0;i<lis.length;i++){
			lis[i].onclick = yliClick(this);
		}
		var msel = GC(main,"_mSelect","p")[0];
		msel.onclick = selClick("_mSelect");
		lis = $s.$$(msel.parentNode,"li");
		for(var i=0;i<lis.length;i++){
			lis[i].onclick = mliClick(this);
		}
		var hsel = GC(main,"_hSelect","p")[0];
		hsel.onclick = selClick("_hSelect");
		lis = $s.$$(hsel.parentNode,"ul")[0];
		lis.onclick = hliClick(this);
/*		for(var i=0;i<lis.length;i++){
			lis[i].onclick = hliClick(this);
		}
*/		var today = GC(main,"black_td")[0];
		today.onclick = backToday(this);
		
		var table = $s.$(this.tableId);
		table.onclick = cellClick(this);
		
		var leftBtn = GC(main,"left_btn","a")[0];
		var rightBtn = GC(main,"right_btn","a")[0];
		leftBtn.onclick = jump(this,-1);
		rightBtn.onclick = jump(this,1);
		
		bind(document,"click",windowClick(this));
	}

	function filterArray(arr){
		var res = [],r = [],score = 0,max = 7;
		for(var i=0;i<arr.length;i++){
			if(arr[i].length<=3 && arr[i].length>=2) res.push(arr[i]);
		}
		res = sortArray(res);
		for(var i=0;i<res.length;i++){
			score++;
			if(score <= max) r.push(res[i]);
		}
		return r;
	}
	
	function sortArray(arr){
		return arr.sort(function(a,b){return a.length-b.length;});
	}
	
	function gethuangli(y,m,d) {
		var that = this;
		if (m<10) m="0"+m;
		if (d<10) d="0"+d;
		str = y+"%C4%EA"+m+"%D4%C2"+d+"%C8%D5";
		new Ajax({
			url : "/websearch/features/baibao/calendar_ajax.jsp?query="+str,
			method : "get",
			onComplete : function (request) {
				var result = request.responseText;
				eval("result=(" + result+")");
				if (result['error']) {
					$s.$(that.fitId).innerHTML="";
					$s.$(that.badId).innerHTML="";
				} else {
					var fit = result['fit'];
					var bad= result['bad'];
					fit = filterArray(fit.split(/\s+/));
					bad = filterArray(bad.split(/\s+/));
					var fitHtml = [];
					fitHtml.push('<span class="tt"></span>');
					for(var i=0;i<fit.length;i++){
						fitHtml.push('<span>'+fit[i]+'</span>');
					}
					
					var badHtml = [];
					badHtml.push('<span class="tt"></span>');
					for(var i=0;i<bad.length;i++){
						badHtml.push('<span>'+bad[i]+'</span>');
					}
					
					$s.$(that.fitId).innerHTML = fitHtml.join('');
					$s.$(that.badId).innerHTML = badHtml.join('');;
				}
			},
			onError : function(request) {
				//alert("error");
			}
		});
		return false;
	}

	
	return $calendar;
});
