/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.script.LuaScriptEngineFactory;

public class LuaScriptEngine
implements ScriptEngine,
Compilable {
    private static final String __ENGINE_VERSION__ = "Luaj-jse 3.0-alpha2";
    private static final String __NAME__ = "Luaj";
    private static final String __SHORT_NAME__ = "Luaj";
    private static final String __LANGUAGE__ = "lua";
    private static final String __LANGUAGE_VERSION__ = "5.2";
    private static final String __ARGV__ = "arg";
    private static final String __FILENAME__ = "?";
    private static final ScriptEngineFactory myFactory = new LuaScriptEngineFactory();
    private ScriptContext defaultContext;
    private final Globals _G = "true".equals(System.getProperty("luaj.debug")) ? JsePlatform.debugGlobals() : JsePlatform.standardGlobals();

    public LuaScriptEngine() {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setBindings(this.createBindings(), 100);
        this.setContext(simpleScriptContext);
        this.put("javax.script.language_version", __LANGUAGE_VERSION__);
        this.put("javax.script.language", __LANGUAGE__);
        this.put("javax.script.engine", "Luaj");
        this.put("javax.script.engine_version", __ENGINE_VERSION__);
        this.put("javax.script.argv", __ARGV__);
        this.put("javax.script.filename", __FILENAME__);
        this.put("javax.script.name", "Luaj");
        this.put("THREADING", null);
        this._G.set(LuaValue.INDEX, (LuaValue)this._G);
    }

    public Object eval(String string) throws ScriptException {
        return this.eval(new StringReader(string));
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    public Object eval(String string, Bindings bindings) throws ScriptException {
        return this.eval((Reader)new StringReader(string), bindings);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.getContext());
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.compile(reader).eval(scriptContext);
    }

    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        ScriptContext scriptContext = this.getContext();
        Bindings bindings2 = scriptContext.getBindings(100);
        scriptContext.setBindings(bindings, 100);
        Object object = this.eval(reader);
        scriptContext.setBindings(bindings2, 100);
        return object;
    }

    public void put(String string, Object object) {
        Bindings bindings = this.getBindings(100);
        bindings.put(string, object);
    }

    public Object get(String string) {
        Bindings bindings = this.getBindings(100);
        return bindings.get(string);
    }

    public Bindings getBindings(int n) {
        return this.getContext().getBindings(n);
    }

    public void setBindings(Bindings bindings, int n) {
        this.getContext().setBindings(bindings, n);
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public ScriptContext getContext() {
        return this.defaultContext;
    }

    public void setContext(ScriptContext scriptContext) {
        this.defaultContext = scriptContext;
    }

    public ScriptEngineFactory getFactory() {
        return myFactory;
    }

    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            Utf8Encoder utf8Encoder = new Utf8Encoder(reader);
            try {
                LuaFunction luaFunction = LoadState.load(utf8Encoder, "script", "bt", this._G);
                if (luaFunction.isclosure()) {
                    final Prototype prototype = luaFunction.checkclosure().p;
                    CompiledScriptImpl compiledScriptImpl = new CompiledScriptImpl(){

                        protected LuaFunction newFunctionInstance(LuaTable luaTable) {
                            return new LuaClosure(prototype, luaTable);
                        }
                    };
                    return compiledScriptImpl;
                }
                final Class<?> clazz = luaFunction.getClass();
                CompiledScriptImpl compiledScriptImpl = new CompiledScriptImpl(){

                    protected LuaFunction newFunctionInstance(LuaTable luaTable) throws ScriptException {
                        try {
                            LuaFunction luaFunction = (LuaFunction)clazz.newInstance();
                            luaFunction.initupvalue1(luaTable);
                            return luaFunction;
                        }
                        catch (Exception exception) {
                            throw new ScriptException("instantiation failed: " + exception.toString());
                        }
                    }
                };
                return compiledScriptImpl;
            }
            catch (LuaError luaError) {
                throw new ScriptException(luaError.getMessage());
            }
            finally {
                utf8Encoder.close();
            }
        }
        catch (Exception exception) {
            throw new ScriptException("eval threw " + exception.toString());
        }
    }

    LuaValue toLua(Object object) {
        return object == null ? LuaValue.NIL : (object instanceof LuaValue ? (LuaValue)object : CoerceJavaToLua.coerce(object));
    }

    Object toJava(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 0: {
                return null;
            }
            case 4: {
                return luaValue.tojstring();
            }
            case 7: {
                return luaValue.checkuserdata(Object.class);
            }
            case 3: {
                return luaValue.isinttype() ? (Number)new Integer(luaValue.toint()) : (Number)new Double(luaValue.todouble());
            }
        }
        return luaValue;
    }

    private final class Utf8Encoder
    extends InputStream {
        private final Reader r;
        private final int[] buf = new int[2];
        private int n;

        private Utf8Encoder(Reader reader) {
            this.r = reader;
        }

        public int read() throws IOException {
            if (this.n > 0) {
                return this.buf[--this.n];
            }
            int n = this.r.read();
            if (n < 128) {
                return n;
            }
            this.n = 0;
            if (n < 2048) {
                this.buf[this.n++] = 0x80 | n & 0x3F;
                return 0xC0 | n >> 6 & 0x1F;
            }
            this.buf[this.n++] = 0x80 | n & 0x3F;
            this.buf[this.n++] = 0x80 | n >> 6 & 0x3F;
            return 0xE0 | n >> 12 & 0xF;
        }
    }

    class BindingsGlobals
    extends Globals {
        final Bindings b;

        BindingsGlobals(Bindings bindings) {
            this.b = bindings;
            this.setmetatable(LuaScriptEngine.this._G);
            this.debuglib = ((LuaScriptEngine)LuaScriptEngine.this)._G.debuglib;
            for (Map.Entry entry : bindings.entrySet()) {
                this.rawset(LuaScriptEngine.this.toLua(entry.getKey()), LuaScriptEngine.this.toLua(entry.getValue()));
            }
        }

        void copyout() {
            this.b.clear();
            Varargs varargs = this.next(LuaValue.NIL);
            while (!varargs.arg1().isnil()) {
                this.b.put(LuaScriptEngine.this.toJava(varargs.arg1()).toString(), LuaScriptEngine.this.toJava(varargs.arg(2)));
                varargs = this.next(varargs.arg1());
            }
        }
    }

    protected abstract class CompiledScriptImpl
    extends CompiledScript {
        protected CompiledScriptImpl() {
        }

        protected abstract LuaFunction newFunctionInstance(LuaTable var1) throws ScriptException;

        public ScriptEngine getEngine() {
            return LuaScriptEngine.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object eval(ScriptContext scriptContext) throws ScriptException {
            Bindings bindings = scriptContext.getBindings(100);
            BindingsGlobals bindingsGlobals = new BindingsGlobals(bindings);
            LuaFunction luaFunction = this.newFunctionInstance(bindingsGlobals);
            try {
                Varargs varargs = luaFunction.invoke(LuaValue.NONE);
                return varargs;
            }
            finally {
                bindingsGlobals.copyout();
            }
        }
    }
}

