/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class PackageLib
extends OneArgFunction {
    public static String DEFAULT_LUA_PATH = System.getProperty("luaj.package.path");
    Globals globals;
    public LuaTable loaded;
    public LuaTable preload;
    public LuaString path;
    public loadlib loadlib;
    public searchpath searchpath;
    public LuaTable searchers;
    public preload_searcher preload_searcher;
    public lua_searcher lua_searcher;
    public java_searcher java_searcher;
    private static final LuaString _SENTINEL;
    private static final String FILE_SEP;

    public LuaValue call(LuaValue luaValue) {
        this.globals = luaValue.checkglobals();
        luaValue.set("require", (LuaValue)new require());
        LuaTable luaTable = new LuaTable();
        this.loaded = new LuaTable();
        luaTable.set("loaded", (LuaValue)this.loaded);
        this.preload = new LuaTable();
        luaTable.set("preload", (LuaValue)this.preload);
        this.path = LuaValue.valueOf(DEFAULT_LUA_PATH);
        luaTable.set("path", (LuaValue)this.path);
        this.loadlib = new loadlib();
        luaTable.set("loadlib", (LuaValue)this.loadlib);
        this.searchpath = new searchpath();
        luaTable.set("searchpath", (LuaValue)this.searchpath);
        this.searchers = new LuaTable();
        this.preload_searcher = new preload_searcher();
        this.searchers.set(1, (LuaValue)this.preload_searcher);
        this.lua_searcher = new lua_searcher();
        this.searchers.set(2, (LuaValue)this.lua_searcher);
        this.java_searcher = new java_searcher();
        this.searchers.set(3, (LuaValue)this.java_searcher);
        luaTable.set("searchers", (LuaValue)this.searchers);
        this.loaded.set("package", (LuaValue)luaTable);
        luaValue.set("package", (LuaValue)luaTable);
        this.globals.package_ = this;
        return luaValue;
    }

    public void setIsLoaded(String string, LuaTable luaTable) {
        this.loaded.set(string, (LuaValue)luaTable);
    }

    public void setLuaPath(String string) {
        this.path = LuaValue.valueOf(string);
    }

    public String tojstring() {
        return "package";
    }

    public static final String toClassname(String string) {
        int n;
        int n2 = n = string.length();
        if (string.endsWith(".lua")) {
            n2 -= 4;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (PackageLib.isClassnamePart((char)n3) && n3 != 47 && n3 != 92) continue;
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int j = 0; j < n2; ++j) {
                n3 = string.charAt(j);
                stringBuffer.append((char)(PackageLib.isClassnamePart((char)n3) ? n3 : (n3 == 47 || n3 == 92 ? 46 : 95)));
            }
            return stringBuffer.toString();
        }
        return n == n2 ? string : string.substring(0, n2);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    static {
        if (DEFAULT_LUA_PATH == null) {
            DEFAULT_LUA_PATH = "?.lua";
        }
        _SENTINEL = PackageLib.valueOf("\u0001");
        FILE_SEP = System.getProperty("file.separator");
    }

    public class java_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            String string2 = PackageLib.toClassname(string);
            Class<?> clazz = null;
            LuaValue luaValue = null;
            try {
                clazz = Class.forName(string2);
                luaValue = (LuaValue)clazz.newInstance();
                if (luaValue.isfunction()) {
                    ((LuaFunction)luaValue).initupvalue1(PackageLib.this.globals);
                }
                return org.luaj.vm2.lib.PackageLib$java_searcher.varargsOf(luaValue, (Varargs)PackageLib.this.globals);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tno class '" + string2 + "'");
            }
            catch (Exception exception) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tjava load failed on '" + string2 + "', " + exception);
            }
        }
    }

    public class searchpath
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            String string2 = varargs.checkjstring(2);
            String string3 = varargs.optjstring(3, ".");
            String string4 = varargs.optjstring(4, FILE_SEP);
            int n = -1;
            int n2 = string2.length();
            StringBuffer stringBuffer = null;
            string = string.replace(string3.charAt(0), string4.charAt(0));
            while (n < n2) {
                InputStream inputStream;
                int n3 = n + 1;
                if ((n = string2.indexOf(59, n3)) < 0) {
                    n = string2.length();
                }
                String string5 = string2.substring(n3, n);
                int n4 = string5.indexOf(63);
                String string6 = string5;
                if (n4 >= 0) {
                    string6 = string5.substring(0, n4) + string + string5.substring(n4 + 1);
                }
                if ((inputStream = PackageLib.this.globals.FINDER.findResource(string6)) != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return org.luaj.vm2.lib.PackageLib$searchpath.valueOf(string6);
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append("\n\t" + string6);
            }
            return org.luaj.vm2.lib.PackageLib$searchpath.varargsOf(NIL, (Varargs)org.luaj.vm2.lib.PackageLib$searchpath.valueOf(stringBuffer.toString()));
        }
    }

    public class lua_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            LuaString luaString = varargs.checkstring(1);
            Object var3_3 = null;
            if (!PackageLib.this.path.isstring()) {
                return org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("package.path is not a string");
            }
            Varargs varargs2 = PackageLib.this.searchpath.invoke(org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(luaString, (Varargs)PackageLib.this.path));
            if (!varargs2.isstring(1)) {
                return varargs2.arg(2).tostring();
            }
            LuaString luaString2 = varargs2.arg1().strvalue();
            if ((varargs2 = PackageLib.this.globals.loadFile(luaString2.tojstring())).arg1().isfunction()) {
                return LuaValue.varargsOf(varargs2.arg1(), (Varargs)luaString2);
            }
            return org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(NIL, (Varargs)org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("'" + luaString2 + "': " + varargs2.arg(2).tojstring()));
        }
    }

    public class preload_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            LuaString luaString = varargs.checkstring(1);
            LuaValue luaValue = PackageLib.this.preload.get(luaString);
            return luaValue.isnil() ? org.luaj.vm2.lib.PackageLib$preload_searcher.valueOf("\n\tno field package.preload['" + luaString + "']") : luaValue;
        }
    }

    public static class loadlib
    extends VarArgFunction {
        public Varargs loadlib(Varargs varargs) {
            varargs.checkstring(1);
            return org.luaj.vm2.lib.PackageLib$loadlib.varargsOf(NIL, org.luaj.vm2.lib.PackageLib$loadlib.valueOf("dynamic libraries not enabled"), org.luaj.vm2.lib.PackageLib$loadlib.valueOf("absent"));
        }
    }

    public class require
    extends OneArgFunction {
        public LuaValue call(LuaValue luaValue) {
            LuaString luaString = luaValue.checkstring();
            LuaValue luaValue2 = PackageLib.this.loaded.get(luaString);
            if (luaValue2.toboolean()) {
                if (luaValue2 == _SENTINEL) {
                    require.error("loop or previous error loading module '" + luaString + "'");
                }
                return luaValue2;
            }
            LuaTable luaTable = PackageLib.this.searchers.checktable();
            StringBuffer stringBuffer = new StringBuffer();
            Varargs varargs = null;
            int n = 1;
            while (true) {
                LuaValue luaValue3;
                if ((luaValue3 = luaTable.get(n)).isnil()) {
                    require.error("module '" + luaString + "' not found: " + luaString + stringBuffer);
                }
                if ((varargs = luaValue3.invoke(luaString)).isfunction(1)) break;
                if (varargs.isstring(1)) {
                    stringBuffer.append(varargs.tojstring(1));
                }
                ++n;
            }
            PackageLib.this.loaded.set(luaString, (LuaValue)_SENTINEL);
            luaValue2 = varargs.arg1().call(luaString, varargs.arg(2));
            if (!luaValue2.isnil()) {
                PackageLib.this.loaded.set(luaString, luaValue2);
            } else {
                luaValue2 = PackageLib.this.loaded.get(luaString);
                if (luaValue2 == _SENTINEL) {
                    luaValue2 = LuaValue.TRUE;
                    PackageLib.this.loaded.set(luaString, luaValue2);
                }
            }
            return luaValue2;
        }
    }
}

