/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.util.Random;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class MathLib
extends OneArgFunction {
    public static MathLib MATHLIB = null;

    public MathLib() {
        MATHLIB = this;
    }

    public LuaValue call(LuaValue luaValue) {
        LuaTable luaTable = new LuaTable(0, 30);
        luaTable.set("abs", (LuaValue)new abs());
        luaTable.set("ceil", (LuaValue)new ceil());
        luaTable.set("cos", (LuaValue)new cos());
        luaTable.set("deg", (LuaValue)new deg());
        luaTable.set("exp", (LuaValue)new exp(this));
        luaTable.set("floor", (LuaValue)new floor());
        luaTable.set("fmod", (LuaValue)new fmod());
        luaTable.set("frexp", (LuaValue)new frexp());
        luaTable.set("huge", (LuaValue)LuaDouble.POSINF);
        luaTable.set("ldexp", (LuaValue)new ldexp());
        luaTable.set("max", (LuaValue)new max());
        luaTable.set("min", (LuaValue)new min());
        luaTable.set("modf", (LuaValue)new modf());
        luaTable.set("pi", Math.PI);
        luaTable.set("pow", (LuaValue)new pow());
        random random2 = new random();
        luaTable.set("random", (LuaValue)random2);
        luaTable.set("randomseed", (LuaValue)new randomseed(random2));
        luaTable.set("rad", (LuaValue)new rad());
        luaTable.set("sin", (LuaValue)new sin());
        luaTable.set("sqrt", (LuaValue)new sqrt());
        luaTable.set("tan", (LuaValue)new tan());
        luaValue.set("math", (LuaValue)luaTable);
        luaValue.get("package").get("loaded").set("math", (LuaValue)luaTable);
        return luaTable;
    }

    public static LuaValue dpow(double d, double d2) {
        return LuaDouble.valueOf(MATHLIB != null ? MATHLIB.dpow_lib(d, d2) : MathLib.dpow_default(d, d2));
    }

    public static double dpow_d(double d, double d2) {
        return MATHLIB != null ? MATHLIB.dpow_lib(d, d2) : MathLib.dpow_default(d, d2);
    }

    public double dpow_lib(double d, double d2) {
        return MathLib.dpow_default(d, d2);
    }

    protected static double dpow_default(double d, double d2) {
        double d3;
        if (d2 < 0.0) {
            return 1.0 / MathLib.dpow_default(d, -d2);
        }
        double d4 = 1.0;
        int n = (int)d2;
        double d5 = d;
        while (n > 0) {
            if ((n & 1) != 0) {
                d4 *= d5;
            }
            n >>= 1;
            d5 *= d5;
        }
        d2 -= (double)n;
        if (d3 > 0.0) {
            int n2 = (int)(65536.0 * d2);
            while ((n2 & 0xFFFF) != 0) {
                d = Math.sqrt(d);
                if ((n2 & 0x8000) != 0) {
                    d4 *= d;
                }
                n2 <<= 1;
            }
        }
        return d4;
    }

    static class randomseed
    extends OneArgFunction {
        final random random;

        randomseed(random random2) {
            this.random = random2;
        }

        public LuaValue call(LuaValue luaValue) {
            long l = luaValue.checklong();
            this.random.random = new Random(l);
            return NONE;
        }
    }

    static class random
    extends LibFunction {
        Random random = new Random();

        random() {
        }

        public LuaValue call() {
            return org.luaj.vm2.lib.MathLib$random.valueOf(this.random.nextDouble());
        }

        public LuaValue call(LuaValue luaValue) {
            int n = luaValue.checkint();
            if (n < 1) {
                org.luaj.vm2.lib.MathLib$random.argerror(1, "interval is empty");
            }
            return org.luaj.vm2.lib.MathLib$random.valueOf(1 + this.random.nextInt(n));
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            int n = luaValue.checkint();
            int n2 = luaValue2.checkint();
            if (n2 < n) {
                org.luaj.vm2.lib.MathLib$random.argerror(2, "interval is empty");
            }
            return org.luaj.vm2.lib.MathLib$random.valueOf(n + this.random.nextInt(n2 + 1 - n));
        }
    }

    static class modf
    extends VarArgFunction {
        modf() {
        }

        public Varargs invoke(Varargs varargs) {
            double d = varargs.checkdouble(1);
            double d2 = d > 0.0 ? Math.floor(d) : Math.ceil(d);
            double d3 = d - d2;
            return modf.varargsOf(modf.valueOf(d2), (Varargs)modf.valueOf(d3));
        }
    }

    static class min
    extends VarArgFunction {
        min() {
        }

        public Varargs invoke(Varargs varargs) {
            double d = varargs.checkdouble(1);
            int n = varargs.narg();
            for (int i = 2; i <= n; ++i) {
                d = Math.min(d, varargs.checkdouble(i));
            }
            return min.valueOf(d);
        }
    }

    static class max
    extends VarArgFunction {
        max() {
        }

        public Varargs invoke(Varargs varargs) {
            double d = varargs.checkdouble(1);
            int n = varargs.narg();
            for (int i = 2; i <= n; ++i) {
                d = Math.max(d, varargs.checkdouble(i));
            }
            return max.valueOf(d);
        }
    }

    static class frexp
    extends VarArgFunction {
        frexp() {
        }

        public Varargs invoke(Varargs varargs) {
            double d = varargs.checkdouble(1);
            if (d == 0.0) {
                return frexp.varargsOf(ZERO, (Varargs)ZERO);
            }
            long l = Double.doubleToLongBits(d);
            double d2 = (double)((l & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (l >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
            double d3 = ((int)(l >> 52) & 0x7FF) - 1022;
            return frexp.varargsOf(frexp.valueOf(d2), (Varargs)frexp.valueOf(d3));
        }
    }

    static final class pow
    extends BinaryOp {
        pow() {
        }

        protected double call(double d, double d2) {
            return MathLib.dpow_default(d, d2);
        }
    }

    static final class ldexp
    extends BinaryOp {
        ldexp() {
        }

        protected double call(double d, double d2) {
            return d * Double.longBitsToDouble((long)d2 + 1023L << 52);
        }
    }

    static final class fmod
    extends BinaryOp {
        fmod() {
        }

        protected double call(double d, double d2) {
            double d3 = d / d2;
            return d - d2 * (d3 >= 0.0 ? Math.floor(d3) : Math.ceil(d3));
        }
    }

    static final class exp
    extends UnaryOp {
        final MathLib mathlib;

        exp(MathLib mathLib) {
            this.mathlib = mathLib;
        }

        protected double call(double d) {
            return this.mathlib.dpow_lib(Math.E, d);
        }
    }

    static final class tan
    extends UnaryOp {
        tan() {
        }

        protected double call(double d) {
            return Math.tan(d);
        }
    }

    static final class sqrt
    extends UnaryOp {
        sqrt() {
        }

        protected double call(double d) {
            return Math.sqrt(d);
        }
    }

    static final class sin
    extends UnaryOp {
        sin() {
        }

        protected double call(double d) {
            return Math.sin(d);
        }
    }

    static final class rad
    extends UnaryOp {
        rad() {
        }

        protected double call(double d) {
            return Math.toRadians(d);
        }
    }

    static final class floor
    extends UnaryOp {
        floor() {
        }

        protected double call(double d) {
            return Math.floor(d);
        }
    }

    static final class deg
    extends UnaryOp {
        deg() {
        }

        protected double call(double d) {
            return Math.toDegrees(d);
        }
    }

    static final class cos
    extends UnaryOp {
        cos() {
        }

        protected double call(double d) {
            return Math.cos(d);
        }
    }

    static final class ceil
    extends UnaryOp {
        ceil() {
        }

        protected double call(double d) {
            return Math.ceil(d);
        }
    }

    static final class abs
    extends UnaryOp {
        abs() {
        }

        protected double call(double d) {
            return Math.abs(d);
        }
    }

    protected static abstract class BinaryOp
    extends TwoArgFunction {
        protected BinaryOp() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return BinaryOp.valueOf(this.call(luaValue.checkdouble(), luaValue2.checkdouble()));
        }

        protected abstract double call(double var1, double var3);
    }

    protected static abstract class UnaryOp
    extends OneArgFunction {
        protected UnaryOp() {
        }

        public LuaValue call(LuaValue luaValue) {
            return UnaryOp.valueOf(this.call(luaValue.checkdouble()));
        }

        protected abstract double call(double var1);
    }
}

