/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.lang.ref.WeakReference;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.TwoArgFunction;

public class WeakTable
extends LuaTable {
    private boolean weakkeys;
    private boolean weakvalues;

    public WeakTable(boolean bl, boolean bl2) {
        this(bl, bl2, 0, 0);
    }

    protected WeakTable(boolean bl, boolean bl2, int n, int n2) {
        super(n, n2);
        this.weakkeys = bl;
        this.weakvalues = bl2;
    }

    protected WeakTable(boolean bl, boolean bl2, LuaTable luaTable) {
        this(bl, bl2, luaTable.getArrayLength(), luaTable.getHashLength());
        Varargs varargs;
        LuaValue luaValue = NIL;
        while (!(luaValue = (varargs = luaTable.next(luaValue)).arg1()).isnil()) {
            this.rawset(luaValue, varargs.arg(2));
        }
        this.m_metatable = luaTable.m_metatable;
    }

    public void presize(int n) {
        super.presize(n);
    }

    public void presize(int n, int n2) {
        super.presize(n, n2);
    }

    protected int getArrayLength() {
        return super.getArrayLength();
    }

    protected int getHashLength() {
        return super.getHashLength();
    }

    protected LuaTable changemode(boolean bl, boolean bl2) {
        this.weakkeys = bl;
        this.weakvalues = bl2;
        return this;
    }

    LuaValue weaken(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 5: 
            case 6: 
            case 8: {
                return new WeakValue(luaValue);
            }
            case 7: {
                return new WeakUserdata(luaValue);
            }
        }
        return luaValue;
    }

    public void rawset(int n, LuaValue luaValue) {
        if (this.weakvalues) {
            luaValue = this.weaken(luaValue);
        }
        super.rawset(n, luaValue);
    }

    public void rawset(LuaValue luaValue, LuaValue luaValue2) {
        if (this.weakvalues) {
            luaValue2 = this.weaken(luaValue2);
        }
        if (this.weakkeys) {
            switch (luaValue.type()) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    luaValue = luaValue2 = new WeakEntry(this, luaValue, luaValue2);
                    break;
                }
            }
        }
        super.rawset(luaValue, luaValue2);
    }

    public LuaValue rawget(int n) {
        return super.rawget(n).strongvalue();
    }

    public LuaValue rawget(LuaValue luaValue) {
        return super.rawget(luaValue).strongvalue();
    }

    protected LuaValue hashget(LuaValue luaValue) {
        if (this.hashEntries > 0) {
            int n = this.hashFindSlot(luaValue);
            if (this.hashEntries == 0) {
                return NIL;
            }
            LuaValue luaValue2 = this.hashValues[n];
            return luaValue2 != null ? luaValue2 : NIL;
        }
        return NIL;
    }

    public int hashFindSlot(LuaValue luaValue) {
        LuaValue luaValue2;
        int n = (luaValue.hashCode() & Integer.MAX_VALUE) % this.hashKeys.length;
        while ((luaValue2 = this.hashKeys[n]) != null) {
            if (luaValue2.isweaknil()) {
                this.hashClearSlot(n);
                if (this.hashEntries != 0) continue;
                return 0;
            }
            if (luaValue2.raweq(luaValue.strongkey())) {
                return n;
            }
            n = (n + 1) % this.hashKeys.length;
        }
        return n;
    }

    public Varargs next(LuaValue luaValue) {
        LuaValue luaValue2;
        LuaValue luaValue3;
        while (true) {
            Varargs varargs;
            LuaValue luaValue4;
            if ((luaValue4 = (varargs = super.next(luaValue)).arg1()).isnil()) {
                return NIL;
            }
            luaValue3 = luaValue4.strongkey();
            luaValue2 = varargs.arg(2).strongvalue();
            if (!luaValue3.isnil() && !luaValue2.isnil()) break;
            super.rawset(luaValue4, NIL);
        }
        return WeakTable.varargsOf(luaValue3, (Varargs)luaValue2);
    }

    public void sort(final LuaValue luaValue) {
        super.sort(new TwoArgFunction(){

            public LuaValue call(LuaValue luaValue3, LuaValue luaValue2) {
                return luaValue.call(luaValue3.strongvalue(), luaValue2.strongvalue());
            }
        });
    }

    static final class WeakEntry
    extends LuaValue {
        final LuaValue weakkey;
        LuaValue weakvalue;
        final int keyhash;

        private WeakEntry(WeakTable weakTable, LuaValue luaValue, LuaValue luaValue2) {
            this.weakkey = weakTable.weaken(luaValue);
            this.keyhash = luaValue.hashCode();
            this.weakvalue = luaValue2;
        }

        public LuaValue strongkey() {
            return this.weakkey.strongvalue();
        }

        public LuaValue strongvalue() {
            LuaValue luaValue = this.weakkey.strongvalue();
            if (luaValue.isnil()) {
                this.weakvalue = NIL;
                return this.weakvalue;
            }
            return this.weakvalue.strongvalue();
        }

        public int type() {
            return -1;
        }

        public String typename() {
            this.illegal("typename", "weak entry");
            return null;
        }

        public String toString() {
            return "weak<" + this.weakkey.strongvalue() + "," + this.strongvalue() + ">";
        }

        public int hashCode() {
            return this.keyhash;
        }

        public boolean raweq(LuaValue luaValue) {
            return this.weakkey.raweq(luaValue);
        }

        public boolean isweaknil() {
            return this.weakkey.isweaknil() || this.weakvalue.isweaknil();
        }
    }

    static final class WeakUserdata
    extends WeakValue {
        private final WeakReference ob;
        private final LuaValue mt;

        private WeakUserdata(LuaValue luaValue) {
            super(luaValue);
            this.ob = new WeakReference<Object>(luaValue.touserdata());
            this.mt = luaValue.getmetatable();
        }

        public LuaValue strongvalue() {
            Object t = this.ref.get();
            if (t != null) {
                return (LuaValue)t;
            }
            Object t2 = this.ob.get();
            return t2 != null ? WeakUserdata.userdataOf(t2, this.mt) : NIL;
        }

        public boolean raweq(LuaValue luaValue) {
            if (!luaValue.isuserdata()) {
                return false;
            }
            LuaValue luaValue2 = (LuaValue)this.ref.get();
            if (luaValue2 != null && luaValue2.raweq(luaValue)) {
                return true;
            }
            return luaValue.touserdata() == this.ob.get();
        }

        public boolean isweaknil() {
            return this.ob.get() == null || this.ref.get() == null;
        }
    }

    static class WeakValue
    extends LuaValue {
        final WeakReference ref;

        protected WeakValue(LuaValue luaValue) {
            this.ref = new WeakReference<LuaValue>(luaValue);
        }

        public int type() {
            this.illegal("type", "weak value");
            return 0;
        }

        public String typename() {
            this.illegal("typename", "weak value");
            return null;
        }

        public String toString() {
            return "weak<" + this.ref.get() + ">";
        }

        public LuaValue strongvalue() {
            Object t = this.ref.get();
            return t != null ? (LuaValue)t : NIL;
        }

        public boolean raweq(LuaValue luaValue) {
            Object t = this.ref.get();
            return t != null && luaValue.raweq((LuaValue)t);
        }

        public boolean isweaknil() {
            return this.ref.get() == null;
        }
    }
}

