/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.DumpState;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.jse.JsePlatform;

public class luac {
    private static final String version = "Luaj-jse 3.0-alpha2Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar luac [options] [filenames].\nAvailable options are:\n  -        process stdin\n  -l       list\n  -o name  output to file 'name' (default is \"luac.out\")\n  -p       parse only\n  -s       strip debug information\n  -e       little endian format for numbers\n  -i<n>    number format 'n', (n=0,1 or 4, default=0)\n  -v       show version information\n  --       stop handling options\n";
    private boolean list = false;
    private String output = "luac.out";
    private boolean parseonly = false;
    private boolean stripdebug = false;
    private boolean littleendian = false;
    private int numberformat = 0;
    private boolean versioninfo = false;
    private boolean processing = true;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        new luac(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private luac(String[] stringArray) throws IOException {
        try {
            block19: for (int i = 0; i < stringArray.length; ++i) {
                if (!this.processing || !stringArray[i].startsWith("-") || stringArray[i].length() <= 1) continue;
                switch (stringArray[i].charAt(1)) {
                    case 'l': {
                        this.list = true;
                        continue block19;
                    }
                    case 'o': {
                        if (++i >= stringArray.length) {
                            luac.usageExit();
                        }
                        this.output = stringArray[i];
                        continue block19;
                    }
                    case 'p': {
                        this.parseonly = true;
                        continue block19;
                    }
                    case 's': {
                        this.stripdebug = true;
                        continue block19;
                    }
                    case 'e': {
                        this.littleendian = true;
                        continue block19;
                    }
                    case 'i': {
                        if (stringArray[i].length() <= 2) {
                            luac.usageExit();
                        }
                        this.numberformat = Integer.parseInt(stringArray[i].substring(2));
                        continue block19;
                    }
                    case 'v': {
                        this.versioninfo = true;
                        continue block19;
                    }
                    case '-': {
                        if (stringArray[i].length() > 2) {
                            luac.usageExit();
                        }
                        this.processing = false;
                        continue block19;
                    }
                    default: {
                        luac.usageExit();
                    }
                }
            }
            if (this.versioninfo) {
                System.out.println(version);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            try {
                JsePlatform.standardGlobals();
                this.processing = true;
                block20: for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.processing || !stringArray[i].startsWith("-")) {
                        String string = stringArray[i].substring(0, stringArray[i].length() - 4);
                        this.processScript(new FileInputStream(stringArray[i]), string, fileOutputStream);
                        continue;
                    }
                    if (stringArray[i].length() <= 1) {
                        this.processScript(System.in, "=stdin", fileOutputStream);
                        continue;
                    }
                    switch (stringArray[i].charAt(1)) {
                        case 'o': {
                            ++i;
                            continue block20;
                        }
                        case '-': {
                            this.processing = false;
                        }
                    }
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(InputStream inputStream, String string, OutputStream outputStream) throws IOException {
        try {
            Prototype prototype = LuaC.compile(inputStream, string);
            if (this.list) {
                Print.printCode(prototype);
            }
            if (!this.parseonly) {
                DumpState.dump(prototype, outputStream, this.stripdebug, this.numberformat, this.littleendian);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            inputStream.close();
        }
    }
}

