var AssembleManager = function(){
    this.list='{}';
    this.installing=false;
    this.index=-1;
    this.installid=0;
    this.installtype='';
    this.initList();
}
AssembleManager.prototype={
    //设置插件包列表
    initList:function (callback) {
        $.get("http://rank.kongzhong.com/ModDownload/action/AssembleAction/assemblelist", function (data, status) {
            try {
                assembleManager.list = data;
                if (typeof(callback) == "function") {
                    callback();
                }
            }
            catch (e) {
                console.log("getAssemble error", e);
                customAlert("获取集合包错误", "warning");
            }
        });
    },
    //生成页面
    initHtml:function(){
        if(this.list=='{}'){
            this.initList();
            $("#modinstallbutton").click();
            return;
        }
        checkNowPage("assemblelist",true);
        if ($("#modlist").html().length > 0) {
            $("#modlist").html("");
        }
        $("#modlist").load("modassemble.html #asmdiv", function (data) {
            if(checkNowPage("assemblelist",false)){
                return;
            }
            var div = '<div class="assemble panel-group" id="accordion">';
            for(var i in assembleManager.list) {
                try {
                    var assemble = assembleManager.list[i];
                    div += '<div class="panel panel-'+getType(assemble.id)+'">';

                    //heading
                    div += '<div class="panel-heading">';
                    div += '<a data-toggle="collapse" data-parent="#accordion" href="#assemble' + i + '" class="collapsed accordiontab" >';
                    div += '<fieldset>'
                    div += '<legend>' + assemble.assemblename +'</legend>';
                    div += '<small>下载量:' + assemble.down + '</small>';
                    div += '<h5>' + assemble.description + '</h5>';
                    div += '</fieldset>'
                    div += '</a></div>';

                    //body begin
                    div += '<div id="assemble' + i + '" class="panel-collapse out collapse" style="height: 0px;">';
                    div += '<div class="panel-body">';


                    //body end
                    div += '</div>';

                    div += '</div></div>';
                }catch(e){
                    console.log(e);
                }
            }
            div+='</div>';
            $("#asmdiv").append(div);
            $(".accordiontab").click(function(e){
                if($($(this).attr('href')).children(".panel-body").text().trim().length!=0){
                    return;
                }
                var id=$(this).attr('href').substring(9);
                var assemble=assembleManager.list[id];
                var div='';
                //预览图
                var images = assemble.image.split(';');
                div += '<div class="row"><div class="col-xs-12">';
                for (var j in images) {
                    var url = images[j];
                    if (url.trim().length > 0) {
                        div += '<img style="max-width:' + Number(100 / (images.length - 1)).toFixed(0) + '%" src="http://rank.kongzhong.com/ModDownload/' + url + '" class="assembleimg">';
                    }
                }
                div += '</div></div>';

                //安装btn
                div += '<div class="row" style="margin-top: 10px;margin-bottom: 15px;"><div class="col-xs-12"><a class="btn btn-success assembleinstall" href="#assemble'+id+'" style="margin-top:5px;">安装</a></div></div>';

                //插件列表
                div += '<div class="row">';
                div += '<div class="assemble panel-group col-xs-8">';
                div += '<div class="panel panel-default">';
                div += '<div class="panel-heading">';
                div += '<a data-toggle="collapse" data-parent="#" href="#asmlist' + id + '" class="asmlist collapsed">';
                div += '插件列表';
                div += '</a></div>';
                div += '<div id="asmlist' + id + '" class="panel-collapse out collapse" style="height: 0px;">';
                div += '<div class="panel-body" id="asmbody' + id + '">';
                div += '</div></div></div></div></div>';
                $($(this).attr('href')).children(".panel-body").append(div);

                $(".asmlist").click(function(){
                    var id=$(this).attr('href').substring(8);
                    //无内容，进行初始化
                    $("#asmbody"+id).html('');
                    if($("#asmbody"+id).html().trim().length==0){
                        var assemble=assembleManager.list[id];
                        //根据id判断是否选择的插件完全发布
                        var content=JSON.parse(assemble.content);
                        var table='<table class="table table-hover oper" style="margin-bottom:0px;">';
                        table+='<thead><tr><th>插件名称</th><th>分类</th><th>作者</th></tr></thead>';
                        table+='<tbody id="modbody">';
                        for(var i in content.modlist){
                            var mod=modManager.getRemoteMod(content.modlist[i]);
                            if(checkERROR(mod)){
                                continue;
                            }
                            table+='<tr>';
                            table+='<td>'+mod.name+'</td>';
                            table+='<td>'+mod.sort+'</td>';
                            table+='<td>'+mod.author+'</td>';
                            table+='</tr>';
                        }
                        table+='</tbody></table>';
                        $("#asmbody"+id).append(table);
                    }
                });
                $(".assembleinstall").click(function(e){
                    var id=$(this).attr('href').substring(9);
                    $.get("http://rank.kongzhong.com/ModDownload/action/AssembleAction/download?id="+id);
                    assembleManager.beginInstallAssemble($(this).attr('href').substring(9));
                });
            });
        });
    },
    //安装插件包
    beginInstallAssemble:function(id){
        if(this.installing){
            customAlert('有插件包正在安装中,请安装完当前插件包再操作');
            return;
        }
        this.installing=true;
        this.index=-1;
        this.installid=id;
        this.installtype='modlist';
        this.newTips();
        //根据插件包的配置内容依次获取配置
        this.next();
    },
    next:function(){
        //根据id获取插件包
        var assemble=this.list[this.installid];
        if(checkERROR(assemble)){
            return;
        }
        //根据插件包的插件内容依次获取插件
        var content=JSON.parse(assemble.content);
        this.index++;
        if(this.index>content[this.installtype].length-1){
               //没有下一个了
            if(this.installtype=='modlist'){
                //开始下载配置文件
                this.index=-1;
                this.installtype='configlist';
                this.next();
            }else{
                //结束
                this.index=-1;
                this.installing=false;
                this.closeTips();
            }
        }else{
            //下载下一个
            if(this.installtype=='modlist') {
                this.tips.html('待安装插件:'+(content.modlist.length-this.index)+'个<br/>待安装配置:'+content.configlist.length+'个');
                var mod = modManager.getRemoteMod(content.modlist[this.index]);
                //指定mod不存在
                if (!checkERROR(mod)) {
                    var url = mod.url;
                    var savepath = "download_mods/" + mod.name + mod.ext;
                    downloadCenter.add(url, savepath, mod.name, function (paths) {
                        var id = getUniqueId();
                        new CleverInstaller(id, mod.name, paths, "install", false, mod.id);
                        modManager.newModRecord(paths, mod.id, mod.name, id);
                        assembleManager.next();
                    });
                } else {
                    assembleManager.next();
                }
            }else if(this.installtype=='configlist'){
                this.tips.html('待安装插件:0个<br/>待安装配置:'+(content.configlist.length-this.index)+'个');
                var config = configManager.getRemoteConfigById(content.configlist[this.index]);
                var mod = modManager.getRemoteMod(config.modid);
                if(!checkERROR(config)&&!checkERROR(mod)) {
                    configManager.downloadConfig(config.modid, config.configid);
                }
                assembleManager.next();
            }
        }
    },
    newTips: function(){
        this.tips=new Tips(getUniqueId());
        this.tips.init('<'+this.list[this.installid].assemblename+'>插件包安装','插件包开始安装');
    },
    closeTips: function(){
        this.tips.html('插件包安装结束');
        setTimeout(assembleManager.tips.remove,5000);
    }
}
assembleManager=new AssembleManager();