-- yxs
-- jijiangf
sgs.ai_skill_invoke.jijiangf = function(self, data)
	local cards = self.player:getHandcards()
	for _, card in sgs.qlist(cards) do
		if card:inherits("Slash") then
			return false
		end
	end
	if sgs.jijiangsource then return false else return true end
end

sgs.ai_skill_choice.jijiangf = function(self , choices)
	if not self.player:hasLordSkill("jijiangf") then
		if self:getCardsNum("Slash") <= 0 then return "ignore" end
	end

	if self.player:isLord() then
		local target
		for _, player in sgs.qlist(self.room:getOtherPlayers(self.player)) do
			if player:hasSkill("weidi") then
				target = player
				break
			end
		end
		if target and self:isEnemy(target) then return "ignore" end
	elseif self:isFriend(self.room:getLord()) then return "accept" end
	return "ignore"
end

local jijiangf_skill={}
jijiangf_skill.name="jijiangf"
table.insert(sgs.ai_skills,jijiangf_skill)
jijiangf_skill.getTurnUseCard=function(self)
	if self.player:hasUsed("JijiangfCard") or not self:slashIsAvailable() then return end
	local card_str = "@JijiangfCard=."
	local slash = sgs.Card_Parse(card_str)
	assert(slash)

	return slash
end

sgs.ai_skill_use_func["JijiangfCard"]=function(card,use,self)
	self:sort(self.enemies, "defense")
	local target_count=0
	for _, enemy in ipairs(self.enemies) do
	if ((self.player:canSlash(enemy, not no_distance)) or
		(use.isDummy and (self.player:distanceTo(enemy)<=self.predictedRange)))
		and
		self:objectiveLevel(enemy)>3 and
		self:slashIsEffective(card, enemy) then
		use.card=card
		if use.to then
			use.to:append(enemy)
		end
		target_count=target_count+1
		if self.slash_targets<=target_count then return end
	end
end
end

sgs.ai_skill_choice.hujiaf = function(self , choices)
	if not self.player:hasLordSkill("hujiaf") then
		if self:getCardsNum("Jink") <= 0 then return "ignore" end
	end
	if self.player:isLord() then
		local target
		for _, player in sgs.qlist(self.room:getOtherPlayers(self.player)) do
			if player:hasSkill("weidi") then
				target = player
				break
			end
		end
		if target and self:isEnemy(target) then return "ignore" end
	elseif self:isFriend(self.room:getLord()) then return "accept" end
	return "ignore"
end

-- hujiaf
sgs.ai_skill_invoke.hujiaf = function(self, data)
	local cards = self.player:getHandcards()
	if sgs.hujiafsource then return false end
	for _, friend in ipairs(self.friends_noself) do
		if friend:getKingdom() == "wei" and self:isEquip("EightDiagram", friend) then return true end
	end
	for _, card in sgs.qlist(cards) do
		if card:inherits("Jink") then
			return false
		end
	end
	return true
end

-- budao
sgs.ai_skill_invoke.budao = function(self, data)
	local damage = data:toDamage()
	return self:isEnemy(damage.to) and self:getCardsNum("Slash") > 0
end

--diehun
sgs.ai_skill_invoke.diehun = function(self, data)
	local effect = data:toCardEffect()
	return (effect.card:inherits("GodSalvation") and not self.player:isWounded()) or effect.card:inherits("AOE")
	or effect.card:inherits("IronChain")
end

-- menshen
sgs.ai_skill_invoke.menshen = function(self, data)
   return #self.friends_noself > 0 and self.player:getHp() > 2
end
sgs.ai_skill_playerchosen.menshen = function(self, targets)
	for _, player in sgs.qlist(targets) do
		if self:isFriend(player) then
			return player
		end
	end
end

-- fanji
sgs.ai_skill_invoke.fanji = function(self, data)
	return not self:isFriend(data:toPlayer()) and self:getCardsNum("Slash") > 0
end

local shentou_skill={}
shentou_skill.name="shentou"
table.insert(sgs.ai_skills,shentou_skill)
shentou_skill.getTurnUseCard=function(self,inclusive)
    local cards = self.player:getCards("h")
    cards=sgs.QList2Table(cards)

	local card

	self:sortByUseValue(cards,true)

	local has_weapon=false

	for _,acard in ipairs(cards)  do
	    if acard:inherits("Weapon") and not (acard:getSuit() == sgs.Card_Club) then has_weapon=true end
	end

	for _,acard in ipairs(cards)  do
		if (acard:getSuit() == sgs.Card_Club) and ((self:getUseValue(acard)<sgs.ai_use_value["Snatch"]) or inclusive) then
		    local shouldUse=true

		    if acard:inherits("Armor") then
                if not self.player:getArmor() then shouldUse=false
                elseif self:hasEquip(acard) then shouldUse=false
                end
            end

            if acard:inherits("Weapon") then
                if not self.player:getWeapon() then shouldUse=false
                elseif self:hasEquip(acard) and not has_weapon then shouldUse=false
                end
            end

		    if shouldUse then
			    card = acard
			    break
			end
		end
	end

    if not card then return end
	local number = card:getNumberString()
    local card_id = card:getEffectiveId()
	local card_str = ("snatch:shentou[club:%s]=%d"):format(number, card_id)
	local  snatch= sgs.Card_Parse(card_str)

    assert(snatch)

    return snatch
end

-- tiemuzhen
sgs.ai_skill_invoke.qianglue = function(self, data)
	local effect = data:toSlashEffect()
	return not self:isFriend(effect.to) or (self:hasSkills(sgs.lose_equip_skill,effect.to) and not effect.to:getEquips():isEmpty())
end

-- qlzz
-- lianpo
sgs.ai_skill_choice.kurou = function(self, choices)
	return "ziji"
end

-- sanbanfu
sgs.ai_skill_invoke.sanbanfu = function(self, data)
	local effect = data:toSlashEffect()
	return not self:isFriend(effect.to)
end

--lizicheng
sgs.ai_skill_invoke.lumang = function(self, data)
	local effect = data:toCardEffect()
	return self:isEnemy(effect.from) and not self.player:isKongcheng()
end

-- lvzhi
sgs.ai_skill_invoke.zhensha = function(self, data)
	local dying = data:toDying()
	return self:isEnemy(dying.who) and self:getCardsNum("Peach") > 0
end

-- xiaoqiao
sgs.ai_skill_invoke.tianxian = function(self, data)
	local player = self.room:getCurrent()
	local judges = player:getJudgingArea()
	if self.player:getHandcardNum() <= 1 and self.player:isWounded() then return end
	return (self:isFriend(player) and not judges:isEmpty() and not player:hasSkill("luoshen") and player:getPhase()~= sgs.Player_Play)
	or (self:isEnemy(player) and judges:isEmpty() and player:hasFlag("luoshen") and player:getPhase()~= sgs.Player_Play)
	or (self:isEnemy(player) and judges:isEmpty() and player:hasFlag("shuangxiong") and player:getPhase()~= sgs.Player_Play)
	or (self:isEnemy(player) and judges:isEmpty() and player:hasSkill("chexuan") and player:getPhase()~= sgs.Player_Play)
end

--luban
local guifu_skill={}
guifu_skill.name="guifu"
table.insert(sgs.ai_skills,guifu_skill)
guifu_skill.getTurnUseCard=function(self)
	if not self.player:hasUsed("GuifuCard") then
		return sgs.Card_Parse("@GuifuCard=.")
	end
end

sgs.ai_skill_use_func["GuifuCard"]=function(card,use,self)
	for _, enemy in ipairs(self.enemies) do
	if self:getCardsNum(".", enemy, "e") >= 2 then
			use.card=card
			if use.to then use.to:append(enemy) end
			return
	   end
	end
for _, friend in ipairs(self.friends_noself) do
	if (self:getCardsNum(".", friend, "e") > 0 and self:hasSkills(sgs.lose_equip_skill, friend))
	or (self:isEquip("SilverLion", friend) and friend:isWounded()) then
			use.card=card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

-- panan
local zirong_skill={}
zirong_skill.name="zirong"
table.insert(sgs.ai_skills,zirong_skill)
zirong_skill.getTurnUseCard=function(self)
	if self.player:isKongcheng() then return end
    if self.player:hasUsed("ZirongCard") then return end

	local cards = self.player:getHandcards()
	cards=sgs.QList2Table(cards)

	self:sortByKeepValue(cards)

	local card_str = ("@ZirongCard=%d"):format(cards[1]:getId())
	return sgs.Card_Parse(card_str)
end

sgs.ai_skill_use_func["ZirongCard"]=function(card,use,self)
	for _, friend in ipairs(self.friends_noself) do
	if friend:getGeneral():isFemale() then
			use.card=card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

-- bhzz
-- sunwu
local shipo_skill={}
shipo_skill.name="shipo"
table.insert(sgs.ai_skills,shipo_skill)
shipo_skill.getTurnUseCard=function(self)
    if self.player:getHandcardNum() < 2 then return end
    if not self.player:hasUsed("ShipoCard") then
		return sgs.Card_Parse("@ShipoCard=.")
	end
end

sgs.ai_skill_use_func["ShipoCard"]=function(card,use,self)
    local cards = self.player:getHandcards()
	cards = sgs.QList2Table(cards)
	self:sortByUseValue(cards, true)
	local need_cards = {}
	local spade, club, heart, diamond
	for _, card in ipairs(cards) do
		if card:getSuit() == sgs.Card_Spade and not spade then spade = true table.insert(need_cards, card:getId())
		elseif card:getSuit() == sgs.Card_Club and not club then club = true table.insert(need_cards, card:getId())
		elseif card:getSuit() == sgs.Card_Heart and not heart then heart = true table.insert(need_cards, card:getId())
		elseif card:getSuit() == sgs.Card_Diamond and not diamond then diamond = true table.insert(need_cards, card:getId())
		end
	end
	if #need_cards < 2 then return end

	for _, enemy in ipairs(self.enemies) do
	if self.player:getHp() < enemy:getHp() then
			use.card = sgs.Card_Parse("@ShipoCard=" .. table.concat(need_cards, "+"))
			if use.to then use.to:append(enemy) end
			return
	   end
	end
for _, friend in ipairs(self.friends_noself) do
	if self.player:getHp() > friend:getHp() and friend:isWounded() then
			use.card = sgs.Card_Parse("@ShipoCard=" .. table.concat(need_cards, "+"))
			if use.to then use.to:append(friend) end
			return
		end
	end
end

-- kangxi
sgs.ai_skill_invoke.mingcha = true

-- liuche
sgs.ai_skill_invoke.ruide = true
sgs.ai_skill_askforag.ruide = function(self, card_ids)
	local who = self.room:getCurrent()
	local cards = {}
	for _, card_id in ipairs(card_ids) do
		table.insert(cards, sgs.Sanguosha:getCard(card_id))
	end

		self:sortByUseValue(cards, true)

	return cards[1]:getEffectiveId()
end

--mozi
local feigong_skill={}
feigong_skill.name="feigong"
table.insert(sgs.ai_skills,feigong_skill)
feigong_skill.getTurnUseCard=function(self)
	if not self.player:hasUsed("FeigongCard") then
		return sgs.Card_Parse("@FeigongCard=.")
	end
end

sgs.ai_skill_use_func["FeigongCard"]=function(card,use,self)
for _, friend in ipairs(self.friends_noself) do
	if (friend:isWounded() and not friend:isKongcheng())
	or (self:getCardsNum(".", friend, "h") == 1 and friend:hasSkill("lianying"))
	or (self:getCardsNum(".", friend, "h") == 1 and friend:hasSkill("kongcheng"))
	then
			use.card=card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

sgs.ai_skill_choice.feigong = function(self, choices)
	return "choupai"
end

-- zqzz
--jujia
jujia_skill={}
jujia_skill.name="jujia"
table.insert(sgs.ai_skills,jujia_skill)
jujia_skill.getTurnUseCard=function(self)
if self.player:isKongcheng() then return end
	if not self.player:hasUsed("JujiaCard") then
		return sgs.Card_Parse("@JujiaCard=.")
	end
end

sgs.ai_skill_use_func["JujiaCard"] = function(card, use, self)
	local cards = self.player:getHandcards()
	cards=sgs.QList2Table(cards)
	self:sortByUseValue(cards,true)

	local target
	for _, friend in ipairs(self.friends_noself) do
		if self:hasSkills(sgs.lose_equip_skill, friend) then
			for _, card in ipairs(cards) do
				if self.player:getHandcardNum() > 1 then
					use.card = sgs.Card_Parse("@JujiaCard=" .. card:getEffectiveId())
					target = friend
					break
				end
			end
		end
		if target then break end
	end
	if not target then
		for _, enemy in ipairs(self.enemies) do
			if not enemy:isKongcheng() then
				for _, card in ipairs(cards)do
					if not card:inherits("Peach")  and self.player:getHandcardNum() > 1 then
						use.card = sgs.Card_Parse("@JujiaCard=" .. card:getEffectiveId())
						target = enemy
						break
					end
				end
			end
			if target then break end
		end
	end

	if target then
		self.room:setPlayerFlag(target, "jujia_target")
		if use.to then
			use.to:append(target)
		end
	end
end

sgs.ai_skill_playerchosen.jujia = function(self, targets)
	for _, player in sgs.qlist(targets) do
		if (player:getHandcardNum() <= 2 or player:getHp() < 2) and self:isFriend(player) and not player:hasFlag("jujia_target") then
			return player
		end
	end
end

-- bushi
sgs.ai_skill_invoke.bushi = true

-- taiji
sgs.ai_skill_invoke.taiji = function(self, data)
	for _, enemy in ipairs(self.enemies) do
		if self.player:canSlash(enemy, true) and self:getCardsNum("Slash") > 0 then return true end
	end
end

sgs.ai_skill_playerchosen.taiji = sgs.ai_skill_playerchosen.zero_card_as_slash

-- xwzz
-- wangzhaojun
local luoyan_skill={}
luoyan_skill.name="luoyan"
table.insert(sgs.ai_skills,luoyan_skill)
luoyan_skill.getTurnUseCard=function(self)
	if self.player:isKongcheng() then return end
    if self.player:hasUsed("LuoyanCard") then return end

	local cards = self.player:getHandcards()
	cards=sgs.QList2Table(cards)

	self:sortByKeepValue(cards)

	local card_str = ("@LuoyanCard=%d"):format(cards[1]:getId())
	return sgs.Card_Parse(card_str)
end

sgs.ai_skill_use_func["LuoyanCard"]=function(card,use,self)
	for _, friend in ipairs(self.friends_noself) do
	 if friend:getGeneral():isMale() then
			use.card=card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

--sheji
local sheji_skill={}
sheji_skill.name="sheji"
table.insert(sgs.ai_skills,sheji_skill)
sheji_skill.getTurnUseCard=function(self)
    if self.player:isKongcheng() then return end
	if not self.player:hasUsed("ShejiCard") then
		return sgs.Card_Parse("@ShejiCard=.")
	end
end

sgs.ai_skill_use_func["ShejiCard"]=function(card,use,self)
	for _, enemy in ipairs(self.enemies) do
	if not enemy:isKongcheng() and self.player:inMyAttackRange(enemy) then
			use.card=card
			if use.to then use.to:append(enemy) end
			return
	   end
	end
end

-- fubing
local fuji_skill={}
fuji_skill.name="fuji"
table.insert(sgs.ai_skills,fuji_skill)
fuji_skill.getTurnUseCard=function(self)
	local cards = self.player:getHandcards()
	local basics = {}
	for _, card in sgs.qlist(cards) do
		if card:getTypeId() == sgs.Card_Basic then
			table.insert(basics, card)
		end
	end

	if #basics == 0 or self.player:hasUsed("FujiCard") then return end
	self:sortByUseValue(basics, true)

	local card_str = ("@FujiCard=%d"):format(basics[1]:getEffectiveId())
	return sgs.Card_Parse(card_str)
end

sgs.ai_skill_use_func["FujiCard"]=function(card,use,self)
	for _, enemy in ipairs(self.enemies) do
			use.card=card
			if use.to then use.to:append(enemy) end
			return
	end
end

-- yinqiang
sgs.ai_skill_invoke.yinqiang = function(self, data)
	local damage = data:toDamage()
	return self:isEnemy(damage.to)
end

-- congzhen
sgs.ai_skill_invoke.congzhen = function(self, data)
	local effect = data:toSlashEffect()
	return self:isEnemy(effect.to)
end

--yunchou
sgs.ai_skill_invoke.yunchou = function(self, data)
	local effect = data:toCardEffect()
	if effect.card:inherits("GodSalvation") or effect.card:inherits("AmazingGrace") then return end
	return self:isEnemy(effect.from) or effect.card:inherits("AOE")
end

-- kaixian
sgs.ai_skill_invoke.kaixian = true

sgs.ai_view_as.shentan = function(card, player, card_place)
	local suit = card:getSuitString()
	local number = card:getNumberString()
	local card_id = card:getEffectiveId()
	if card_place ~= sgs.Player_Equip then
		if card:isBlack() or card:isRed() then
			return ("nullification:shentan[%s:%s]=%d"):format(suit, number, card_id)
		end
	end
end
