-- huiwei
sgs.ai_skill_invoke.huwei = function(self, data)
	local damage = data:toDamage()
	local to   = damage.to
	return self:isFriend(damage.to) and damage.from~=self.player and not to:hasSkill("buqu")
	and (self:getCardsNum(".", self.player, "e") >= 1 or self.player:getHp() > to:getHp())
end

sgs.ai_skill_choice.huwei = function(self, choices)
	if self:getCardsNum(".", self.player, "e") >= 1 then
	return "qi" end
	if self:getCardsNum(".", self.player, "e") == 0 then
	return "jian" end
end

-- chexuan
sgs.ai_skill_invoke.chexuan= true

local pozhen_skill={}
pozhen_skill.name="pozhen"
table.insert(sgs.ai_skills,pozhen_skill)
pozhen_skill.getTurnUseCard=function(self)
	if not self.player:hasUsed("PozhenCard") and not self.player:isKongcheng() then
		local max_card = self:getMaxCard()
		return sgs.Card_Parse("@PozhenCard=" .. max_card:getEffectiveId())
	end
end

sgs.ai_skill_use_func.PozhenCard = function(card, use, self)
	local max_card = self:getMaxCard()
	local max_point = max_card:getNumber()
	local ptarget = self:getPriorTarget()
	local slashcount = self:getCardsNum("Slash")
	if max_card:inherits("Slash") then slashcount = slashcount - 1 end
	if not ptarget:isKongcheng() and slashcount > 0 and self.player:canSlash(ptarget, true)
	and not ptarget:hasSkill("kongcheng") and ptarget:getHandcardNum() == 1 then
		local card_id = max_card:getEffectiveId()
		local card_str = "@PozhenCard=" .. card_id
		if use.to then
			use.to:append(ptarget)
		end
		use.card = sgs.Card_Parse(card_str)
		return
	end
	self:sort(self.enemies, "defense")

	for _, enemy in ipairs(self.enemies) do
		if self:getCardsNum("Snatch") > 0 and not enemy:isKongcheng() then
			local enemy_max_card = self:getMaxCard(enemy)
			local allknown = 0
			if self:getKnownNum(enemy) == enemy:getHandcardNum() then
				allknown = allknown + 1
			end
			if (enemy_max_card and max_point > enemy_max_card:getNumber() and allknown > 0)
				or (enemy_max_card and max_point > enemy_max_card:getNumber() and allknown < 1 and max_point > 10)
				or (not enemy_max_card and max_point > 10) and
				(self:getDangerousCard(enemy) or self:getValuableCard(enemy)) then
					local card_id = max_card:getEffectiveId()
					local card_str = "@PozhenCard=" .. card_id
					if use.to then
						use.to:append(enemy)
					end
					use.card = sgs.Card_Parse(card_str)
					return
			end
		end
	end
	local cards = sgs.QList2Table(self.player:getHandcards())
	self:sortByUseValue(cards, true)
	if self:getUseValue(cards[1]) >= 6 or self:getKeepValue(cards[1]) >= 6 then return end
	if self:getOverflow() > 0 then
		if not ptarget:isKongcheng() then
			local card_id = max_card:getEffectiveId()
			local card_str = "@PozhenCard=" .. card_id
			if use.to then
				use.to:append(ptarget)
			end
			use.card = sgs.Card_Parse(card_str)
			return
		end
		for _, enemy in ipairs(self.enemies) do
			if not (enemy:hasSkill("kongcheng") and enemy:getHandcardNum() == 1) and not enemy:isKongcheng() and not enemy:hasSkill("tuntian") then
				use.card = sgs.Card_Parse("@PozhenCard=" .. cards[1]:getId())
				if use.to then use.to:append(enemy) end
				return
			end
		end
	end
end

sgs.ai_cardneed.pozhen = sgs.ai_cardneed.bignumber
sgs.ai_card_intention.PozhenCard = 30
sgs.dynamic_value.control_card.PozhenCard = true
sgs.ai_use_priority.PozhenCard = 8

-- jinguo
sgs.ai_skill_invoke.jinguo= true

sgs.ai_skill_choice.jinguo = function(self, choices)
	if self.player:isWounded() then return "huixue" end
	return "mopai"
end

sgs.ai_skill_invoke.guashuai = function(self, data)
	return self.player:getHandcardNum() <= 1
end

sgs.ai_skill_playerchosen.guashuai = function(self, targets)
	for _, player in sgs.qlist(targets) do
		if player:hasSkill("guashuai") and self:isFriend(player) and player:getHandcardNum() <= 1 then
			return player
		end
	end
end

-- dianjiang
dianjiang_skill={}
dianjiang_skill.name = "dianjiang"
table.insert(sgs.ai_skills, dianjiang_skill)
dianjiang_skill.getTurnUseCard = function(self)
	if self.player:hasUsed("DianjiangCard") then return end
	local slash = self:getCard("Slash")
	if not slash then return end
	return sgs.Card_Parse("@DianjiangCard=" .. slash:getEffectiveId())
end
sgs.ai_skill_use_func["DianjiangCard"] = function(card, use, self)
	self:sort(self.friends,"threat")
	for _, friend in ipairs(self.friends) do
		if friend:getGeneral():isMale() then
			use.card = card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

sgs.ai_skill_choice.dianjiang = function(self, choices)
	if self.player:getHandcardNum() >= 3 then return "bieren" end
	return "ziji"
end

--yanxiao
local yanxiao_skill={}
yanxiao_skill.name="yanxiao"
table.insert(sgs.ai_skills,yanxiao_skill)
yanxiao_skill.getTurnUseCard=function(self)
	local cards = self.player:getHandcards()
	local fks = {}
	for _, card in sgs.qlist(cards) do
		if card:getSuit() == sgs.Card_Diamond then
			table.insert(fks, card)
		end
	end

	if #fks == 0 or self.player:getHandcardNum() <= 1 then return end
	self:sortByUseValue(fks, true)

	local card_str = ("@YanxiaoCard=%d"):format(fks[1]:getEffectiveId())
	return sgs.Card_Parse(card_str)
end

sgs.ai_skill_use_func["YanxiaoCard"]=function(card,use,self)
	for _, friend in ipairs(self.friends) do
	local judges = friend:getJudgingArea()
	if (not judges:isEmpty() or friend:isKongcheng()) and friend:getPile("xiao"):isEmpty() then
			use.card=card
			if use.to then use.to:append(friend) end
			return
		end
	end
end

-- anxian
sgs.ai_skill_invoke.anxian= true

sgs.ai_skill_discard.anxian = function(self, discard_num, optional, include_equip)
		return to_discard
end
