/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.widget.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jb2011.lnf.beautyeye.utils.BEUtils;

public class BERoundBorder
extends LineBorder
implements UIResource {
    public static final Color defaultLineColor = new Color(188, 188, 188);
    protected int arcWidth = 0;

    public BERoundBorder() {
        this(defaultLineColor, 1);
    }

    public BERoundBorder(Color color) {
        this(color, 1);
    }

    public BERoundBorder(int thickness) {
        this(defaultLineColor, thickness);
    }

    public BERoundBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets margin = null;
        if (c instanceof AbstractButton) {
            margin = ((AbstractButton)c).getMargin();
        } else if (c instanceof JToolBar) {
            margin = ((JToolBar)c).getMargin();
        } else if (c instanceof JTextComponent) {
            margin = ((JTextComponent)c).getMargin();
        }
        insets.top = (margin != null ? margin.top : 0) + this.thickness;
        insets.left = (margin != null ? margin.left : 0) + this.thickness;
        insets.bottom = (margin != null ? margin.bottom : 0) + this.thickness;
        insets.right = (margin != null ? margin.right : 0) + this.thickness;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        BEUtils.setAntiAliasing((Graphics2D)g, true);
        Container cp = c.getParent();
        g.setColor(this.lineColor);
        int i = 0;
        while (i < this.thickness) {
            g.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.arcWidth, this.arcWidth);
            if (this.thickness > 1) {
                g.setColor(BEUtils.getColor(g.getColor(), 70, 70, 70, -50));
            }
            ++i;
        }
        g.setColor(oldColor);
        BEUtils.setAntiAliasing((Graphics2D)g, false);
    }

    public BERoundBorder setLineColor(Color c) {
        this.lineColor = c;
        return this;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public BERoundBorder setThickness(int t) {
        this.thickness = t;
        return this;
    }

    public Object clone() {
        BERoundBorder bb = new BERoundBorder(this.getLineColor(), this.getThickness());
        return bb;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public BERoundBorder setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
        return this;
    }
}

