/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch15_slider;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jb2011.lnf.beautyeye.ch15_slider.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.ch15_slider.__IconFactory__;
import org.jb2011.lnf.beautyeye.utils.BEUtils;

public class BESliderUI
extends BasicSliderUI {
    protected final int THUMB_HEIGHT_HORIZONAL = 7;
    protected final int THUMB_WIDTH_VERTICAL = 7;

    public BESliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent b) {
        return new BESliderUI((JSlider)b);
    }

    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - 2;
            int cw = trackBounds.width;
            g.translate(trackBounds.x, trackBounds.y + cy);
            if (this.slider.isEnabled()) {
                __Icon9Factory__.getInstance().getSliderTrack().draw((Graphics2D)g, 0, 0, cw, 7);
                __Icon9Factory__.getInstance().getSliderTrack_forground().draw((Graphics2D)g, 0, 0, this.thumbRect.x, 7);
            } else {
                __Icon9Factory__.getInstance().getSliderTrack_disable().draw((Graphics2D)g, 0, 0, cw, 7);
                __Icon9Factory__.getInstance().getSliderTrack_forground_disable().draw((Graphics2D)g, 0, 0, this.thumbRect.x, 7);
            }
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int cx = trackBounds.width / 2 - 2;
            int ch = trackBounds.height;
            g.translate(trackBounds.x + cx, trackBounds.y);
            if (this.slider.isEnabled()) {
                __Icon9Factory__.getInstance().getSliderTrack_VERITICAL().draw((Graphics2D)g, 0, 0, 7, ch);
                __Icon9Factory__.getInstance().getSliderTrack_VERTICAL_forground().draw((Graphics2D)g, 0, this.thumbRect.y, 7, ch - this.thumbRect.y);
            } else {
                __Icon9Factory__.getInstance().getSliderTrack_VERITICAL_disable().draw((Graphics2D)g, 0, 0, 7, ch);
                __Icon9Factory__.getInstance().getSliderTrack_VERTICAL_forground_disable().draw((Graphics2D)g, 0, this.thumbRect.y, 7, ch - this.thumbRect.y);
            }
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    public void paintFocus(Graphics g) {
        g.setColor(this.getFocusColor());
        BEUtils.drawDashedRect(g, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h = knobBounds.height;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getBackground());
        } else {
            g.setColor(this.slider.getBackground().darker());
        }
        if (this.isPaintNoTrangleThumb()) {
            if (this.slider.getOrientation() == 0) {
                g.drawImage(this.slider.isEnabled() ? __IconFactory__.getInstance().getSliderTick1_notrangle().getImage() : __IconFactory__.getInstance().getSliderTick1_notrangle_disable().getImage(), 0, 0, null);
            } else {
                g.drawImage(this.slider.isEnabled() ? __IconFactory__.getInstance().getSliderTick1_notrangle_vertical().getImage() : __IconFactory__.getInstance().getSliderTick1_notrangle_VERTICAL_disable().getImage(), 0, 0, null);
            }
        } else if (this.slider.getOrientation() == 0) {
            g.drawImage(this.slider.isEnabled() ? __IconFactory__.getInstance().getSliderTick1().getImage() : __IconFactory__.getInstance().getSliderTick1_disable().getImage(), 0, 0, null);
        } else {
            g.drawImage(this.slider.isEnabled() ? __IconFactory__.getInstance().getSliderTick1_vertical().getImage() : __IconFactory__.getInstance().getSliderTick1_VERTICAL_disable().getImage(), 0, 0, null);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    protected boolean isPaintNoTrangleThumb() {
        Boolean paintThumbArrowShape = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        return !this.slider.getPaintTicks() && paintThumbArrowShape == null || paintThumbArrowShape == Boolean.FALSE;
    }

    protected Dimension getThumbSize() {
        boolean isPaintNoTrangle = this.isPaintNoTrangleThumb();
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 17;
            size.height = isPaintNoTrangle ? 16 : 12;
        } else {
            size.width = isPaintNoTrangle ? 16 : 12;
            size.height = 17;
        }
        return size;
    }
}

