/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.EUC_CN;
import sun.nio.cs.ext.EUC_TW;
import sun.nio.cs.ext.ExtendedCharsets;

public class ISO2022_CN
extends Charset
implements HistoricallyNamedCharset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte SODesigGB = 0;
    private static final byte SODesigCNS = 1;
    private static final byte SS2Desig = 2;
    private static final byte SS3Desig = 3;
    private static CharsetDecoder gb2312Decoder = null;
    private static CharsetDecoder cnsDecoder = null;

    public ISO2022_CN() {
        super("ISO-2022-CN", ExtendedCharsets.aliasesFor("ISO-2022-CN"));
    }

    public String historicalName() {
        return "ISO2022CN";
    }

    public boolean contains(Charset charset) {
        return charset instanceof EUC_CN || charset instanceof US_ASCII || charset instanceof EUC_TW || charset instanceof ISO2022_CN;
    }

    public CharsetDecoder newDecoder() {
        gb2312Decoder = new EUC_CN().newDecoder();
        cnsDecoder = new EUC_TW().newDecoder();
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    public boolean canEncode() {
        return false;
    }

    static class Decoder
    extends CharsetDecoder {
        private boolean shiftOut = false;
        private byte currentSODesig = 0;
        private ByteBuffer bBuf = ByteBuffer.allocate(4);

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected void implReset() {
            this.shiftOut = false;
            this.currentSODesig = 0;
        }

        private char cnsDecode(byte by, byte by2, byte by3, byte by4) {
            by3 = (byte)(by3 | 0xFFFFFF80);
            by4 = (byte)(by4 | 0xFFFFFF80);
            this.bBuf.clear();
            try {
                this.bBuf.put(by);
                this.bBuf.put(by2);
                this.bBuf.put(by3);
                this.bBuf.put(by4);
                this.bBuf.flip();
                return cnsDecoder.decode(this.bBuf).get();
            }
            catch (CharacterCodingException characterCodingException) {
                return '\ufffd';
            }
        }

        private char SODecode(byte by, byte by2, byte by3) {
            by = (byte)(by | 0xFFFFFF80);
            by2 = (byte)(by2 | 0xFFFFFF80);
            this.bBuf.clear();
            try {
                this.bBuf.put(by);
                this.bBuf.put(by2);
                this.bBuf.flip();
                if (by3 == 0) {
                    return gb2312Decoder.decode(this.bBuf).get();
                }
                if (by3 == 1) {
                    return cnsDecoder.decode(this.bBuf).get();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
            return '\ufffd';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeBufferLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = var1_1.position();
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 0;
            try {
                while (var1_1.hasRemaining()) {
                    var4_4 = var1_1.get();
                    var8_8 = 1;
                    while (var4_4 == 27 || var4_4 == 14 || var4_4 == 15) {
                        block51: {
                            block50: {
                                if (var4_4 != 27) ** GOTO lbl87
                                this.currentSODesig = 0;
                                if (var1_1.remaining() < 1) {
                                    var9_9 = CoderResult.UNDERFLOW;
                                    return var9_9;
                                }
                                var5_5 = var1_1.get();
                                ++var8_8;
                                if ((var5_5 & -128) != 0) {
                                    var9_10 = CoderResult.malformedForLength(var8_8);
                                    return var9_10;
                                }
                                if (var5_5 != 36) ** GOTO lbl71
                                if (var1_1.remaining() < 1) {
                                    var9_11 = CoderResult.UNDERFLOW;
                                    return var9_11;
                                }
                                var6_6 = var1_1.get();
                                ++var8_8;
                                if ((var6_6 & -128) != 0) {
                                    var9_12 = CoderResult.malformedForLength(var8_8);
                                    return var9_12;
                                }
                                if (var6_6 != 65) break block50;
                                this.currentSODesig = 0;
                                break block51;
                            }
                            if (var6_6 != 41) ** GOTO lbl49
                            if (var1_1.remaining() < 1) {
                                var9_13 = CoderResult.UNDERFLOW;
                                return var9_13;
                            }
                            var7_7 = var1_1.get();
                            ++var8_8;
                            if (var7_7 == 65) {
                                this.currentSODesig = 0;
                            } else if (var7_7 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var9_14 = CoderResult.malformedForLength(var8_8);
                                return var9_14;
lbl49:
                                // 1 sources

                                if (var6_6 == 42) {
                                    if (var1_1.remaining() < 1) {
                                        var9_15 = CoderResult.UNDERFLOW;
                                        return var9_15;
                                    }
                                    var7_7 = var1_1.get();
                                    ++var8_8;
                                    if (var7_7 != 72) {
                                        var9_16 = CoderResult.malformedForLength(var8_8);
                                        return var9_16;
                                    }
                                } else if (var6_6 == 43) {
                                    if (var1_1.remaining() < 1) {
                                        var9_17 = CoderResult.UNDERFLOW;
                                        return var9_17;
                                    }
                                    var7_7 = var1_1.get();
                                    ++var8_8;
                                    if (var7_7 != 73) {
                                        var9_18 = CoderResult.malformedForLength(var8_8);
                                        return var9_18;
                                    }
                                } else {
                                    var9_19 = CoderResult.malformedForLength(var8_8);
                                    return var9_19;
lbl71:
                                    // 1 sources

                                    if (var5_5 == 78 || var5_5 == 79) {
                                        if (var1_1.remaining() < 2) {
                                            var9_20 = CoderResult.UNDERFLOW;
                                            return var9_20;
                                        }
                                        var6_6 = var1_1.get();
                                        var7_7 = var1_1.get();
                                        var8_8 += 2;
                                        v0 = var5_5 = var5_5 == 78 ? -94 : -93;
                                        if (var2_2.remaining() < 1) {
                                            var9_21 = CoderResult.OVERFLOW;
                                            return var9_21;
                                        }
                                        var2_2.put(this.cnsDecode((byte)-114, var5_5, var6_6, var7_7));
                                    } else {
                                        var9_22 = CoderResult.malformedForLength(var8_8);
                                        return var9_22;
lbl87:
                                        // 1 sources

                                        if (var4_4 == 14) {
                                            this.shiftOut = true;
                                        } else if (var4_4 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        var3_3 += var8_8;
                        if (var1_1.remaining() < 1) {
                            var9_23 = CoderResult.UNDERFLOW;
                            return var9_23;
                        }
                        var4_4 = var1_1.get();
                        var8_8 = 1;
                    }
                    if (var2_2.remaining() < 1) {
                        var9_24 = CoderResult.OVERFLOW;
                        return var9_24;
                    }
                    if (!this.shiftOut) {
                        var2_2.put((char)var4_4);
                        var3_3 += var8_8;
                        continue;
                    }
                    if (var1_1.remaining() < 1) {
                        var9_25 = CoderResult.UNDERFLOW;
                        return var9_25;
                    }
                    var5_5 = var1_1.get();
                    var2_2.put(this.SODecode(var4_4, var5_5, this.currentSODesig));
                    var3_3 += ++var8_8;
                }
                var9_26 = CoderResult.UNDERFLOW;
                return var9_26;
            }
            finally {
                var1_1.position(var3_3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private CoderResult decodeArrayLoop(ByteBuffer var1_1, CharBuffer var2_2) {
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = var1_1.array();
            var9_9 = var1_1.arrayOffset() + var1_1.position();
            var10_10 = var1_1.arrayOffset() + var1_1.limit();
            if (!Decoder.$assertionsDisabled && var9_9 > var10_10) {
                throw new AssertionError();
            }
            var11_11 = var2_2.array();
            var12_12 = var2_2.arrayOffset() + var2_2.position();
            var13_13 = var2_2.arrayOffset() + var2_2.limit();
            if (!Decoder.$assertionsDisabled && var12_12 > var13_13) {
                throw new AssertionError();
            }
            var12_12 = var12_12 <= var13_13 ? var12_12 : var13_13;
            try {
                for (var9_9 = var9_9 <= var10_10 ? var9_9 : var10_10; var9_9 < var10_10; var9_9 += var3_3) {
                    var4_4 = var8_8[var9_9];
                    var3_3 = 1;
                    while (var4_4 == 27 || var4_4 == 14 || var4_4 == 15) {
                        block53: {
                            block52: {
                                if (var4_4 != 27) ** GOTO lbl96
                                this.currentSODesig = 0;
                                if (var9_9 + 2 > var10_10) {
                                    var14_14 = CoderResult.UNDERFLOW;
                                    return var14_14;
                                }
                                var5_5 = var8_8[var9_9 + 1];
                                ++var3_3;
                                if ((var5_5 & -128) != 0) {
                                    var14_15 = CoderResult.malformedForLength(var3_3);
                                    return var14_15;
                                }
                                if (var5_5 != 36) ** GOTO lbl81
                                if (var9_9 + 3 > var10_10) {
                                    var14_16 = CoderResult.UNDERFLOW;
                                    return var14_16;
                                }
                                var6_6 = var8_8[var9_9 + 2];
                                ++var3_3;
                                if ((var6_6 & -128) != 0) {
                                    var14_17 = CoderResult.malformedForLength(var3_3);
                                    return var14_17;
                                }
                                if (var6_6 != 65) break block52;
                                this.currentSODesig = 0;
                                break block53;
                            }
                            if (var6_6 != 41) ** GOTO lbl59
                            if (var9_9 + 4 > var10_10) {
                                var14_18 = CoderResult.UNDERFLOW;
                                return var14_18;
                            }
                            var7_7 = var8_8[var9_9 + 3];
                            ++var3_3;
                            if (var7_7 == 65) {
                                this.currentSODesig = 0;
                            } else if (var7_7 == 71) {
                                this.currentSODesig = 1;
                            } else {
                                var14_19 = CoderResult.malformedForLength(var3_3);
                                return var14_19;
lbl59:
                                // 1 sources

                                if (var6_6 == 42) {
                                    if (var9_9 + 4 > var10_10) {
                                        var14_20 = CoderResult.UNDERFLOW;
                                        return var14_20;
                                    }
                                    var7_7 = var8_8[var9_9 + 3];
                                    ++var3_3;
                                    if (var7_7 != 72) {
                                        var14_21 = CoderResult.malformedForLength(var3_3);
                                        return var14_21;
                                    }
                                } else if (var6_6 == 43) {
                                    if (var9_9 + 4 > var10_10) {
                                        var14_22 = CoderResult.UNDERFLOW;
                                        return var14_22;
                                    }
                                    var7_7 = var8_8[var9_9 + 3];
                                    ++var3_3;
                                    if (var7_7 != 73) {
                                        var14_23 = CoderResult.malformedForLength(var3_3);
                                        return var14_23;
                                    }
                                } else {
                                    var14_24 = CoderResult.malformedForLength(var3_3);
                                    return var14_24;
lbl81:
                                    // 1 sources

                                    if (var5_5 == 78 || var5_5 == 79) {
                                        if (var9_9 + 4 > var10_10) {
                                            var14_25 = CoderResult.UNDERFLOW;
                                            return var14_25;
                                        }
                                        var6_6 = var8_8[var9_9 + 2];
                                        var7_7 = var8_8[var9_9 + 3];
                                        v0 = var5_5 = var5_5 == 78 ? -94 : -93;
                                        if (var13_13 - var12_12 < 1) {
                                            var14_26 = CoderResult.OVERFLOW;
                                            return var14_26;
                                        }
                                        var3_3 += 2;
                                        var11_11[var12_12++] = this.cnsDecode((byte)-114, var5_5, var6_6, var7_7);
                                    } else {
                                        var14_27 = CoderResult.malformedForLength(var3_3);
                                        return var14_27;
lbl96:
                                        // 1 sources

                                        if (var4_4 == 14) {
                                            this.shiftOut = true;
                                        } else if (var4_4 == 15) {
                                            this.shiftOut = false;
                                        }
                                    }
                                }
                            }
                        }
                        if ((var9_9 += var3_3) + 1 > var10_10) {
                            var14_28 = CoderResult.UNDERFLOW;
                            return var14_28;
                        }
                        var4_4 = var8_8[var9_9];
                        var3_3 = 1;
                    }
                    if (var13_13 - var12_12 < 1) {
                        var14_29 = CoderResult.OVERFLOW;
                        return var14_29;
                    }
                    if (!this.shiftOut) {
                        var11_11[var12_12++] = (char)var4_4;
                        continue;
                    }
                    if (var9_9 + 2 > var10_10) {
                        var14_30 = CoderResult.UNDERFLOW;
                        return var14_30;
                    }
                    var5_5 = var8_8[var9_9 + 1];
                    ++var3_3;
                    var11_11[var12_12++] = this.SODecode(var4_4, var5_5, this.currentSODesig);
                }
                var14_31 = CoderResult.UNDERFLOW;
                return var14_31;
            }
            finally {
                var1_1.position(var9_9 - var1_1.arrayOffset());
                var2_2.position(var12_12 - var2_2.arrayOffset());
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

