/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.model;

import java.util.Arrays;
import weibo4j.Weibo;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.model.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class IDs
extends WeiboResponse {
    private long[] ids;
    private long previousCursor;
    private long nextCursor;
    private static final long serialVersionUID = -6585026560164704953L;

    IDs(Response res, Weibo w) throws WeiboException {
        super(res);
        if ("[]\n".equals(res.asString())) {
            this.previousCursor = 0L;
            this.nextCursor = 0L;
            this.ids = new long[0];
            return;
        }
        JSONObject json = res.asJSONObject();
        try {
            this.previousCursor = json.getLong("previous_cursor");
            this.nextCursor = json.getLong("next_cursor");
            if (!json.isNull("ids")) {
                JSONArray jsona = json.getJSONArray("ids");
                int size = jsona.length();
                this.ids = new long[size];
                int i = 0;
                while (i < size) {
                    this.ids[i] = jsona.getLong(i);
                    ++i;
                }
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public long[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.ids);
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDs{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

