/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import weibo4j.examples.oauth2.Log;
import weibo4j.http.ImageItem;
import weibo4j.http.Response;
import weibo4j.model.Configuration;
import weibo4j.model.MySSLSocketFactory;
import weibo4j.model.Paging;
import weibo4j.model.PostParameter;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;

public class HttpClient
implements Serializable {
    private static final long serialVersionUID = -176092625883595547L;
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();
    private String token;
    private static final boolean DEBUG = Configuration.getDebug();
    static Logger log = Logger.getLogger(HttpClient.class.getName());
    org.apache.commons.httpclient.HttpClient client = null;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private int maxSize;

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = Configuration.getProxyHost(proxyHost);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = Configuration.getProxyPort(proxyPort);
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = Configuration.getProxyUser(proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = Configuration.getProxyPassword(proxyAuthPassword);
    }

    public String setToken(String token) {
        this.token = token;
        return this.token;
    }

    public HttpClient() {
        this(150, 4000, 4000, 0x100000);
    }

    public HttpClient(int maxConPerHost, int conTimeOutMs, int soTimeOutMs, int maxSize) {
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(maxConPerHost);
        params.setConnectionTimeout(conTimeOutMs);
        params.setSoTimeout(soTimeOutMs);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setCookiePolicy("ignoreCookies");
        this.client = new org.apache.commons.httpclient.HttpClient(clientParams, (HttpConnectionManager)this.connectionManager);
        Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new MySSLSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)myhttps);
        this.maxSize = maxSize;
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            this.client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            this.client.getParams().setAuthenticationPreemptive(true);
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxyAuthUser, this.proxyAuthPassword));
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
            }
        }
    }

    private static void log(String message) {
    }

    public Response get(String url) throws WeiboException {
        return this.get(url, new PostParameter[0]);
    }

    public Response get(String url, PostParameter[] params) throws WeiboException {
        HttpClient.log("Request:");
        HttpClient.log("GET:" + url);
        if (params != null && params.length > 0) {
            String encodedParams = HttpClient.encodeParameters(params);
            url = -1 == url.indexOf("?") ? String.valueOf(url) + "?" + encodedParams : String.valueOf(url) + "&" + encodedParams;
        }
        Log.logInfo(url);
        GetMethod getmethod = new GetMethod(url);
        return this.httpRequest((HttpMethod)getmethod);
    }

    public Response get(String url, PostParameter[] params, Boolean isWeibo) throws WeiboException {
        HttpClient.log("Request:");
        HttpClient.log("GET:" + url);
        if (params != null && params.length > 0) {
            String encodedParams = HttpClient.encodeParameters(params);
            url = -1 == url.indexOf("?") ? String.valueOf(url) + "?" + encodedParams : String.valueOf(url) + "&" + encodedParams;
        }
        Log.logInfo(url);
        GetMethod getmethod = new GetMethod(url);
        return this.httpRequest((HttpMethod)getmethod, false);
    }

    public Response get(String url, PostParameter[] params, Paging paging) throws WeiboException {
        if (paging != null) {
            ArrayList<PostParameter> pagingParams = new ArrayList<PostParameter>(4);
            if (-1L != paging.getMaxId()) {
                pagingParams.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (-1L != paging.getSinceId()) {
                pagingParams.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                pagingParams.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1 != paging.getCount()) {
                if (-1 != url.indexOf("search")) {
                    pagingParams.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    pagingParams.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] newparams = null;
            PostParameter[] arrayPagingParams = pagingParams.toArray(new PostParameter[pagingParams.size()]);
            if (params != null) {
                newparams = new PostParameter[params.length + pagingParams.size()];
                System.arraycopy(params, 0, newparams, 0, params.length);
                System.arraycopy(arrayPagingParams, 0, newparams, params.length, pagingParams.size());
            } else if (arrayPagingParams.length != 0) {
                String encodedParams = HttpClient.encodeParameters(arrayPagingParams);
                url = -1 != url.indexOf("?") ? String.valueOf(url) + "&" + encodedParams : String.valueOf(url) + "?" + encodedParams;
            }
            return this.get(url, newparams);
        }
        return this.get(url, params);
    }

    public Response delete(String url, PostParameter[] params) throws WeiboException {
        if (params.length != 0) {
            String encodedParams = HttpClient.encodeParameters(params);
            url = -1 == url.indexOf("?") ? String.valueOf(url) + "?" + encodedParams : String.valueOf(url) + "&" + encodedParams;
        }
        DeleteMethod deleteMethod = new DeleteMethod(url);
        return this.httpRequest((HttpMethod)deleteMethod);
    }

    public Response post(String url, PostParameter[] params) throws WeiboException {
        return this.post(url, params, true);
    }

    public Response post(String url, PostParameter[] params, Boolean WithTokenHeader) throws WeiboException {
        HttpClient.log("Request:");
        HttpClient.log("POST" + url);
        PostMethod postMethod = new PostMethod(url);
        int i = 0;
        while (i < params.length) {
            postMethod.addParameter(params[i].getName(), params[i].getValue());
            ++i;
        }
        HttpMethodParams param = postMethod.getParams();
        param.setContentCharset("UTF-8");
        if (WithTokenHeader.booleanValue()) {
            return this.httpRequest((HttpMethod)postMethod);
        }
        return this.httpRequest((HttpMethod)postMethod, WithTokenHeader);
    }

    public Response multPartURL(String url, PostParameter[] params, ImageItem item) throws WeiboException {
        PostMethod postMethod = new PostMethod(url);
        try {
            Part[] parts = null;
            parts = params == null ? new Part[1] : new Part[params.length + 1];
            if (params != null) {
                int i = 0;
                PostParameter[] postParameterArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PostParameter entry = postParameterArray[n2];
                    parts[i++] = new StringPart(entry.getName(), entry.getValue());
                    ++n2;
                }
                parts[parts.length - 1] = new ByteArrayPart(item.getContent(), item.getName(), item.getContentType());
            }
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
            return this.httpRequest((HttpMethod)postMethod);
        }
        catch (Exception ex) {
            throw new WeiboException(ex.getMessage(), ex, -1);
        }
    }

    public Response multPartURL(String fileParamName, String url, PostParameter[] params, File file, boolean authenticated) throws WeiboException {
        PostMethod postMethod = new PostMethod(url);
        try {
            Part[] parts = null;
            parts = params == null ? new Part[1] : new Part[params.length + 1];
            if (params != null) {
                int i = 0;
                PostParameter[] postParameterArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    PostParameter entry = postParameterArray[n2];
                    parts[i++] = new StringPart(entry.getName(), entry.getValue());
                    ++n2;
                }
            }
            FilePart filePart = new FilePart(fileParamName, file.getName(), file, new MimetypesFileTypeMap().getContentType(file), "UTF-8");
            filePart.setTransferEncoding("binary");
            parts[parts.length - 1] = filePart;
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
            return this.httpRequest((HttpMethod)postMethod);
        }
        catch (Exception ex) {
            throw new WeiboException(ex.getMessage(), ex, -1);
        }
    }

    public Response httpRequest(HttpMethod method) throws WeiboException {
        return this.httpRequest(method, true);
    }

    public Response httpRequest(HttpMethod method, Boolean WithTokenHeader) throws WeiboException {
        int responseCode = -1;
        try {
            InetAddress ipaddr = InetAddress.getLocalHost();
            ArrayList<Header> headers = new ArrayList<Header>();
            if (WithTokenHeader.booleanValue()) {
                if (this.token == null) {
                    throw new IllegalStateException("Oauth2 token is not set!");
                }
                headers.add(new Header("Authorization", "OAuth2 " + this.token));
                headers.add(new Header("API-RemoteIP", ipaddr.getHostAddress()));
                this.client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
                for (Header hd : headers) {
                    HttpClient.log(String.valueOf(hd.getName()) + ": " + hd.getValue());
                }
            }
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            this.client.executeMethod(method);
            Header[] resHeader = method.getResponseHeaders();
            responseCode = method.getStatusCode();
            HttpClient.log("Response:");
            HttpClient.log("https StatusCode:" + String.valueOf(responseCode));
            Header[] headerArray = resHeader;
            int n = resHeader.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                HttpClient.log(String.valueOf(header.getName()) + ":" + header.getValue());
                ++n2;
            }
            Response response = new Response();
            response.setResponseAsString(method.getResponseBodyAsString());
            HttpClient.log(String.valueOf(response.toString()) + "\n");
            if (responseCode != 200) {
                try {
                    throw new WeiboException(HttpClient.getCause(responseCode), response.asJSONObject(), method.getStatusCode());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            Response response2 = response;
            return response2;
        }
        catch (IOException ioe) {
            throw new WeiboException(ioe.getMessage(), ioe, responseCode);
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < postParams.length) {
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(postParams[j].getName(), "UTF-8")).append("=").append(URLEncoder.encode(postParams[j].getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++j;
        }
        return buf.toString();
    }

    private static String getCause(int statusCode) {
        String cause = null;
        switch (statusCode) {
            case 304: {
                break;
            }
            case 400: {
                cause = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                cause = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                cause = "The request is understood, but it has been refused.  An accompanying error message will explain why.";
                break;
            }
            case 404: {
                cause = "The URI requested is invalid or the resource requested, such as a user, does not exists.";
                break;
            }
            case 406: {
                cause = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                cause = "Something is broken.  Please post to the group so the Weibo team can investigate.";
                break;
            }
            case 502: {
                cause = "Weibo is down or being upgraded.";
                break;
            }
            case 503: {
                cause = "Service Unavailable: The Weibo servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return String.valueOf(statusCode) + ":" + cause;
    }

    private static class ByteArrayPart
    extends PartBase {
        private byte[] mData;
        private String mName;

        public ByteArrayPart(byte[] data, String name, String type) throws IOException {
            super(name, type, "UTF-8", "binary");
            this.mName = name;
            this.mData = data;
        }

        protected void sendData(OutputStream out) throws IOException {
            out.write(this.mData);
        }

        protected long lengthOfData() throws IOException {
            return this.mData.length;
        }

        protected void sendDispositionHeader(OutputStream out) throws IOException {
            super.sendDispositionHeader(out);
            StringBuilder buf = new StringBuilder();
            buf.append("; filename=\"").append(this.mName).append("\"");
            out.write(buf.toString().getBytes());
        }
    }
}

