/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.examples.oauth2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import weibo4j.Oauth;
import weibo4j.Timeline;
import weibo4j.Users;
import weibo4j.Weibo;
import weibo4j.examples.oauth2.Log;
import weibo4j.http.AccessToken;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.util.BareBonesBrowserLaunch;

public class OAuth4Code {
    public static void main(String[] args) throws WeiboException, IOException {
        Oauth oauth = new Oauth();
        BareBonesBrowserLaunch.openURL(oauth.authorize("code"));
        System.out.println(oauth.authorize("code"));
        System.out.print("Hitenter when it's done.[Enter]:");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String code = br.readLine();
        Log.logInfo("code:" + code);
        AccessToken accessToken = null;
        try {
            accessToken = oauth.getAccessTokenByCode(code);
        }
        catch (WeiboException e) {
            if (401 == e.getStatusCode()) {
                Log.logInfo("Unableto get the access token.");
            }
            e.printStackTrace();
        }
        String access_token = accessToken.getAccessToken();
        System.out.println(access_token);
        Weibo weibo = new Weibo();
        weibo.setToken(access_token);
        String uid = accessToken.getUid();
        Users um = new Users();
        try {
            User user = um.showUserById(uid);
            System.out.println("\u5f53\u524d\u7528\u6237\u7684\u540d\u5b57\uff1a" + user.getName());
            System.out.println("\u5f53\u524d\u7528\u6237\u6240\u53d1\u7684\u5fae\u535a\u6570\uff1a" + user.getStatusesCount());
            System.out.println("\u5f53\u524d\u7528\u6237\u5173\u6ce8\u6570\uff1a" + user.getFriendsCount());
            System.out.println("\u5f53\u524d\u7528\u6237\u7c89\u4e1d\u6570\uff1a" + user.getFollowersCount());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        Timeline tm = new Timeline();
        System.out.print("\u8bf7\u8f93\u5165\u6240\u8981\u53d1\u7684\u5fae\u535a\u7684\u6587\u672c\u5185\u5bb9:[Enter]:");
        br = new BufferedReader(new InputStreamReader(System.in));
        String newStatus = br.readLine();
        tm.UpdateStatus(newStatus);
    }
}

