/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.Oauth2Code;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import weibo4j.model.User;
import weibo4j.util.BareBonesBrowserLaunch;

public class UserHeadImg
extends JLabel {
    private static final long serialVersionUID = -856655269996837618L;

    public UserHeadImg(final User user) {
        if (user == null) {
            return;
        }
        URL profile = user.getProfileImageURL();
        if (profile == null) {
            try {
                profile = new URL("http://img.t.sinajs.cn/t4/style/images/face/male_medium.png");
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        ImageIcon userImg = new ImageIcon(profile);
        this.setIcon(userImg);
        this.setCursor(new Cursor(12));
        this.setSize(this.getPreferredSize());
        this.setToolTipText(this.getTureTip(user));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                UserHeadImg.this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                UserHeadImg.this.setBorder(null);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String url = "http://weibo.com/" + user.getId();
                BareBonesBrowserLaunch.openURL(url);
            }
        });
    }

    private String getTureTip(User user) {
        int width = 300;
        String begin = "<html><head></head><body style=\"background:#FFFFFF;\" >";
        String end = "</body></html>";
        String fontBegin = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" size=\"3\">";
        String fontEnd = "</font>";
        String content = "<table width=\"" + width + "\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">" + "<tr>" + "<td rowspan=\"3\"  width=\"50\"><img src=\"" + user.getProfileImageURL() + "\"></td>" + "<td rowspan=\"1\">" + fontBegin + "&nbsp;&nbsp;" + user.getName() + "&nbsp;&nbsp;" + UserHeadImg.getRelation(user) + fontEnd + "</td>" + "</tr>" + "<tr>" + "<td rowspan=\"1\">" + fontBegin + "&nbsp;&nbsp;" + UserHeadImg.getGender(user.getGender()) + "&nbsp;&nbsp;" + user.getLocation() + fontEnd + "</td>" + "</tr>" + "<tr>" + "<td rowspan=\"1\">" + fontBegin + "&nbsp;&nbsp;\u5173\u6ce8 " + user.getFriendsCount() + "&nbsp;&nbsp;|&nbsp;&nbsp;\u7c89\u4e1d " + UserHeadImg.getCount(user.getFollowersCount()) + "&nbsp;&nbsp;|&nbsp;&nbsp;\u5fae\u535a " + user.getStatusesCount() + fontEnd + "</td>" + "</tr>" + "</table>";
        String result = begin;
        result = String.valueOf(result) + content;
        result = String.valueOf(result) + UserHeadImg.getTrueDecrip(user.getDescription(), 25);
        result = String.valueOf(result) + end;
        return result;
    }

    private static String getTrueDecrip(String text, int width) {
        StringBuffer sb = new StringBuffer("<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" size=\"3\">\u7b80\u4ecb\uff1a");
        int len = text.length();
        int last = 0;
        int i = 1;
        while (i < len) {
            if (i % width == 0) {
                sb.append(text.substring(i - width, i));
                sb.append("<br/>");
                last = i;
            }
            ++i;
        }
        sb.append(text.substring(last));
        sb.append("</font>");
        return sb.toString();
    }

    private static String getRelation(User user) {
        if (user.equals(Oauth2Code.getUser())) {
            return "";
        }
        if (user.isFollowing() && user.isfollowMe()) {
            return "\u4e92\u76f8\u5173\u6ce8";
        }
        if (user.isFollowing()) {
            return "\u5df2\u5173\u6ce8";
        }
        return "\u672a\u5173\u6ce8";
    }

    public static String getGender(String flag) {
        if (flag.equals("m")) {
            return "\u7537";
        }
        if (flag.equals("f")) {
            return "\u5973";
        }
        return "";
    }

    public static String getCount(int count) {
        int num = count / 10000;
        if (num != 0) {
            return String.valueOf(Integer.toString(num)) + "\u4e07";
        }
        return Integer.toString(count);
    }
}

