/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.ImageDropTargetListener;
import com.wtools.binary.ShowImage;
import com.wtools.util.FileOperation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import weibo4j.Timeline;
import weibo4j.http.ImageItem;
import weibo4j.model.WeiboException;

public class SendImage
extends JFrame {
    private static final long serialVersionUID = 3367550336433904925L;
    protected static final String FAIL = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
    protected static final String ERROR_STR = "\u9519\u8bef";
    private static final String ENSURE = "\u786e\u5b9a";
    private JTextArea textArea;
    private JLabel tip = new JLabel("(\u4f60\u8fd8\u53ef\u8f93\u5165140\u4e2a\u5b57\u3002)");
    private JPanel imgPanel;
    private String currentImgPath;
    private File imgFile;
    private JFileChooser fileChooser;

    public SendImage() {
        this.setTitle("\u53d1\u56fe");
        this.setLayout(null);
        this.setSize(500, 610);
        this.setLocationRelativeTo(this.getOwner());
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.getContentPane().setBackground(Color.white);
        this.initFileChooser();
        this.initUpPanel();
        this.initImgPanel();
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        new DropTarget(this, 1, new ImageDropTargetListener(this));
    }

    private void initFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.updateUI();
        this.fileChooser.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("\u56fe\u7247\u6587\u4ef6(*.bmp, *.gif, *.jpg, *.jpeg, *.png)", "bmp", "gif", "jpg", "jpeg", "png");
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setDialogTitle("\u9009\u62e9\u56fe\u7247\u6587\u4ef6");
    }

    private void initUpPanel() {
        JPanel up = new JPanel(new BorderLayout());
        up.setBounds(0, 0, 485, 150);
        up.add(this.getScrollPane());
        up.add((Component)this.getButtonPanel(), "South");
        this.add(up);
    }

    private void initTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SendImage.this.invoke();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                SendImage.this.invoke();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                SendImage.this.invoke();
            }
        });
    }

    private JScrollPane getScrollPane() {
        this.initTextArea();
        JScrollPane jsp = new JScrollPane(this.textArea);
        jsp.setVerticalScrollBarPolicy(20);
        jsp.setHorizontalScrollBarPolicy(30);
        this.add((Component)jsp, "Center");
        return jsp;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBackground(Color.white);
        this.tip.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        panel.add(this.tip);
        JButton select = new JButton("\u9009\u62e9\u56fe\u7247");
        select.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SendImage.this.currentImgPath = SendImage.this.getSelectResult();
                SendImage.this.imgPanel.repaint();
            }
        });
        panel.add(select);
        JButton submit = new JButton(ENSURE);
        submit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isSuccess;
                String content = SendImage.this.textArea.getText();
                if (content.equals("")) {
                    content = "\u5206\u4eab\u56fe\u7247\uff01";
                }
                if (isSuccess = SendImage.this.upload(content, SendImage.this.imgFile)) {
                    JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u6210\u529f\uff01");
                } else {
                    JOptionPane.showMessageDialog(null, SendImage.FAIL, SendImage.ERROR_STR, 0);
                }
                SendImage.this.dispose();
            }
        });
        panel.add(submit);
        return panel;
    }

    private boolean upload(String content, File file) {
        String changeEncode = null;
        try {
            changeEncode = URLEncoder.encode(content, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        Timeline tl = new Timeline();
        try {
            ImageItem item = new ImageItem(this.getBytes(file));
            return tl.UploadStatus(changeEncode, item) != null;
        }
        catch (WeiboException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void invoke() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int num = 140 - SendImage.this.textArea.getText().length();
                SendImage.this.tip.setText("(\u4f60\u8fd8\u53ef\u8f93\u5165" + num + "\u4e2a\u5b57\u3002)");
                SendImage.this.tip.validate();
            }
        });
    }

    private void initImgPanel() {
        this.imgPanel = new JPanel(){
            private static final long serialVersionUID = -6137943389247921004L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                SendImage.this.imgPanel.setToolTipText(SendImage.this.currentImgPath);
                if (SendImage.this.currentImgPath == null || SendImage.this.currentImgPath.equals("")) {
                    return;
                }
                SendImage.this.imgFile = new File(SendImage.this.currentImgPath);
                Image image = FileOperation.getImageByFile(SendImage.this.imgFile);
                int imgWidth = image.getWidth(null);
                int imgHeight = image.getHeight(null);
                int panelWidth = this.getWidth();
                int panelHeight = this.getHeight();
                int paintWidth = panelWidth;
                int paintHeight = panelHeight;
                int paintX = 0;
                int paintY = 0;
                if (imgWidth <= panelWidth && imgHeight <= panelHeight) {
                    paintWidth = image.getWidth(null);
                    paintHeight = image.getHeight(null);
                    paintX = (panelWidth - paintWidth) / 2;
                    paintY = (panelHeight - paintHeight) / 2;
                } else if (imgWidth >= panelWidth && imgHeight <= panelHeight) {
                    double scale = (double)panelWidth / (double)imgWidth;
                    paintHeight = (int)((double)imgHeight * scale);
                    paintY = (panelHeight - paintHeight) / 2;
                } else if (imgWidth <= panelWidth && imgHeight >= panelHeight) {
                    double scale = (double)panelHeight / (double)imgHeight;
                    paintWidth = (int)((double)imgWidth * scale);
                    paintX = (panelWidth - paintWidth) / 2;
                } else {
                    double scaleX = (double)panelWidth / (double)imgWidth;
                    double scaleY = (double)panelHeight / (double)imgHeight;
                    double scale = scaleX < scaleY ? scaleX : scaleY;
                    paintWidth = (int)((double)imgWidth * scale);
                    paintHeight = (int)((double)imgHeight * scale);
                    paintX = (panelWidth - paintWidth) / 2;
                    paintY = (panelHeight - paintHeight) / 2;
                }
                g.drawImage(image, paintX, paintY, paintWidth, paintHeight, this);
            }
        };
        this.imgPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SendImage.this.currentImgPath != null) {
                    new ShowImage(SendImage.this.currentImgPath, "File");
                }
            }
        });
        this.imgPanel.setBackground(Color.white);
        this.imgPanel.setBounds(0, 150, 485, 420);
        this.add(this.imgPanel);
    }

    private String getSelectResult() {
        int result = this.fileChooser.showDialog(null, ENSURE);
        if (result == 0) {
            this.imgPanel.setCursor(new Cursor(12));
            return this.fileChooser.getSelectedFile().getPath();
        }
        return null;
    }

    private byte[] getBytes(File file) {
        ByteArrayOutputStream out;
        block15: {
            out = new ByteArrayOutputStream();
            FileInputStream in = null;
            int length = 0;
            byte[] sendBytes = null;
            try {
                try {
                    in = new FileInputStream(file);
                    sendBytes = new byte[4096];
                    while ((length = in.read(sendBytes, 0, sendBytes.length)) > 0) {
                        out.write(sendBytes, 0, length);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return out.toByteArray();
    }

    public void repaintImgPanel(String currentImgPath) {
        this.currentImgPath = currentImgPath;
        this.imgPanel.repaint();
        this.imgPanel.setCursor(new Cursor(12));
    }
}

