/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.FriendsOrFollowers;
import com.wtools.binary.MyScrollPane;
import com.wtools.binary.OneUser;
import com.wtools.binary.PersonalInform;
import com.wtools.binary.UserTimeline;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weibo4j.model.User;

public class OtherUser
extends JFrame {
    private static final long serialVersionUID = -4769397211373445743L;
    private JTabbedPane tabbedPane;
    private final boolean[] arrayOfTab;
    private User user;

    public OtherUser(User user) {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        this.arrayOfTab = blArray;
        this.user = user;
        this.setTitle(user.getName());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setSize(500, 610);
        this.setLocationRelativeTo(this.getOwner());
        this.getContentPane().setBackground(Color.white);
        PersonalInform personMsg = new PersonalInform(user);
        personMsg.setBounds(0, 0, 485, 95);
        this.add(personMsg);
        this.initTabbedPanel();
        this.setVisible(true);
    }

    private void initTabbedPanel() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 11));
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("\u5fae\u535a", null, new MyScrollPane(new UserTimeline(this.user)), "\u5fae\u535a");
        this.tabbedPane.addTab("\u5173\u6ce8", null, new MyScrollPane(), "\u5173\u6ce8");
        this.tabbedPane.addTab("\u7c89\u4e1d", null, new MyScrollPane(), "\u7c89\u4e1d");
        this.tabbedPane.setBounds(0, 96, 485, 475);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = OtherUser.this.tabbedPane.getSelectedIndex();
                if (OtherUser.this.arrayOfTab[index]) {
                    return;
                }
                FirstClick thread = new FirstClick((MyScrollPane)OtherUser.this.tabbedPane.getSelectedComponent(), index);
                thread.start();
            }
        });
    }

    private class FirstClick
    extends Thread {
        private static final int FRIENDS = 1;
        private static final int FOLLOWERS = 2;
        private MyScrollPane msp;
        private int index;

        public FirstClick(MyScrollPane msp, int index) {
            this.msp = msp;
            this.index = index;
            ((OtherUser)OtherUser.this).arrayOfTab[index] = true;
        }

        @Override
        public void run() {
            if (this.index == 1) {
                this.msp.setViewportView(new FriendsOrFollowers(OtherUser.this.user, OneUser.UserType.OTHER_USER_FRIENDS));
            } else if (this.index == 2) {
                this.msp.setViewportView(new FriendsOrFollowers(OtherUser.this.user, OneUser.UserType.OTHER_USER_FOLLOWERS));
            }
        }
    }
}

