/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.MyLabel;
import com.wtools.binary.OnePanel;
import com.wtools.binary.UserHeadImg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import weibo4j.model.User;

public class OneUser
extends OnePanel {
    private static final long serialVersionUID = -3581659698954426122L;
    public static final int CURRENT_USER_QUERY = 1;
    public static final int NO_CURRENT_USER_QUERY = 2;
    private static final String MUTUAL = "images/mutual.png";
    private static final Font FONT = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
    private JLabel mutualLabel;
    private JPanel inner;
    private int panelWidth;

    public OneUser(User user) throws ClassCastException {
        this.setLayout(new BorderLayout());
        this.inner = new JPanel();
        this.inner.setBackground(Color.white);
        this.inner.setLayout(null);
        UserHeadImg userHead = new UserHeadImg(user);
        userHead.setBounds(this.locX, this.locY, this.headImgWidth, this.headImgHeight);
        this.inner.add(userHead);
        this.initFollowLabel(user);
        this.initMutualLabel(user);
        int leftHeight = this.locY + this.headImgHeight + 5;
        this.initNameAndLocation(user);
        this.initBasicMsg(user);
        int rightHeight = this.locY;
        if (user.getDescription() != null) {
            rightHeight += this.initDescrip(user);
        }
        this.inner.setBorder(border);
        this.allHeight = rightHeight > leftHeight ? rightHeight : leftHeight;
        this.allHeight += 5;
        this.setPreferredSize(new Dimension(this.allWidth, this.allHeight));
        this.add(this.inner);
    }

    private int initDescrip(User user) {
        JTextPane textPanel = this.initTextPanel();
        textPanel.setFont(FONT);
        textPanel.setText(this.setForms("\u7b80\u4ecb\uff1a" + user.getDescription()));
        Dimension dm = textPanel.getPreferredSize();
        textPanel.setSize(this.allWidth - this.headImgWidth, (int)dm.getHeight());
        int textPanelHeight = (int)textPanel.getPreferredSize().getHeight();
        textPanel.setBounds(this.locX + this.headImgWidth, this.locY, this.allWidth - this.headImgWidth - 5, textPanelHeight);
        this.inner.add(textPanel);
        return textPanelHeight;
    }

    private void initNameAndLocation(User user) {
        JTextPane textPanel = this.initTextPanel();
        textPanel.setFont(FONT);
        String text = "<a href='@" + user.getName() + "'>" + user.getName() + "</a>";
        String remark = user.getRemark();
        text = remark != null ? String.valueOf(text) + "(" + remark + ")<font size='3'>&nbsp&nbsp" : String.valueOf(text) + "<font size='3'>&nbsp&nbsp";
        String gender = user.getGender();
        if (gender.equals("m")) {
            text = String.valueOf(text) + "\u7537";
        } else if (gender.equals("f")) {
            text = String.valueOf(text) + "\u5973";
        }
        text = String.valueOf(text) + "&nbsp&nbsp" + user.getLocation() + "</font>";
        textPanel.setText(text);
        textPanel.setLocation(this.locX + this.headImgWidth, this.locY);
        Dimension dm = textPanel.getPreferredSize();
        textPanel.setSize(dm);
        this.inner.add(textPanel);
        this.locY = (int)((double)this.locY + dm.getHeight());
    }

    private void initFollowLabel(User user) {
        MyLabel follow = new MyLabel("\u53d6\u6d88\u6536\u85cf", user);
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBackground(Color.white);
        panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        panel.add(follow);
        Dimension dm = panel.getPreferredSize();
        if (user.isFollowing()) {
            follow.setText("\u53d6\u6d88\u5173\u6ce8");
        } else {
            follow.setText("+\u5173\u6ce8");
        }
        this.panelWidth = (int)dm.getWidth();
        int labelLocX = this.allWidth - this.panelWidth - 5;
        panel.setSize(dm);
        panel.setLocation(labelLocX, this.locY);
        this.inner.add(panel);
    }

    private void initMutualLabel(User user) {
        this.mutualLabel = new JLabel(new ImageIcon(MUTUAL));
        this.mutualLabel.setToolTipText("\u4e92\u76f8\u5173\u6ce8");
        Dimension dm = this.mutualLabel.getPreferredSize();
        int labelWidth = (int)dm.getWidth();
        int labelLocX = this.allWidth - this.panelWidth - labelWidth - 5;
        this.mutualLabel.setLocation(labelLocX, this.locY + 5);
        this.mutualLabel.setSize(dm);
        this.mutualLabel.setVisible(false);
        this.inner.add(this.mutualLabel);
        if (user.isFollowing() && user.isfollowMe()) {
            this.mutualLabel.setVisible(true);
        }
    }

    private void initBasicMsg(User user) {
        JTextPane textPanel = this.initTextPanel();
        textPanel.setFont(FONT);
        textPanel.setText(String.valueOf(String.valueOf("\u5173\u6ce8:" + user.getFriendsCount())) + "   " + String.valueOf("\u7c89\u4e1d:" + user.getFollowersCount()) + "   " + String.valueOf("\u5fae\u535a:" + user.getStatusesCount()));
        textPanel.setLocation(this.locX + this.headImgWidth, this.locY);
        Dimension dm = textPanel.getPreferredSize();
        textPanel.setSize(dm);
        this.inner.add(textPanel);
        this.locY = (int)((double)this.locY + dm.getHeight());
    }

    public boolean isMutualVisible() {
        return this.mutualLabel.isVisible();
    }

    public void setMutualVisible(boolean flag) {
        this.mutualLabel.setVisible(flag);
    }

    protected static enum UserType {
        MY_FOLLOWERS("\u7c89\u4e1d"),
        MY_FRIENDS("\u5173\u6ce8"),
        OTHER_USER_FOLLOWERS("\u53e6\u4e00\u4e2a\u7528\u6237\u7684\u7c89\u4e1d"),
        OTHER_USER_FRIENDS("\u53e6\u4e00\u4e2a\u7528\u6237\u6240\u5173\u6ce8\u7684");

        private String name;

        private UserType(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }
    }
}

