/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import com.wtools.binary.AccessTokenDao;
import com.wtools.binary.MainDialog;
import java.awt.Component;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import weibo4j.Account;
import weibo4j.Oauth;
import weibo4j.Users;
import weibo4j.Weibo;
import weibo4j.examples.oauth2.Log;
import weibo4j.http.AccessToken;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;

public class Oauth2Code {
    private static MainDialog mainDialog;
    private Oauth oauth = new Oauth();
    private String lastURL;
    private static User user;
    private JDialog dialog;

    public Oauth2Code() {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u6388\u6743\u7684\u754c\u9762...");
        this.dialog = new JDialog(){
            private static final long serialVersionUID = -4925844767877475984L;

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    Oauth2Code.this.dialog.dispose();
                    System.exit(0);
                }
            }
        };
        this.dialog.setTitle("\u6388\u6743");
        this.dialog.setResizable(false);
        this.dialog.setBounds(30, 30, 608, 522);
        this.dialog.add((Component)this.getWebBrowser(), "Center");
        this.dialog.setVisible(true);
        this.dialog.setDefaultCloseOperation(2);
    }

    public Oauth2Code(String accessToken) throws WeiboException {
        this.init(accessToken);
    }

    private JWebBrowser getWebBrowser() {
        JWebBrowser webBrowser = new JWebBrowser(new NSOption[0]);
        webBrowser.setBarsVisible(false);
        webBrowser.setButtonBarVisible(false);
        webBrowser.setDefaultPopupMenuRegistered(false);
        try {
            this.lastURL = this.oauth.authorize("code");
            webBrowser.navigate(this.lastURL);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        webBrowser.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void locationChanged(WebBrowserNavigationEvent arg0) {
                String site = arg0.getWebBrowser().getResourceLocation();
                if (site == null || Oauth2Code.this.lastURL.equals(site) || site.indexOf("access") == -1) {
                    return;
                }
                Oauth2Code.this.lastURL = site;
                Oauth2Code.this.dialog.dispose();
                String access = site.substring(site.lastIndexOf("access=") + 7);
                if (access == null) {
                    return;
                }
                AccessTokenDao.write(access);
                Log.logInfo("\u6388\u6743\u6210\u529f...");
                try {
                    Oauth2Code.this.init(access);
                }
                catch (WeiboException e) {
                    e.printStackTrace();
                }
            }
        });
        return webBrowser;
    }

    private void init(String accessToken) throws WeiboException {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u4e3b\u754c\u9762...");
        Weibo weibo = new Weibo();
        weibo.setToken(accessToken);
        Account ac = new Account();
        String uid = null;
        try {
            uid = ac.getUid().get("uid").toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (uid == null) {
            return;
        }
        Users um = new Users();
        user = um.showUserById(uid);
        mainDialog = new MainDialog(user);
    }

    private String getAccessTokenByCode(String code) {
        Log.logInfo("code:" + code);
        AccessToken accessToken = null;
        try {
            accessToken = this.oauth.getAccessTokenByCode(code);
        }
        catch (WeiboException e) {
            if (401 == e.getStatusCode()) {
                Log.logInfo("Unableto get the access token.");
            } else {
                e.printStackTrace();
            }
            return null;
        }
        return accessToken.getAccessToken();
    }

    public static MainDialog getMainDialog() {
        return mainDialog;
    }

    public static User getUser() {
        return user;
    }
}

