/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.MyDialog;
import com.wtools.binary.MyScrollPane;
import com.wtools.binary.Oauth2Code;
import com.wtools.binary.OneComment;
import com.wtools.binary.OneUser;
import com.wtools.binary.SendImage;
import com.wtools.binary.WeiboFrame;
import com.wtools.binary.WeiboPanel;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import weibo4j.Comments;
import weibo4j.Favorite;
import weibo4j.Friendships;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.Status;
import weibo4j.model.User;
import weibo4j.model.WeiboException;

public class MyLabel
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = -4476206131490069863L;
    private static final String fontName = "\u5fae\u8f6f\u96c5\u9ed1";
    public static final String REPOST = "\u8f6c\u53d1";
    public static final String COMMENT = "\u8bc4\u8bba";
    public static final String ORIGINAL_REPOST = "\u539f\u6587\u8f6c\u53d1";
    public static final String ORIGINAL_COMMENT = "\u539f\u6587\u8bc4\u8bba";
    public static final String FAVORITE = "\u6536\u85cf";
    public static final String UNFAVORITE = "\u53d6\u6d88\u6536\u85cf";
    public static final String DELETE = "\u5220\u9664";
    public static final String REPLY = "\u56de\u590d";
    public static final String REFRESH = "\u5237\u65b0 ";
    public static final String UPDATE_STATUS = "\u53d1\u5fae\u535a";
    public static final String FOLLOW = "+\u5173\u6ce8";
    public static final String UNFOLLOW = "\u53d6\u6d88\u5173\u6ce8";
    public static final String DIRECT_MESSAGES = "\u79c1\u4fe1";
    public static final String SEND_IMAGE = "\u53d1\u56fe";
    private int size = 14;
    private boolean isEntered;
    private Status status;
    private Comment comment;
    private OneComment.CommentType type;
    private User user;
    private String text;

    public MyLabel(String text) {
        super(text);
        this.text = text;
        this.init();
    }

    public MyLabel(String text, int size) {
        super(text);
        this.text = text;
        this.init();
    }

    public MyLabel(String text, Status status) {
        super(text);
        this.text = text;
        this.status = status;
        this.init();
    }

    public MyLabel(String text, Comment comment) {
        super(text);
        this.text = text;
        this.comment = comment;
        this.init();
    }

    public MyLabel(String text, Comment comment, OneComment.CommentType type) {
        super(text);
        this.text = text;
        this.comment = comment;
        this.type = type;
        this.init();
    }

    public MyLabel(String text, User user) {
        super(text);
        this.text = text;
        this.user = user;
        this.init();
    }

    private void init() {
        this.setFont(new Font(fontName, 0, this.size));
        this.setSize(this.getPreferredSize());
        this.addMouseListener(this);
    }

    @Override
    protected void paintBorder(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.isEntered) {
            g.drawLine(0, h - 1, w - 1, h - 1);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.text = text;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.isEntered = true;
        this.repaint();
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.isEntered = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        new Thread(){

            @Override
            public void run() {
                if (MyLabel.this.text.startsWith(MyLabel.REPOST) || MyLabel.this.text.startsWith(MyLabel.COMMENT) || MyLabel.this.text.startsWith(MyLabel.ORIGINAL_REPOST) || MyLabel.this.text.startsWith(MyLabel.ORIGINAL_COMMENT)) {
                    WeiboFrame.getInstance(MyLabel.this.status, MyLabel.this.text);
                } else if (MyLabel.this.text.equals(MyLabel.DELETE)) {
                    MyLabel.this.delete();
                } else if (MyLabel.this.text.equals(MyLabel.REFRESH)) {
                    MyLabel.this.refresh();
                } else if (MyLabel.this.text.equals(MyLabel.REPLY)) {
                    MyLabel.this.reply();
                } else if (MyLabel.this.text.equals(MyLabel.UPDATE_STATUS)) {
                    new MyDialog(MyLabel.UPDATE_STATUS);
                } else if (MyLabel.this.text.equals(MyLabel.FAVORITE)) {
                    MyLabel.this.createFavorite();
                } else if (MyLabel.this.text.equals(MyLabel.UNFAVORITE)) {
                    MyLabel.this.unFavorite();
                } else if (MyLabel.this.text.equals(MyLabel.FOLLOW)) {
                    MyLabel.this.follow();
                } else if (MyLabel.this.text.equals(MyLabel.UNFOLLOW)) {
                    MyLabel.this.unfollow();
                } else if (MyLabel.this.text.equals(MyLabel.SEND_IMAGE)) {
                    new SendImage();
                }
            }
        }.start();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isEntered = false;
        this.repaint();
    }

    private void delete() {
        String text = null;
        if (this.status != null) {
            text = "\u5fae\u535a";
        } else if (this.comment != null) {
            text = COMMENT;
        }
        int result = JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u6761" + text + "\uff1f", "\u5220\u9664\uff1f", 2);
        if (result == 0) {
            boolean isSuccessed = false;
            if (this.status != null) {
                isSuccessed = this.destroyStatus(this.status);
            } else if (this.comment != null) {
                isSuccessed = this.destroyComment(this.comment);
            }
            if (isSuccessed) {
                JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u6210\u529f\uff01");
            } else {
                JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
            }
        }
    }

    private boolean destroyStatus(Status status) {
        Timeline tl = new Timeline();
        Status result = null;
        try {
            result = tl.Destroy(status.getId());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        return result != null;
    }

    private boolean destroyComment(Comment comment) {
        Comments cm = new Comments();
        Comment result = null;
        try {
            result = cm.destroyComment(comment.getIdstr());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        return result != null;
    }

    private void refresh() {
        MyScrollPane jsp = (MyScrollPane)Oauth2Code.getMainDialog().getTabbedPane().getSelectedComponent();
        WeiboPanel weiboPanel = (WeiboPanel)jsp.getViewport().getView();
        if (weiboPanel != null) {
            weiboPanel.refresh();
        }
    }

    private void reply() {
        if (this.type.equals((Object)OneComment.CommentType.COMMENT_BY_ID)) {
            WeiboFrame weiboFrame = WeiboFrame.getInstance();
            JTextArea textArea = weiboFrame.getTextArea(REPLY);
            weiboFrame.setReplyComment(this.comment);
            String text = "\u56de\u590d@" + this.comment.getUser().getName() + ":";
            textArea.setText(text);
            textArea.setCaretPosition(text.length());
        } else if (this.type.equals((Object)OneComment.CommentType.MY_COMMENTS)) {
            new MyDialog("\u56de\u590d\u8bc4\u8bba", this.comment);
        }
    }

    private void createFavorite() {
        boolean isSuccessed = false;
        Favorite fv = new Favorite();
        try {
            isSuccessed = fv.createFavorites(this.status.getId()) != null;
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (isSuccessed) {
            JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u6210\u529f\uff01");
            this.setText(UNFAVORITE);
        } else {
            JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
        }
    }

    private void unFavorite() {
        int result = JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u8981\u53d6\u6d88\u8fd9\u6761\u6536\u85cf\uff1f", "\u5220\u9664\uff1f", 2);
        if (result == 0) {
            boolean isSuccessed = false;
            Favorite fv = new Favorite();
            try {
                isSuccessed = fv.destroyFavorites(this.status.getId()) != null;
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            if (isSuccessed) {
                JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u6210\u529f\uff01");
                this.setText(FAVORITE);
            } else {
                JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
            }
        }
    }

    private void follow() {
        Friendships fm = new Friendships();
        User fv = null;
        try {
            fv = fm.createFriendshipsById(this.user.getId());
        }
        catch (WeiboException e) {
            if (e.getErrorCode() == 20506) {
                JOptionPane.showConfirmDialog(null, "\u5df2\u7ecf\u5173\u6ce8\u6b64\u7528\u6237\u3002", "\u9519\u8bef", 0);
            }
            e.printStackTrace();
        }
        if (fv != null) {
            JOptionPane.showMessageDialog(null, "\u6210\u529f\u5173\u6ce8\uff01");
            this.setText(UNFOLLOW);
            this.paintBorder(this.getGraphics());
            if (this.user.isfollowMe()) {
                OneUser oneUser = (OneUser)this.getParent().getParent().getParent();
                oneUser.setMutualVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", "\u9519\u8bef", 0);
        }
    }

    private void unfollow() {
        int result = JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u8981\u53d6\u6d88\u5173\u6ce8" + this.user.getName() + "\uff1f", "\u53d6\u6d88\u5173\u6ce8\uff1f", 2);
        if (result != 0) {
            return;
        }
        Friendships fm = new Friendships();
        User fv = null;
        try {
            fv = fm.destroyFriendshipsDestroyById(this.user.getId());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (fv != null) {
            JOptionPane.showMessageDialog(null, "\u5df2\u53d6\u6d88\u5173\u6ce8\uff01");
            this.setText(FOLLOW);
            this.paintBorder(this.getGraphics());
            OneUser oneUser = (OneUser)this.getParent().getParent().getParent();
            if (oneUser.isMutualVisible()) {
                oneUser.setMutualVisible(false);
            }
        } else {
            JOptionPane.showConfirmDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", "\u9519\u8bef", 0);
        }
    }
}

