/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.OneStatus;
import com.wtools.binary.WeiboPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import weibo4j.Favorite;
import weibo4j.model.Favorites;
import weibo4j.model.FavoritesTag;
import weibo4j.model.Paging;
import weibo4j.model.WeiboException;

public class MyFavorites
extends WeiboPanel {
    private static final long serialVersionUID = -762146001014477033L;
    private static final String ALL_FAVORITES = "\u5168\u90e8\u6536\u85cf";
    private Favorite fv;
    private FavoritesTag favoritesTag;
    private List<FavoritesTag> favoritesTags;
    private JComboBox comboBox;

    public MyFavorites() {
        this.initComboBox();
        this.init();
    }

    @Override
    public void run() {
        this.setLoading(true);
        if (this.page == 1) {
            this.add((Component)this.comboBox, this.gbc);
            this.validate();
            ++this.gbc.gridy;
        }
        List<Favorites> favors = null;
        try {
            favors = this.favoritesTag == null || ALL_FAVORITES.equals(this.favoritesTag.getTag()) ? this.fv.getFavorites(new Paging(this.page)) : this.fv.getFavoritesByTags(this.favoritesTag.getId(), new Paging(this.page));
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        for (Favorites f : favors) {
            f.getStatus().setFavorited(true);
            OneStatus oneStatus = new OneStatus(f, OneStatus.StatusType.FAVORITE);
            this.add((Component)oneStatus, this.gbc);
            ++this.gbc.gridy;
            this.getParent().validate();
        }
        ++this.page;
        this.setLoading(false);
    }

    private void initComboBox() {
        try {
            if (this.fv == null) {
                this.fv = new Favorite();
            }
            this.favoritesTags = this.fv.getFavoritesTags();
            this.favoritesTags.add(0, new FavoritesTag(ALL_FAVORITES));
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        Vector<String> v = new Vector<String>();
        for (FavoritesTag tag : this.favoritesTags) {
            v.add(tag.getTag());
        }
        this.comboBox = new JComboBox(v);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MyFavorites.this.removeAll();
                    int index = MyFavorites.this.comboBox.getSelectedIndex();
                    MyFavorites.this.favoritesTag = (FavoritesTag)MyFavorites.this.favoritesTags.get(index);
                    MyFavorites.this.page = 1;
                    MyFavorites.this.gbc.gridy = 0;
                    MyFavorites.this.setLoading(true);
                    MyFavorites.this.addList();
                }
            }
        });
    }
}

