/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.Oauth2Code;
import com.wtools.binary.SendImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weibo4j.Comments;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.WeiboException;

public class MyDialog
extends JDialog {
    private static final long serialVersionUID = 4129242658816167905L;
    public static final String UPDATE_STATUS = "\u53d1\u5fae\u535a";
    public static final String REPLY_COMMENT = "\u56de\u590d\u8bc4\u8bba";
    private static final String SEND_IMAGE = "\u53d1\u56fe";
    private static final String ENSURE = "\u786e\u5b9a";
    private JTextArea textArea;
    private JLabel tip;
    private String type;
    private Comment replyComment;

    public MyDialog(String type, Comment comment) {
        this.setTitle(type);
        this.replyComment = comment;
        this.type = type;
        this.init();
    }

    public MyDialog(String type) {
        this.setTitle(type);
        this.type = type;
        this.init();
    }

    private void init() {
        this.setModalityType(JDialog.DEFAULT_MODALITY_TYPE);
        this.setLayout(new BorderLayout());
        this.setSize(500, 200);
        this.setLocationRelativeTo(Oauth2Code.getMainDialog());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.tip = new JLabel("(\u4f60\u8fd8\u53ef\u8f93\u5165140\u4e2a\u5b57\u3002)");
        this.initTextArea();
        this.add((Component)this.getScrollPane(), "Center");
        this.add((Component)this.getDownPanel(), "South");
        this.setVisible(true);
    }

    private void initTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                MyDialog.this.invoke();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MyDialog.this.invoke();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MyDialog.this.invoke();
            }
        });
        if (this.type.equals(REPLY_COMMENT)) {
            String text = "\u56de\u590d@" + this.replyComment.getUser().getName() + ":";
            this.textArea.setText(text);
            this.textArea.setCaretPosition(text.length());
        }
    }

    private JScrollPane getScrollPane() {
        JScrollPane jsp = new JScrollPane(this.textArea);
        jsp.setVerticalScrollBarPolicy(20);
        jsp.setHorizontalScrollBarPolicy(30);
        this.add((Component)jsp, "Center");
        return jsp;
    }

    private JPanel getDownPanel() {
        JPanel downPanel = new JPanel(new FlowLayout());
        this.tip.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        downPanel.add(this.tip);
        if (this.type.equals(UPDATE_STATUS)) {
            JButton sendPic = new JButton(SEND_IMAGE);
            sendPic.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SendImage sendImage = new SendImage();
                    MyDialog.this.dispose();
                    sendImage.toFront();
                }
            });
            downPanel.add(sendPic);
        }
        JButton submit = new JButton(ENSURE);
        submit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String content = MyDialog.this.textArea.getText();
                if (content.equals("")) {
                    JOptionPane.showMessageDialog(null, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", "\u9519\u8bef", 0);
                    return;
                }
                boolean isSuccess = false;
                if (MyDialog.this.type.equals(MyDialog.REPLY_COMMENT)) {
                    isSuccess = MyDialog.this.reply(content);
                } else if (MyDialog.this.type.equals(MyDialog.UPDATE_STATUS)) {
                    isSuccess = MyDialog.this.update(content);
                }
                if (isSuccess) {
                    JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u6210\u529f\uff01");
                } else {
                    JOptionPane.showMessageDialog(null, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", "\u9519\u8bef", 0);
                }
                MyDialog.this.dispose();
            }
        });
        downPanel.add(submit);
        return downPanel;
    }

    private void invoke() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int num = 140 - MyDialog.this.textArea.getText().length();
                MyDialog.this.tip.setText("(\u4f60\u8fd8\u53ef\u8f93\u5165" + num + "\u4e2a\u5b57\u3002)");
                MyDialog.this.tip.validate();
            }
        });
    }

    private boolean update(String content) {
        Timeline tl = new Timeline();
        try {
            return tl.UpdateStatus(content) != null;
        }
        catch (WeiboException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean reply(String content) {
        Comments cm = new Comments();
        Comment result = null;
        try {
            result = cm.replyComment(this.replyComment.getIdstr(), this.replyComment.getStatus().getId(), content);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        this.replyComment = null;
        return result != null;
    }
}

