/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.OneComment;
import com.wtools.binary.OneStatus;
import com.wtools.binary.WeiboPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import weibo4j.Comments;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.CommentWapper;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.WeiboException;

public class Mentions
extends WeiboPanel {
    private static final long serialVersionUID = -910451790745955417L;
    private static final Timeline tm = new Timeline();
    private static final Comments comments = new Comments();
    private static final String MENTION_STATUS = "@\u6211\u7684\u5fae\u535a";
    private static final String MEMTION_COMMENTS = "@\u6211\u7684\u8bc4\u8bba";
    private JComboBox comboBox;
    private String selectedItem = "@\u6211\u7684\u5fae\u535a";

    public Mentions() {
        this.initComboBox();
        this.init();
    }

    @Override
    public void run() {
        this.setLoading(true);
        if (this.page == 1) {
            this.add((Component)this.comboBox, this.gbc);
            this.validate();
            ++this.gbc.gridy;
        }
        if (this.selectedItem.equals(MENTION_STATUS)) {
            StatusWapper statusWapper = null;
            try {
                statusWapper = tm.getMentions(new Paging(this.page), 0, 0, 0);
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            for (Status s : statusWapper.getStatuses()) {
                if (s.getUser() == null) {
                    System.out.println(String.valueOf(s.getId()) + "Weibo\u83b7\u53d6\u4e0d\u5230\u7528\u6237\uff01\uff01\uff01");
                    continue;
                }
                OneStatus oneStatus = new OneStatus(s, OneStatus.StatusType.FRIEND_TIMELINE);
                this.add((Component)oneStatus, this.gbc);
                this.getParent().validate();
                ++this.gbc.gridy;
            }
        } else {
            CommentWapper commentWapper = null;
            try {
                commentWapper = comments.getCommentMentions(new Paging(this.page), 0, 0);
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            for (Comment c : commentWapper.getComments()) {
                if (c.getUser() == null) {
                    System.out.println("Weibo\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u540d\uff01\uff01\uff01");
                    continue;
                }
                OneComment oneComment = new OneComment(c, OneComment.CommentType.MY_COMMENTS);
                this.add((Component)oneComment, this.gbc);
                this.getParent().validate();
                ++this.gbc.gridy;
            }
        }
        ++this.page;
        this.setLoading(false);
    }

    private void initComboBox() {
        Vector<String> selectItem = new Vector<String>();
        selectItem.add(MENTION_STATUS);
        selectItem.add(MEMTION_COMMENTS);
        this.comboBox = new JComboBox(selectItem);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Mentions.this.removeAll();
                    Mentions.this.selectedItem = (String)Mentions.this.comboBox.getSelectedItem();
                    Mentions.this.page = 1;
                    Mentions.this.gbc.gridy = 0;
                    Mentions.this.setLoading(true);
                    Mentions.this.addList();
                }
            }
        });
    }

    protected static enum MentionsType {
        MENTION_STATUS("@\u6211\u7684\u8bc4\u8bba"),
        MEMTION_COMMENTS("@\u6211\u7684\u5fae\u535a");

        private String name;

        private MentionsType(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }
    }
}

