/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.FriendTimeline;
import com.wtools.binary.FriendsOrFollowers;
import com.wtools.binary.Mentions;
import com.wtools.binary.MyComment;
import com.wtools.binary.MyFavorites;
import com.wtools.binary.MyScrollPane;
import com.wtools.binary.Oauth2Code;
import com.wtools.binary.OneUser;
import com.wtools.binary.PersonalInform;
import com.wtools.binary.UserTimeline;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weibo4j.model.User;

public class MainDialog
extends JFrame {
    private static final long serialVersionUID = 3367550336433904925L;
    private static final String OPEN = "Open";
    private static final String EXIT = "Exit";
    private static final String ABOUT = "About";
    private static final String LOGOUT = "Logout";
    private static final boolean[] arrayOfTab;
    private JTabbedPane tabbedPane;
    private PersonalInform personal;

    static {
        boolean[] blArray = new boolean[7];
        blArray[0] = true;
        arrayOfTab = blArray;
    }

    public MainDialog(User user) {
        this.setTitle("\u5fae\u535a\u5c0f\u5de5\u5177(WTOOLS)");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.setDefaultCloseOperation(1);
        this.setLayout(null);
        this.setSize(520, 610);
        this.getContentPane().setBackground(Color.white);
        this.personal = new PersonalInform(user);
        this.personal.setBounds(0, 0, 485, 95);
        this.add(this.personal);
        this.initTabbedPanel();
        this.setVisible(true);
        this.initSystemTray();
    }

    private void initTabbedPanel() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("\u9996\u9875", null, new MyScrollPane(new FriendTimeline()), "\u9996\u9875");
        this.tabbedPane.addTab("\u8bc4\u8bba", null, new MyScrollPane(), "\u8bc4\u8bba");
        this.tabbedPane.addTab("@\u6211", null, new MyScrollPane(), "@\u6211");
        this.tabbedPane.addTab("\u6536\u85cf", null, new MyScrollPane(), "\u6536\u85cf");
        this.tabbedPane.addTab("\u5173\u6ce8", null, new MyScrollPane(), "\u5173\u6ce8");
        this.tabbedPane.addTab("\u7c89\u4e1d", null, new MyScrollPane(), "\u7c89\u4e1d");
        this.tabbedPane.addTab("\u5fae\u535a", null, new MyScrollPane(), "\u5fae\u535a");
        this.tabbedPane.setBounds(0, 96, 485, 475);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = MainDialog.this.tabbedPane.getSelectedIndex();
                if (arrayOfTab[index]) {
                    return;
                }
                FirstClick thread = new FirstClick((MyScrollPane)MainDialog.this.tabbedPane.getSelectedComponent(), index);
                thread.start();
            }
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void initSystemTray() {
        if (!SystemTray.isSupported()) {
            return;
        }
        try {
            String title = "\u65b0\u6d6a\u5fae\u535aJAVA\u5ba2\u6237\u7aef \n\u7275\u7740\u8717\u725b\u53bb\u6563\u6b65";
            SystemTray sysTray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage("images/logo.png");
            TrayIcon trayicon = new TrayIcon(image, title, this.createMenu());
            trayicon.setImageAutoSize(true);
            trayicon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainDialog.this.setVisible(true);
                    MainDialog.this.toFront();
                }
            });
            sysTray.add(trayicon);
            trayicon.displayMessage("\u65b0\u6d6a\u5fae\u535aJAVA\u5ba2\u6237\u7aef", "\u7275\u7740\u8717\u725b\u53bb\u6563\u6b65", TrayIcon.MessageType.INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PopupMenu createMenu() {
        PopupMenu menu = new PopupMenu();
        MenuItem openItem = new MenuItem(OPEN);
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainDialog.this.isVisible()) {
                    MainDialog.this.setVisible(true);
                    MainDialog.this.toFront();
                } else {
                    MainDialog.this.toFront();
                }
            }
        });
        MenuItem logoffItem = new MenuItem(LOGOUT);
        logoffItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "\u8fd8\u6ca1\u6dfb\u52a0\u6ce8\u9500\u7684\u529f\u80fd\uff01");
            }
        });
        MenuItem aboutItem = new MenuItem(ABOUT);
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "\u65b0\u6d6a\u5fae\u535a @\u8717\u725b\u90fd\u77e5\u9053\n\u535a\u5ba2\uff1abinary.duapp.com/n2012/09/09 15:02 ");
            }
        });
        MenuItem exitItem = new MenuItem(EXIT);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.dispose();
                System.exit(0);
            }
        });
        menu.add(openItem);
        menu.addSeparator();
        menu.add(logoffItem);
        menu.addSeparator();
        menu.add(aboutItem);
        menu.addSeparator();
        menu.add(exitItem);
        return menu;
    }

    public void setLoading(boolean flag) {
        this.personal.setLoading(flag);
    }

    private class FirstClick
    extends Thread {
        private static final int MYCOMMENT = 1;
        private static final int METIONS = 2;
        private static final int FAVORITES = 3;
        private static final int FRIENDS = 4;
        private static final int FOLLOWERS = 5;
        private static final int MYSTATUS = 6;
        private MyScrollPane msp;
        private int index;

        public FirstClick(MyScrollPane msp, int index) {
            this.msp = msp;
            this.index = index;
            arrayOfTab[index] = true;
        }

        @Override
        public void run() {
            if (this.index == 1) {
                this.msp.setViewportView(new MyComment());
            } else if (this.index == 2) {
                this.msp.setViewportView(new Mentions());
            } else if (this.index == 3) {
                this.msp.setViewportView(new MyFavorites());
            } else if (this.index == 4) {
                this.msp.setViewportView(new FriendsOrFollowers(Oauth2Code.getUser(), OneUser.UserType.MY_FRIENDS));
            } else if (this.index == 5) {
                this.msp.setViewportView(new FriendsOrFollowers(Oauth2Code.getUser(), OneUser.UserType.MY_FOLLOWERS));
            } else if (this.index == 6) {
                this.msp.setViewportView(new UserTimeline(Oauth2Code.getUser()));
            }
        }
    }
}

