/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.SendImage;
import com.wtools.util.FileOperation;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageDropTargetListener
extends DropTargetAdapter {
    private List<File> fileList;
    private SendImage sendImageFrame;

    public ImageDropTargetListener(SendImage sendImageFrame) {
        this.sendImageFrame = sendImageFrame;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(3);
        Transferable transferable = event.getTransferable();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            DataFlavor d = flavors[i];
            try {
                if (d.equals(DataFlavor.javaFileListFlavor)) {
                    this.fileList = (List)transferable.getTransferData(d);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            event.dropComplete(true);
            ++i;
        }
        if (this.fileList == null || this.fileList.size() == 0) {
            System.out.println("\u7ea0\u7ed3\uff1a\u62d6\u5165\u8f83\u591a\u65f6\u5374\u4e3a\u7a7a\uff01");
            return;
        }
        List<File> imgFiles = this.getImageFiles(this.fileList);
        if (imgFiles.size() == 0) {
            return;
        }
        File file = this.getImageFiles(this.fileList).get(0);
        this.sendImageFrame.repaintImgPanel(file.getAbsolutePath());
    }

    private List<File> getImageFiles(List<File> fileList) {
        ArrayList<File> imgFileList = new ArrayList<File>();
        int i = 0;
        while (i < fileList.size()) {
            String filename;
            File file = fileList.get(i);
            if (!file.isDirectory() && FileOperation.isImageFile(filename = file.getName())) {
                imgFileList.add(file);
            }
            ++i;
        }
        return imgFileList;
    }
}

