/*
 * Decompiled with CFR 0.152.
 */
package com.wtools.binary;

import com.wtools.binary.Oauth2Code;
import com.wtools.binary.OneUser;
import com.wtools.binary.WeiboPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import weibo4j.Friendships;
import weibo4j.examples.oauth2.Log;
import weibo4j.model.Paging;
import weibo4j.model.User;
import weibo4j.model.UserWapper;
import weibo4j.model.WeiboException;

public class FriendsOrFollowers
extends WeiboPanel {
    private static final long serialVersionUID = -3227331869639538542L;
    private static final String ALL_FRIENDS = "\u5168\u90e8\u5173\u6ce8";
    private static final String BILATERAL = "\u4e92\u76f8\u5173\u6ce8";
    private static final String IN_COMMENT = "\u5171\u540c\u5173\u6ce8";
    private Friendships fm = new Friendships();
    private User user;
    private OneUser.UserType type;
    private JComboBox comboBox;
    private String selectedItem;

    public FriendsOrFollowers(User user, OneUser.UserType type) {
        this.user = user;
        this.type = type;
        this.selectedItem = ALL_FRIENDS;
        Vector<String> selectItem = new Vector<String>();
        selectItem.add(ALL_FRIENDS);
        if (user.equals(Oauth2Code.getUser())) {
            selectItem.add(BILATERAL);
        } else {
            selectItem.add(IN_COMMENT);
        }
        if (type.equals((Object)OneUser.UserType.MY_FRIENDS) || type.equals((Object)OneUser.UserType.OTHER_USER_FRIENDS)) {
            this.comboBox = new JComboBox(selectItem);
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        FriendsOrFollowers.this.removeAll();
                        FriendsOrFollowers.this.selectedItem = (String)FriendsOrFollowers.this.comboBox.getSelectedItem();
                        FriendsOrFollowers.this.page = 1;
                        FriendsOrFollowers.this.gbc.gridy = 0;
                        FriendsOrFollowers.this.setLoading(true);
                        FriendsOrFollowers.this.addList();
                    }
                }
            });
        }
        this.init();
    }

    @Override
    public void run() {
        this.setLoading(true);
        UserWapper userWapper = null;
        try {
            if (this.type.equals((Object)OneUser.UserType.MY_FRIENDS)) {
                if (this.page == 1) {
                    this.add((Component)this.comboBox, this.gbc);
                    ++this.gbc.gridy;
                    this.getParent().validate();
                }
                if (this.selectedItem.equals(ALL_FRIENDS)) {
                    userWapper = this.fm.getFriendsByID(this.user.getId(), new Paging(this.page));
                } else if (this.selectedItem.equals(BILATERAL)) {
                    userWapper = this.fm.getFriendsBilateral(this.user.getId(), 0, new Paging(this.page));
                }
            } else if (this.type.equals((Object)OneUser.UserType.MY_FOLLOWERS)) {
                userWapper = this.fm.getFollowersById(this.user.getId(), new Paging(this.page));
            } else if (this.type.equals((Object)OneUser.UserType.OTHER_USER_FRIENDS)) {
                if (this.page == 1) {
                    this.add((Component)this.comboBox, this.gbc);
                    ++this.gbc.gridy;
                    this.getParent().validate();
                }
                if (this.selectedItem.equals(ALL_FRIENDS)) {
                    userWapper = this.fm.getFriendsByID(this.user.getId(), new Paging(this.page));
                } else if (this.selectedItem.equals(IN_COMMENT)) {
                    userWapper = this.fm.getFriendsInCommon(this.user.getId(), Oauth2Code.getUser().getId(), new Paging(this.page));
                }
            } else if (this.type.equals((Object)OneUser.UserType.OTHER_USER_FOLLOWERS)) {
                userWapper = this.fm.getFollowersById(this.user.getId(), new Paging(this.page));
            }
        }
        catch (WeiboException e1) {
            e1.printStackTrace();
        }
        for (User u : userWapper.getUsers()) {
            if (this.selectedItem.equals(BILATERAL)) {
                u.setFollowing(true);
                u.setFollowMe(true);
            } else if (this.selectedItem.equals(IN_COMMENT)) {
                u.setFollowing(true);
            }
            OneUser oneUser = null;
            try {
                oneUser = new OneUser(u);
            }
            catch (ClassCastException e) {
                Log.logInfo("ClassCastException FriendsOrFollowers 111");
            }
            if (oneUser == null) continue;
            this.add((Component)oneUser, this.gbc);
            ++this.gbc.gridy;
            this.getParent().validate();
        }
        ++this.page;
        this.setLoading(false);
    }
}

