/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.common;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static BufferedImage zoomInImage(BufferedImage originalImage, Integer times) {
        int width = originalImage.getWidth() * times;
        int height = originalImage.getHeight() * times;
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return newImage;
    }

    public static boolean zoomInImage(String srcPath, String newPath, Integer times) {
        BufferedImage bufferedImage = null;
        try {
            File of = new File(srcPath);
            if (of.canRead()) {
                bufferedImage = ImageIO.read(of);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (bufferedImage != null) {
            bufferedImage = ImageUtils.zoomInImage(bufferedImage, times);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "JPG", new File(newPath));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static BufferedImage zoomOutImage(BufferedImage originalImage, Integer times) {
        int width = originalImage.getWidth() / times;
        int height = originalImage.getHeight() / times;
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return newImage;
    }

    public static boolean zoomOutImage(String srcPath, String newPath, Integer times) {
        BufferedImage bufferedImage = null;
        try {
            File of = new File(srcPath);
            if (of.canRead()) {
                bufferedImage = ImageIO.read(of);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (bufferedImage != null) {
            bufferedImage = ImageUtils.zoomOutImage(bufferedImage, times);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "JPG", new File(newPath));
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        boolean testOut;
        boolean testIn = ImageUtils.zoomInImage("E:/11.jpg", "E:\\in.jpg", 4);
        if (testIn) {
            System.out.println("in ok");
        }
        if (testOut = ImageUtils.zoomOutImage("E:/11.jpg", "E:\\out.jpg", 4)) {
            System.out.println("out ok");
        }
    }
}

