/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import weibo4j.model.Status;

public class GetHtml {
    public String getOneHtml(String htmlurl) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            String temp;
            URL url = new URL(htmlurl);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            while ((temp = in.readLine()) != null) {
                sb.append(temp);
            }
            in.close();
        }
        catch (MalformedURLException me) {
            System.out.println("\u4f60\u8f93\u5165\u7684URL\u683c\u5f0f\u6709\u95ee\u9898\uff01\u8bf7\u4ed4\u7ec6\u8f93\u5165");
            me.getMessage();
            throw me;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return sb.toString();
    }

    public String getTitle(String s) {
        String title = "";
        ArrayList<String> list = new ArrayList<String>();
        String regex = "<title>.*?</title>";
        Pattern pa = Pattern.compile(regex, 128);
        Matcher ma = pa.matcher(s);
        while (ma.find()) {
            list.add(ma.group());
        }
        int i = 0;
        while (i < list.size()) {
            title = String.valueOf(title) + (String)list.get(i);
            ++i;
        }
        return this.outTag(title);
    }

    public List<String> getLink(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String regex = "<a[^>]*href=(\"([^\"]*)\"|'([^']*)'|([^\\s>]*))[^>]*>(.*?)</a>";
        Pattern pa = Pattern.compile(regex, 32);
        Matcher ma = pa.matcher(s);
        while (ma.find()) {
            list.add(ma.group());
        }
        return list;
    }

    public List<String> getScript(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String regex = "<SCRIPT.*?</SCRIPT>";
        Pattern pa = Pattern.compile(regex, 32);
        Matcher ma = pa.matcher(s);
        while (ma.find()) {
            list.add(ma.group());
        }
        return list;
    }

    public List<String> getNews(String s) {
        String regex = "<a.*?</a>";
        Pattern pa = Pattern.compile(regex, 32);
        Matcher ma = pa.matcher(s);
        ArrayList<String> list = new ArrayList<String>();
        while (ma.find()) {
            list.add(ma.group());
        }
        return list;
    }

    public List<String> getCSS(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String regex = "<style.*?</style>";
        Pattern pa = Pattern.compile(regex, 32);
        Matcher ma = pa.matcher(s);
        while (ma.find()) {
            list.add(ma.group());
        }
        return list;
    }

    public String outTag(String s) {
        return s.replaceAll("<.*?>", "");
    }

    public HashMap<String, String> getFromYahoo(String s) {
        HashMap<String, String> hm = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        String html = "";
        System.out.println("\n------------------\u5f00\u59cb\u8bfb\u53d6\u7f51\u9875(" + s + ")--------------------");
        try {
            html = this.getOneHtml(s);
        }
        catch (Exception e) {
            e.getMessage();
        }
        System.out.println("------------------\u8bfb\u53d6\u7f51\u9875(" + s + ")\u7ed3\u675f--------------------\n");
        System.out.println("------------------\u5206\u6790(" + s + ")\u7ed3\u679c\u5982\u4e0b--------------------\n");
        String title = this.outTag(this.getTitle(html));
        title = title.replaceAll("_\u96c5\u864e\u77e5\u8bc6\u5802", "");
        Pattern pa = Pattern.compile("<div class=\"original\">(.*?)</p></div>", 32);
        Matcher ma = pa.matcher(html);
        while (ma.find()) {
            sb.append(ma.group());
        }
        String temp = sb.toString();
        temp = temp.replaceAll("(<br>)+?", "\n");
        temp = temp.replaceAll("<p><em>.*?</em></p>", "");
        hm.put("title", title);
        hm.put("original", this.outTag(temp));
        return hm;
    }

    public List<String> getMid() throws IOException {
        String html = this.getOneHtml("http://s.weibo.com/weibo/\u4e2d\u6587");
        ArrayList<String> mids = new ArrayList<String>();
        String regex = "feed_list_item\" mid=\"(.*?)\">";
        Pattern pa = Pattern.compile(regex, 32);
        Matcher ma = pa.matcher(html);
        while (ma.find()) {
            mids.add(ma.group().substring(21, 37));
        }
        return mids;
    }

    public List<Status> getHotStatus() throws IOException {
        ArrayList<Status> statuss = new ArrayList<Status>();
        Document doc = Jsoup.connect("http://hot.weibo.com").get();
        Elements mids = doc.select("div[action-type=feed_list_item]");
        for (Element element : mids) {
            Status status = new Status();
            status.setId(element.attr("mid"));
            status.setText(element.select(".WB_text").text());
            statuss.add(status);
        }
        return statuss;
    }

    public List<Status> getStatusByKey(String key) throws IOException {
        ArrayList<Status> statuss = new ArrayList<Status>();
        Document doc = Jsoup.connect("http://s.weibo.com/weibo/" + key).get();
        return statuss;
    }
}

