/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.autoreply;

import com.mrhso.autoreply.AutoFollowFrame;
import com.mrhso.common.SuspendThread;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import weibo4j.Friendships;
import weibo4j.Timeline;
import weibo4j.model.Status;
import weibo4j.model.User;
import weibo4j.model.WeiboException;

public class AutoFollowLogic
extends SuspendThread {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private AutoFollowFrame autoFollowFrame;
    private boolean run = false;

    public AutoFollowLogic(AutoFollowFrame autoFollowFrame) {
        this.autoFollowFrame = autoFollowFrame;
    }

    @Override
    protected void runPersonelLogic() {
        System.out.println("thread is running......");
        this.follow();
    }

    public void init() {
        this.start();
        this.setSuspend(false);
    }

    private void follow() {
        Status status = this.getPublicTimeLine();
        long time = Integer.valueOf(this.autoFollowFrame.getTime().getText()) * 1000;
        User user = null;
        if (status != null) {
            Friendships friendships = new Friendships();
            try {
                user = friendships.createFriendshipsById(status.getUser().getId());
                this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " \u5173\u6ce8  " + user.getName() + " \t\t\u6210\u529f\u3002\n");
                this.autoFollowFrame.getOut().setCaretPosition(this.autoFollowFrame.getOut().getText().length());
            }
            catch (WeiboException e) {
                System.out.println(String.valueOf(this.formatter.format(new Date())) + " [error] code:" + e.getErrorCode() + " desc:" + e.getError() + " detail:" + e.getMessage() + "\n");
                switch (e.getErrorCode()) {
                    case 20031: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " \u5173\u6ce8\u9891\u7387\u8fc7\u5feb\u4e86,\u7a0b\u5e8f\u4f1a\u81ea\u52a8\u505c\u6b62\uff0c\u8fc7\u4f1a\u518d\u5f00\u59cb\u5c31OK\u4e86,\u53ef\u4ee5\u9002\u5f53\u8c03\u6574\u5173\u6ce8\u95f4\u9694\u3002" + "\n");
                        this.autoFollowFrame.setStart();
                        break;
                    }
                    case 20506: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " \u5df2\u7ecf\u5173\u6ce8\u8fc7\u8fd9\u4e2a\u4eba\u4e86~~" + "\n");
                        break;
                    }
                    case 10024: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " \u7528\u6237\u8bf7\u6c42\u7279\u6b8a\u63a5\u53e3, \u9891\u6b21\u8d85\u8fc7\u4e0a\u9650\uff0860/\u5c0f\u65f6\uff09\uff0c\u7a0b\u5e8f\u4f1a\u81ea\u52a8\u505c\u6b62\u3002" + "\n");
                        this.autoFollowFrame.setStart();
                        break;
                    }
                    case 20521: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " Hi\uff0c\u8d85\u4eba\u4f60\u4eca\u5929\u5173\u6ce8\u7684\u4eba\u6570\u5df2\u7ecf\u591f\u591a\u4e86~~\u660e\u5929\u7ee7\u7eed\u5427\u3002" + "\n");
                        this.autoFollowFrame.setStart();
                        break;
                    }
                    case 20513: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " \u4f60\u7684\u5173\u6ce8\u4eba\u6570\u5df2\u8fbe\u4e0a\u9650" + "\n");
                        this.autoFollowFrame.setStart();
                        break;
                    }
                    default: {
                        this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " [error] code:" + e.getErrorCode() + " desc:" + e.getError() + " detail:" + e.getMessage() + "\n");
                    }
                }
            }
            try {
                AutoFollowLogic.sleep(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Status getPublicTimeLine() {
        Timeline timeline = new Timeline();
        List<Status> list = null;
        try {
            list = timeline.getPublicTimeline(2, 0).getStatuses();
        }
        catch (WeiboException e) {
            this.autoFollowFrame.getOut().append(String.valueOf(this.formatter.format(new Date())) + " [error] code:" + e.getErrorCode() + " desc:" + e.getError() + " detail:" + e.getMessage() + "\n");
            return null;
        }
        return list.get(0);
    }

    public AutoFollowFrame getAutoFollowFrame() {
        return this.autoFollowFrame;
    }

    public void setAutoFollowFrame(AutoFollowFrame autoFollowFrame) {
        this.autoFollowFrame = autoFollowFrame;
    }

    public boolean isRun() {
        return this.run;
    }

    public void setRun(boolean run) {
        this.run = run;
    }
}

