/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.analysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart3DPanel {
    private DefaultPieDataset dfp;

    public JPanel getPieChart3DPanel(double man, double woman, double no, String title) {
        this.setPieDateSet(man, woman, no);
        return this.createPieChart3D(title);
    }

    public JPanel getPieChart3DPanel(Map<String, Integer> locationMap, String title) {
        this.setPieDateSet(locationMap);
        return this.createPieChart3D(title);
    }

    public void setPieDateSet(double man, double woman, double no) {
        this.dfp = new DefaultPieDataset();
        this.dfp.setValue((Comparable)((Object)"\u7537\u7c89\u4e1d"), man);
        this.dfp.setValue((Comparable)((Object)"\u5973\u7c89\u4e1d"), woman);
        this.dfp.setValue((Comparable)((Object)"\u672a\u77e5\u7c89\u4e1d"), no);
    }

    public void setPieDateSet(Map<String, Integer> map) {
        this.dfp = new DefaultPieDataset();
        for (String s : map.keySet()) {
            this.dfp.setValue((Comparable)((Object)s), (Number)map.get(s));
        }
    }

    public JPanel createPieChart3D(String title) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)title, (PieDataset)this.dfp, (boolean)true, (boolean)true, (boolean)true);
        ChartPanel panel = new ChartPanel(chart);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(1.0f));
        plot.setForegroundAlpha(0.65f);
        plot.setCircular(false);
        plot.setStartAngle(90.0);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        plot.setExplodePercent((Comparable)((Object)"One"), 0.1);
        plot.setLabelFont(new Font("\u5b8b\u4f53", 2, 16));
        plot.setLabelBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)SystemColor.activeCaption);
        chart.getLegend().setItemFont(new Font("\u5b8b\u4f53", 0, 24));
        Font font = new Font("\u9ed1\u4f53", 1, 50);
        TextTitle textTitle = new TextTitle(title);
        textTitle.setFont(font);
        chart.setTitle(textTitle);
        try {
            BufferedImage image = ImageIO.read(new File("images/loading.jpg"));
            plot.setBackgroundImage((Image)image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return panel;
    }
}

