/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.analysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart3D {
    private DefaultPieDataset dfp;

    public PieChart3D(double man, double woman, double no, String title) {
        this.setPieDateSet(man, woman, no);
        this.showPieChart3D(title);
    }

    public PieChart3D(Map<String, Integer> locationMap, String title) {
        this.setPieDateSet(locationMap);
        this.showPieChart3D(title);
    }

    public void showPieChart3D(String title) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)title, (PieDataset)this.dfp, (boolean)true, (boolean)true, (boolean)true);
        ChartFrame frame = new ChartFrame(title, chart, true);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setBaseSectionOutlineStroke((Stroke)new BasicStroke(1.0f));
        plot.setForegroundAlpha(0.65f);
        plot.setCircular(false);
        plot.setStartAngle(90.0);
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        plot.setExplodePercent((Comparable)((Object)"One"), 0.1);
        plot.setLabelFont(new Font("\u5b8b\u4f53", 2, 16));
        plot.setLabelBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)SystemColor.activeCaption);
        chart.getLegend().setItemFont(new Font("\u5b8b\u4f53", 0, 24));
        Font font = new Font("\u9ed1\u4f53", 1, 50);
        TextTitle textTitle = new TextTitle(title);
        textTitle.setFont(font);
        chart.setTitle(textTitle);
        frame.setBounds(100, 100, 850, 597);
        frame.setVisible(true);
    }

    public void setPieDateSet(double man, double woman, double no) {
        this.dfp = new DefaultPieDataset();
        this.dfp.setValue((Comparable)((Object)"\u7537\u7c89\u4e1d"), man);
        this.dfp.setValue((Comparable)((Object)"\u5973\u7c89\u4e1d"), woman);
        this.dfp.setValue((Comparable)((Object)"\u672a\u77e5\u6027\u522b"), no);
    }

    public void setPieDateSet(Map<String, Integer> map) {
        this.dfp = new DefaultPieDataset();
        for (String s : map.keySet()) {
            this.dfp.setValue((Comparable)((Object)s), (Number)map.get(s));
        }
    }

    public static void main(String[] args) {
        new PieChart3D(25.0, 25.0, 50.0, "sfsdkfjksjfkslf,123\u6d4b\u8bd5\u6807\u9898");
    }
}

