/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.analysis;

import com.mrhso.analysis.AnalysisFrame;
import com.mrhso.analysis.AnalysisType;
import com.mrhso.analysis.PieChart3D;
import com.mrhso.analysis.PieChart3DPanel;
import com.mrhso.main.Main;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import weibo4j.Friendships;
import weibo4j.Users;
import weibo4j.model.User;
import weibo4j.model.UserWapper;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class AnalysisLogic
extends Thread {
    private AnalysisFrame analysisFrame = null;
    private String nickName = null;
    private String numSelect = null;

    public AnalysisLogic(AnalysisType type) {
        this.calcFans(type, Main.getUser());
    }

    public AnalysisLogic(AnalysisFrame jFrame, String nickName, String numSelect) {
        this.analysisFrame = jFrame;
        this.nickName = nickName;
        this.numSelect = numSelect;
    }

    @Override
    public void run() {
        super.run();
        this.analysisFrame.getLoadPanel().setVisible(true);
        int num = Integer.valueOf(this.numSelect);
        JPanel jPanel = this.calcFans(num /= 100);
        if (jPanel == null) {
            this.analysisFrame.userNotExist();
            jPanel = new JPanel();
        }
        jPanel.setBounds(0, 0, 841, 480);
        this.analysisFrame.getChartPanel().removeAll();
        this.analysisFrame.getChartPanel().add(jPanel);
        this.analysisFrame.getLoadPanel().setVisible(false);
    }

    public User getUserByName(String nickName) {
        Users users = new Users();
        User user = null;
        try {
            user = users.showUserByScreenName(nickName);
        }
        catch (WeiboException e) {
            System.out.println("error:" + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("error:" + e.getMessage());
        }
        return user;
    }

    private JPanel calcFans(int times) {
        JPanel jPanel = null;
        User user = this.getUserByName(this.nickName);
        if (user == null) {
            return null;
        }
        String uid = user.getId();
        String name = user.getName();
        Friendships friendships = new Friendships();
        ArrayList<User> list = new ArrayList<User>();
        long cursor = 1L;
        try {
            while (times-- > 0) {
                UserWapper userWapper = friendships.getFollowersById(uid, 100, (int)cursor);
                cursor = userWapper.getNextCursor();
                if (userWapper.getUsers() != null && userWapper.getUsers().size() > 0 && userWapper.getNextCursor() != 0L) {
                    list.addAll(userWapper.getUsers());
                    continue;
                }
                list.addAll(userWapper.getUsers());
                break;
            }
        }
        catch (WeiboException e) {
            System.out.println(e.getMessage());
        }
        switch (this.analysisFrame.getAnalysisType()) {
            case sex: {
                jPanel = this.getGenderPanel(list, name);
                break;
            }
            case location: {
                jPanel = this.getLocationPanel(list, name);
                break;
            }
            case registerYear: {
                jPanel = this.getCreateTimePanel(list, name);
                break;
            }
            case userRank: {
                jPanel = this.getRankPanel(list, name);
                break;
            }
        }
        return jPanel;
    }

    private JPanel getGenderPanel(List<User> list, String name) {
        int m = 0;
        int f = 0;
        int n = 0;
        for (User user : list) {
            String sex = user.getGender();
            if ("m".equals(sex)) {
                ++m;
                continue;
            }
            if ("f".equals(sex)) {
                ++f;
                continue;
            }
            ++n;
        }
        return new PieChart3DPanel().getPieChart3DPanel(m, f, n, String.valueOf(name) + " \u7c89\u4e1d\u6027\u522b\u5206\u5e03\u60c5\u51b5");
    }

    private JPanel getLocationPanel(List<User> users, String name) {
        HashMap<String, Integer> locationMap = new HashMap<String, Integer>();
        boolean flag = false;
        for (User user : users) {
            String provice = String.valueOf(user.getProvince());
            provice = provice.length() > 2 ? Main.getLocation().get("001" + provice) : Main.getLocation().get("0010" + provice);
            if (provice == null) continue;
            for (Object o : locationMap.keySet()) {
                if (!provice.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)locationMap.get(provice) + 1;
                locationMap.put(provice, value);
                flag = false;
                continue;
            }
            locationMap.put(provice, 1);
        }
        return new PieChart3DPanel().getPieChart3DPanel(locationMap, String.valueOf(name) + " \u7c89\u4e1d\u5730\u57df\u5206\u5e03\u60c5\u51b5");
    }

    private JPanel getCreateTimePanel(List<User> users, String name) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Calendar calendar = Calendar.getInstance();
        boolean flag = false;
        for (User user : users) {
            calendar.setTime(user.getCreatedAt());
            String year = String.valueOf(calendar.get(1));
            for (Object o : map.keySet()) {
                if (!year.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)map.get(year) + 1;
                map.put(year, value);
                flag = false;
                continue;
            }
            map.put(year, 1);
        }
        return new PieChart3DPanel().getPieChart3DPanel(map, String.valueOf(name) + " \u7c89\u4e1d\u6ce8\u518c\u65f6\u95f4\u5206\u5e03");
    }

    public JPanel getRankPanel(List<User> users, String name) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String rank = "";
        boolean flag = false;
        Users u = new Users();
        for (User user : users) {
            try {
                JSONObject jsonObject = u.getUserRank(user.getId());
                rank = "rank" + jsonObject.getString("rank");
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (Object o : map.keySet()) {
                if (!rank.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)map.get(rank) + 1;
                map.put(rank, value);
                flag = false;
                continue;
            }
            map.put(rank, 1);
        }
        return new PieChart3DPanel().getPieChart3DPanel(map, String.valueOf(name) + " \u7c89\u4e1d\u7ea7\u522b\u5206\u5e03");
    }

    private void calcFans(AnalysisType type, User user) {
        String uid = user.getId();
        String name = user.getName();
        Friendships friendships = new Friendships();
        ArrayList<User> list = new ArrayList<User>();
        long cursor = 1L;
        int times = 1;
        try {
            while (times-- > 0) {
                System.out.println("times=" + times);
                UserWapper userWapper = friendships.getFollowersById(uid, 200, (int)cursor);
                cursor = userWapper.getNextCursor();
                if (userWapper.getUsers() != null && userWapper.getUsers().size() > 0 && userWapper.getNextCursor() != 0L) {
                    list.addAll(userWapper.getUsers());
                    continue;
                }
                list.addAll(userWapper.getUsers());
                break;
            }
        }
        catch (WeiboException e) {
            System.out.println(e.getMessage());
        }
        switch (type) {
            case sex: {
                this.getGender(list, name);
                break;
            }
            case location: {
                this.getLocation(list, name);
                break;
            }
            case registerYear: {
                this.getCreateTime(list, name);
                break;
            }
            case userRank: {
                this.getRank(list, name);
                break;
            }
        }
    }

    private void getGender(List<User> list, String name) {
        int m = 0;
        int f = 0;
        int n = 0;
        for (User user : list) {
            String sex = user.getGender();
            if ("m".equals(sex)) {
                ++m;
                continue;
            }
            if ("f".equals(sex)) {
                ++f;
                continue;
            }
            ++n;
        }
        new PieChart3D(m, f, n, String.valueOf(name) + " \u7c89\u4e1d\u6027\u522b\u5206\u5e03\u60c5\u51b5");
    }

    private void getLocation(List<User> users, String name) {
        HashMap<String, Integer> locationMap = new HashMap<String, Integer>();
        boolean flag = false;
        for (User user : users) {
            String provice = String.valueOf(user.getProvince());
            for (Object o : locationMap.keySet()) {
                if (!provice.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)locationMap.get(provice) + 1;
                locationMap.put(provice, value);
                flag = false;
                continue;
            }
            locationMap.put(provice, 1);
        }
        new PieChart3D(locationMap, String.valueOf(name) + " \u7c89\u4e1d\u5730\u57df\u5206\u5e03\u60c5\u51b5");
    }

    private void getCreateTime(List<User> users, String name) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Calendar calendar = Calendar.getInstance();
        boolean flag = false;
        for (User user : users) {
            calendar.setTime(user.getCreatedAt());
            String year = String.valueOf(calendar.get(1));
            for (Object o : map.keySet()) {
                if (!year.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)map.get(year) + 1;
                map.put(year, value);
                flag = false;
                continue;
            }
            map.put(year, 1);
        }
        new PieChart3D(map, String.valueOf(name) + " \u7c89\u4e1d\u6ce8\u518c\u65f6\u95f4\u5206\u5e03");
    }

    public void getRank(List<User> users, String name) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String rank = "";
        boolean flag = false;
        Users u = new Users();
        for (User user : users) {
            try {
                JSONObject jsonObject = u.getUserRank(user.getId());
                rank = "\u7ea7\u522b " + jsonObject.getString("rank");
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            for (Object o : map.keySet()) {
                if (!rank.equals(o)) continue;
                flag = true;
                break;
            }
            if (flag) {
                int value = (Integer)map.get(rank) + 1;
                map.put(rank, value);
                flag = false;
                continue;
            }
            map.put(rank, 1);
        }
        new PieChart3D(map, String.valueOf(name) + " \u7c89\u4e1d\u7ea7\u522b\u5206\u5e03");
    }
}

