/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.analysis;

import com.mrhso.analysis.AnalysisType;
import com.mrhso.main.HomePanel;
import com.mrhso.main.Main;
import javax.swing.JButton;
import javax.swing.JComponent;
import weibo4j.Friendships;
import weibo4j.Timeline;
import weibo4j.Users;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class AnalysisIndex
extends Thread {
    private JComponent jComponent;
    private JComponent jComponent2;
    private AnalysisType analysisType;
    private HomePanel homePanel;

    public AnalysisIndex(HomePanel homePanel, JComponent component, JComponent component2, AnalysisType analysisType) {
        this.homePanel = homePanel;
        this.jComponent = component;
        this.jComponent2 = component2;
        this.analysisType = analysisType;
    }

    @Override
    public void run() {
        super.run();
        switch (this.analysisType) {
            case secondaryFans: {
                this.secondaryFans();
                break;
            }
            case reply: {
                this.reply();
                break;
            }
            case repost: {
                this.repost();
                break;
            }
            case active: {
                this.active();
                break;
            }
            case transmissibility: {
                this.transmissibility();
                break;
            }
        }
        this.homePanel.setBtnD();
    }

    public void secondaryFans() {
        Friendships friendships = new Friendships();
        String[] followers = null;
        int follower = Main.getUser().getFollowersCount();
        String parm = "";
        try {
            followers = friendships.getFollowersIdsById(Main.getUser().getId(), 100, 0);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        String[] stringArray = followers;
        int n = followers.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            parm = String.valueOf(parm) + string + ",";
            ++n2;
        }
        Users users = new Users();
        JSONArray jonsArray = null;
        try {
            jonsArray = users.getUserCount(parm);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = null;
        int count = 0;
        int size = jonsArray.length();
        int i = 0;
        while (i < size) {
            try {
                jsonObject = jonsArray.getJSONObject(i);
                count += jsonObject.getInt("followers_count");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ++i;
        }
        follower = follower / size * count;
        JButton jButton = (JButton)this.jComponent2;
        jButton.setText(String.valueOf(follower));
    }

    public void reply() {
        this.postCount(AnalysisType.reply);
    }

    public void repost() {
        this.postCount(AnalysisType.repost);
    }

    public void postCount(AnalysisType analysisType) {
        Timeline timeline = new Timeline();
        String ids = null;
        float post = Main.getUser().getStatusesCount();
        try {
            ids = timeline.getUserTimelineIdsByUid(Main.getUser().getId(), 100);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        ids = ids.replace("\"", "").replace("[", "").replace("]", "");
        JSONArray jonsArray = null;
        try {
            jonsArray = timeline.getPostCount(ids);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = null;
        int count = 0;
        int size = jonsArray.length();
        int i = 0;
        while (i < size) {
            try {
                jsonObject = jonsArray.getJSONObject(i);
                count = analysisType == AnalysisType.reply ? (count += jsonObject.getInt("comments")) : (count += jsonObject.getInt("reposts"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ++i;
        }
        post = post / (float)size * (float)count;
        JButton jButton = (JButton)this.jComponent2;
        jButton.setText(String.valueOf((int)post));
    }

    public void active() {
    }

    public void transmissibility() {
    }

    public JComponent getjComponent() {
        return this.jComponent;
    }

    public void setjComponent(JComponent jComponent) {
        this.jComponent = jComponent;
    }

    public JComponent getjComponent2() {
        return this.jComponent2;
    }

    public void setjComponent2(JComponent jComponent2) {
        this.jComponent2 = jComponent2;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    public HomePanel getHomePanel() {
        return this.homePanel;
    }

    public void setHomePanel(HomePanel homePanel) {
        this.homePanel = homePanel;
    }
}

