/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.analysis;

import com.mrhso.analysis.AnalysisLogic;
import com.mrhso.analysis.AnalysisType;
import com.mrhso.analysis.SaveFileFilter;
import com.mrhso.main.Main;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import weibo4j.Timeline;
import weibo4j.http.ImageItem;
import weibo4j.model.WeiboException;

public class AnalysisFrame
extends JFrame {
    private static final long serialVersionUID = -6399190857427207151L;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private AnalysisType analysisType = null;
    private JTextField nickname = null;
    private JComboBox numSelect = null;
    private JPanel chartPanel = null;
    private JPanel loadPanel = null;
    AnalysisLogic analysisLogic = null;

    public AnalysisFrame(AnalysisType type) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.setResizable(false);
        this.analysisType = type;
        this.getContentPane().setLayout(null);
        JPanel panel = new JPanel();
        panel.setBounds(0, 0, 884, 611);
        this.getContentPane().add(panel);
        panel.setLayout(null);
        JButton share = new JButton("\u5206\u4eab");
        share.setBounds(746, 499, 93, 39);
        panel.add(share);
        JButton save = new JButton("\u4fdd\u5b58");
        save.setBounds(643, 499, 93, 39);
        panel.add(save);
        JButton search = new JButton("\u67e5\u8be2");
        search.setBounds(540, 499, 93, 39);
        panel.add(search);
        this.loadPanel = new JPanel();
        this.loadPanel.setBounds(0, 0, 850, 489);
        panel.add(this.loadPanel);
        this.loadPanel.setLayout(null);
        JLabel label = new JLabel("");
        label.setIcon(new ImageIcon("images/loading.gif"));
        label.setBounds(368, 161, 91, 83);
        this.loadPanel.add(label);
        JLabel label_1 = new JLabel("\u6b63\u5728\u52a0\u8f7d\u548c\u8ba1\u7b97\u6570\u636e.....");
        label_1.setBounds(345, 248, 174, 15);
        this.loadPanel.add(label_1);
        this.chartPanel = new JPanel();
        this.chartPanel.setBounds(0, 0, 850, 489);
        panel.add(this.chartPanel);
        this.chartPanel.setLayout(null);
        this.setBounds(100, 100, 900, 650);
        this.setVisible(true);
        this.numSelect = new JComboBox();
        this.numSelect.setBounds(395, 499, 93, 39);
        panel.add(this.numSelect);
        panel.add(this.numSelect);
        this.numSelect.addItem("100");
        this.numSelect.addItem("200");
        this.numSelect.addItem("400");
        this.numSelect.addItem("600");
        this.numSelect.addItem("800");
        this.numSelect.addItem("1000");
        this.numSelect.setSelectedItem("100");
        this.nickname = new JTextField();
        this.nickname.setFont(new Font("\u5b8b\u4f53", 0, 18));
        this.nickname.setBounds(89, 499, 211, 39);
        panel.add(this.nickname);
        this.nickname.setColumns(10);
        JLabel lblNewLabel = new JLabel("\u6635\u79f0");
        lblNewLabel.setFont(new Font("\u5b8b\u4f53", 0, 18));
        lblNewLabel.setBounds(40, 499, 39, 39);
        panel.add(lblNewLabel);
        JLabel label_2 = new JLabel("\u8bb0\u5f55\u6761\u6570");
        label_2.setFont(new Font("\u5b8b\u4f53", 0, 18));
        label_2.setBounds(310, 499, 81, 39);
        panel.add(label_2);
        this.nickname.setText(Main.getUser().getScreenName());
        this.analysisLogic = new AnalysisLogic(this, this.nickname.getText(), this.numSelect.getSelectedItem().toString());
        this.analysisLogic.start();
        this.numSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int value;
                if (e.getStateChange() == 1 && (value = Integer.valueOf(e.getItem().toString()).intValue()) > 200) {
                    AnalysisFrame.this.numSelect.setSelectedItem("200");
                    JOptionPane.showMessageDialog(null, "\u5f53\u524d\u7248\u672c\u65e0\u6cd5\u9009\u62e9\u8be5\u9009\u9879\uff0c\u53ea\u7528\u4e13\u4e1a\u7248\u624d\u53ef\u4ee5");
                }
            }
        });
        share.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChartPanel mypanel = (ChartPanel)AnalysisFrame.this.chartPanel.getComponent(0);
                ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
                try {
                    ChartUtilities.writeChartAsJPEG((OutputStream)baoStream, (float)1.0f, (JFreeChart)mypanel.getChart(), (int)800, (int)500);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Timeline timeline = new Timeline();
                String statusTxt = "\u8d76\u7d27\u6765\u770b\u770b\u6211\u7684\u6570\u636e\u5427\u3002";
                statusTxt = JOptionPane.showInputDialog(AnalysisFrame.this, "\u8f93\u5165\u8981\u53d1\u5e03\u7684\u5185\u5bb9", "\u53d1\u5e03\u5185\u5bb9", 3);
                System.out.println("input:" + statusTxt);
                if (statusTxt != null) {
                    if ("".equals(statusTxt)) {
                        statusTxt = "\u8d76\u7d27\u6765\u770b\u770b\u6211\u7684\u6570\u636e\u5427\u3002";
                    }
                    try {
                        statusTxt = URLEncoder.encode(statusTxt, "utf-8");
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        timeline.UploadStatus(String.valueOf(statusTxt) + " [" + AnalysisFrame.this.formatter.format(new Date()) + " by wtools]", new ImageItem(baoStream.toByteArray()));
                        JOptionPane.showMessageDialog(AnalysisFrame.this, "\u543c\u543c,\u5206\u4eab\u6210\u529f!!");
                    }
                    catch (WeiboException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = 0;
                Object file = null;
                String path = null;
                JFileChooser fileChooser = new JFileChooser();
                FileSystemView fsv = FileSystemView.getFileSystemView();
                System.out.println(fsv.getHomeDirectory());
                fileChooser.setCurrentDirectory(fsv.getHomeDirectory());
                fileChooser.setDialogTitle("\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6...");
                fileChooser.setApproveButtonText("\u786e\u5b9a");
                fileChooser.setFileSelectionMode(0);
                fileChooser.setFileFilter(new SaveFileFilter());
                result = fileChooser.showOpenDialog(AnalysisFrame.this);
                if (result == 0) {
                    path = fileChooser.getSelectedFile().getPath();
                    System.out.println("path: " + path);
                    ChartPanel mypanel = (ChartPanel)AnalysisFrame.this.chartPanel.getComponent(0);
                    try {
                        ChartUtilities.saveChartAsJPEG((File)new File(String.valueOf(path) + "_" + Calendar.getInstance().getTimeInMillis() + ".jpg"), (float)1.0f, (JFreeChart)mypanel.getChart(), (int)800, (int)500);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(AnalysisFrame.this, "\u54e6\u8036\uff0c\u56fe\u7247\u4fdd\u5b58\u6210\u529f");
                }
            }
        });
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AnalysisFrame.this.analysisLogic = new AnalysisLogic(AnalysisFrame.this, AnalysisFrame.this.nickname.getText(), AnalysisFrame.this.numSelect.getSelectedItem().toString());
                AnalysisFrame.this.analysisLogic.start();
            }
        });
        this.nickname.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AnalysisFrame.this.analysisLogic = new AnalysisLogic(AnalysisFrame.this, AnalysisFrame.this.nickname.getText(), AnalysisFrame.this.numSelect.getSelectedItem().toString());
                    AnalysisFrame.this.analysisLogic.start();
                }
                super.keyPressed(e);
            }
        });
        this.setLocationRelativeTo(null);
    }

    public void userNotExist() {
        JOptionPane.showMessageDialog(this, "\u4f60\u67e5\u8be2\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u7f51\u7edc\u5f02\u5e38~~");
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    public JTextField getNickname() {
        return this.nickname;
    }

    public void setNickname(JTextField nickname) {
        this.nickname = nickname;
    }

    public JComboBox getNumSelect() {
        return this.numSelect;
    }

    public JPanel getChartPanel() {
        return this.chartPanel;
    }

    public JPanel getLoadPanel() {
        return this.loadPanel;
    }
}

