/*
 * Decompiled with CFR 0.152.
 */
package com.mrhso.account;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import com.mrhso.StartWTools;
import com.mrhso.account.AccessTokenDao;
import com.mrhso.common.Config;
import com.mrhso.common.WtoolConnect;
import com.mrhso.main.Main;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JDialog;
import weibo4j.Account;
import weibo4j.Common;
import weibo4j.Oauth;
import weibo4j.Users;
import weibo4j.Weibo;
import weibo4j.examples.oauth2.Log;
import weibo4j.http.AccessToken;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;

public class AuthorizeLogic {
    private String lastUrl = "http://wtool.sinaapp.com/Auth/?client=client";
    private static Main mainDialog;
    private Oauth oauth = new Oauth();
    private static User user;
    private JDialog dialog;

    public AuthorizeLogic() {
        this.init();
    }

    public void init() {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u6388\u6743\u7684\u754c\u9762...");
        this.dialog = new JDialog(){
            private static final long serialVersionUID = -4925844767877475984L;

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    Log.logInfo("\u7a97\u53e3\u5df2\u7ecf\u88ab\u5173\u95ed");
                    AuthorizeLogic.this.dialog.dispose();
                    System.exit(0);
                }
            }
        };
        this.dialog.setTitle("\u6388\u6743");
        this.dialog.setResizable(false);
        this.dialog.setBounds(30, 30, 608, 400);
        this.dialog.add((Component)this.getWebBrowser(), "Center");
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
    }

    public AuthorizeLogic(String accessToken) throws WeiboException {
        this.init(accessToken);
    }

    private void init(String accessToken) {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u4e3b\u754c\u9762...");
        Weibo weibo = new Weibo();
        weibo.setToken(accessToken);
        Boolean flag = true;
        Account ac = new Account();
        String uid = null;
        while (flag.booleanValue()) {
            try {
                Log.logInfo("\u6b63\u5728\u8bfb\u53d6\u7528\u6237\u6807\u8bc6...");
                uid = ac.getUid().get("uid").toString();
                flag = false;
            }
            catch (JSONException e1) {
                System.out.println(e1.getMessage());
            }
            catch (WeiboException e1) {
                if (21327 != e1.getErrorCode()) continue;
                Config config = new Config();
                config.setAccessToken("");
                AccessTokenDao.write(config);
                this.init();
                break;
            }
        }
        if (uid == null) {
            return;
        }
        Users um = new Users();
        flag = true;
        while (flag.booleanValue()) {
            try {
                Log.logInfo("\u6b63\u5728\u8bfb\u53d6\u7528\u6237\u4fe1\u606f...");
                user = um.showUserById(uid);
                flag = false;
            }
            catch (WeiboException e1) {
                System.out.println(e1.getMessage());
            }
        }
        Common common = new Common();
        Map<String, String> map = null;
        flag = true;
        while (flag.booleanValue()) {
            try {
                Log.logInfo("\u6b63\u5728\u8bfb\u53d6\u914d\u7f6e\u4fe1\u606f...");
                map = common.getProvice("001");
                flag = false;
            }
            catch (WeiboException e) {
                System.out.println(e.getMessage());
            }
            catch (JSONException e) {
                System.out.println(e.getMessage());
            }
        }
        WtoolConnect wtoolConnect = new WtoolConnect();
        String services = wtoolConnect.getServiceStr(user.getId());
        StartWTools.loadingFrame.dispose();
        mainDialog = new Main(user);
        Main.setLocation(map);
        Main.setServices(services);
    }

    private JWebBrowser getWebBrowser() {
        JWebBrowser webBrowser = new JWebBrowser(new NSOption[0]);
        webBrowser.setBarsVisible(false);
        webBrowser.setButtonBarVisible(false);
        webBrowser.setDefaultPopupMenuRegistered(false);
        webBrowser.navigate(this.lastUrl);
        webBrowser.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void locationChanged(WebBrowserNavigationEvent e) {
                String site = e.getWebBrowser().getResourceLocation();
                if (site == null || AuthorizeLogic.this.lastUrl.equals(site) || site.indexOf("access") == -1) {
                    return;
                }
                AuthorizeLogic.this.lastUrl = site;
                AuthorizeLogic.this.dialog.dispose();
                String access = site.substring(site.lastIndexOf("access=") + 7);
                if (access == null) {
                    return;
                }
                Config config = new Config();
                config.setAccessToken(access);
                AccessTokenDao.write(config);
                Log.logInfo("\u6388\u6743\u6210\u529f...");
                AuthorizeLogic.this.init(access);
            }
        });
        return webBrowser;
    }

    private String getAccessTokenByCode(String code) {
        Log.logInfo("code:" + code);
        AccessToken accessToken = null;
        try {
            accessToken = this.oauth.getAccessTokenByCode(code);
        }
        catch (WeiboException e) {
            if (401 == e.getStatusCode()) {
                Log.logInfo("Unable to get the access token.");
            } else {
                e.printStackTrace();
            }
            return null;
        }
        return accessToken.getAccessToken();
    }

    public static Main getMainDialog() {
        return mainDialog;
    }

    public static User getUser() {
        return user;
    }
}

