/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe;
    private static final int base;
    private static final int shift;
    private static final long arrayFieldOffset;
    private final Object[] array;

    private long checkedByteOffset(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return AtomicReferenceArray.byteOffset(n);
    }

    private static long byteOffset(int n) {
        return ((long)n << shift) + (long)base;
    }

    public AtomicReferenceArray(int n) {
        this.array = new Object[n];
    }

    public AtomicReferenceArray(E[] EArray) {
        this.array = Arrays.copyOf(EArray, EArray.length, Object[].class);
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int n) {
        return this.getRaw(this.checkedByteOffset(n));
    }

    private E getRaw(long l) {
        return (E)unsafe.getObjectVolatile(this.array, l);
    }

    public final void set(int n, E e) {
        unsafe.putObjectVolatile(this.array, this.checkedByteOffset(n), e);
    }

    public final void lazySet(int n, E e) {
        unsafe.putOrderedObject(this.array, this.checkedByteOffset(n), e);
    }

    public final E getAndSet(int n, E e) {
        E e2;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, e2 = this.getRaw(l), e)) {
        }
        return e2;
    }

    public final boolean compareAndSet(int n, E e, E e2) {
        return this.compareAndSetRaw(this.checkedByteOffset(n), e, e2);
    }

    private boolean compareAndSetRaw(long l, E e, E e2) {
        return unsafe.compareAndSwapObject(this.array, l, e, e2);
    }

    public final boolean weakCompareAndSet(int n, E e, E e2) {
        return this.compareAndSet(n, e, e2);
    }

    public String toString() {
        int n = this.array.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(this.getRaw(AtomicReferenceArray.byteOffset(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        T[] TArray = objectInputStream.readFields().get("array", null);
        if (TArray == null || !TArray.getClass().isArray()) {
            throw new InvalidObjectException("Not array type");
        }
        if (TArray.getClass() != Object[].class) {
            TArray = Arrays.copyOf((Object[])TArray, Array.getLength(TArray), Object[].class);
        }
        unsafe.putObjectVolatile(this, arrayFieldOffset, TArray);
    }

    static {
        int n;
        try {
            unsafe = Unsafe.getUnsafe();
            arrayFieldOffset = unsafe.objectFieldOffset(AtomicReferenceArray.class.getDeclaredField("array"));
            base = unsafe.arrayBaseOffset(Object[].class);
            n = unsafe.arrayIndexScale(Object[].class);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        shift = 31 - Integer.numberOfLeadingZeros(n);
    }
}

