/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IFEQ;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionConstants;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.utils.ObjectFactory;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CastExpr;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Expression;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.BooleanType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.IntType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MultiHashtable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ObjectType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ReferenceType;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FunctionCall
extends Expression {
    private QName _fname;
    private final Vector _arguments;
    private static final Vector EMPTY_ARG_LIST = new Vector(0);
    protected static final String EXT_XSLTC = "http://xml.apache.org/xalan/xsltc";
    protected static final String JAVA_EXT_XSLTC = "http://xml.apache.org/xalan/xsltc/java";
    protected static final String EXT_XALAN = "http://xml.apache.org/xalan";
    protected static final String JAVA_EXT_XALAN = "http://xml.apache.org/xalan/java";
    protected static final String JAVA_EXT_XALAN_OLD = "http://xml.apache.org/xslt/java";
    protected static final String EXSLT_COMMON = "http://exslt.org/common";
    protected static final String EXSLT_MATH = "http://exslt.org/math";
    protected static final String EXSLT_SETS = "http://exslt.org/sets";
    protected static final String EXSLT_DATETIME = "http://exslt.org/dates-and-times";
    protected static final String EXSLT_STRINGS = "http://exslt.org/strings";
    protected static final int NAMESPACE_FORMAT_JAVA = 0;
    protected static final int NAMESPACE_FORMAT_CLASS = 1;
    protected static final int NAMESPACE_FORMAT_PACKAGE = 2;
    protected static final int NAMESPACE_FORMAT_CLASS_OR_PACKAGE = 3;
    private int _namespace_format = 0;
    Expression _thisArgument = null;
    private String _className;
    private Class _clazz;
    private Method _chosenMethod;
    private Constructor _chosenConstructor;
    private MethodType _chosenMethodType;
    private boolean unresolvedExternal;
    private boolean _isExtConstructor = false;
    private boolean _isStatic = false;
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static final Hashtable _java2Internal = new Hashtable();
    private static final Hashtable _extensionNamespaceTable = new Hashtable();
    private static final Hashtable _extensionFunctionTable = new Hashtable();

    public FunctionCall(QName qName, Vector vector) {
        this._fname = qName;
        this._arguments = vector;
        this._type = null;
    }

    public FunctionCall(QName qName) {
        this(qName, EMPTY_ARG_LIST);
    }

    public String getName() {
        return this._fname.toString();
    }

    public void setParser(Parser parser) {
        super.setParser(parser);
        if (this._arguments != null) {
            int n = this._arguments.size();
            for (int i = 0; i < n; ++i) {
                Expression expression = (Expression)this._arguments.elementAt(i);
                expression.setParser(parser);
                expression.setParent(this);
            }
        }
    }

    public String getClassNameFromUri(String string) {
        String string2 = (String)_extensionNamespaceTable.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith(JAVA_EXT_XSLTC)) {
            int n = JAVA_EXT_XSLTC.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith(JAVA_EXT_XALAN)) {
            int n = JAVA_EXT_XALAN.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith(JAVA_EXT_XALAN_OLD)) {
            int n = JAVA_EXT_XALAN_OLD.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._type != null) {
            return this._type;
        }
        String string = this._fname.getNamespace();
        String string2 = this._fname.getLocalPart();
        if (this.isExtension()) {
            this._fname = new QName(null, null, string2);
            return this.typeCheckStandard(symbolTable);
        }
        if (this.isStandard()) {
            return this.typeCheckStandard(symbolTable);
        }
        try {
            this._className = this.getClassNameFromUri(string);
            int n = string2.lastIndexOf(46);
            if (n > 0) {
                this._isStatic = true;
                if (this._className != null && this._className.length() > 0) {
                    this._namespace_format = 2;
                    this._className = this._className + "." + string2.substring(0, n);
                } else {
                    this._namespace_format = 0;
                    this._className = string2.substring(0, n);
                }
                this._fname = new QName(string, null, string2.substring(n + 1));
            } else {
                String string3;
                if (this._className != null && this._className.length() > 0) {
                    try {
                        this._clazz = ObjectFactory.findProviderClass(this._className, true);
                        this._namespace_format = 1;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this._namespace_format = 2;
                    }
                } else {
                    this._namespace_format = 0;
                }
                if (string2.indexOf(45) > 0) {
                    string2 = FunctionCall.replaceDash(string2);
                }
                if ((string3 = (String)_extensionFunctionTable.get(string + ":" + string2)) != null) {
                    this._fname = new QName(null, null, string3);
                    return this.typeCheckStandard(symbolTable);
                }
                this._fname = new QName(string, null, string2);
            }
            return this.typeCheckExternal(symbolTable);
        }
        catch (TypeCheckError typeCheckError) {
            ErrorMsg errorMsg = typeCheckError.getErrorMsg();
            if (errorMsg == null) {
                String string4 = this._fname.getLocalPart();
                errorMsg = new ErrorMsg("METHOD_NOT_FOUND_ERR", string4);
            }
            this.getParser().reportError(3, errorMsg);
            this._type = Type.Void;
            return this._type;
        }
    }

    public Type typeCheckStandard(SymbolTable symbolTable) throws TypeCheckError {
        this._fname.clearNamespace();
        int n = this._arguments.size();
        Vector vector = this.typeCheckArgs(symbolTable);
        MethodType methodType = new MethodType(Type.Void, vector);
        MethodType methodType2 = this.lookupPrimop(symbolTable, this._fname.getLocalPart(), methodType);
        if (methodType2 != null) {
            for (int i = 0; i < n; ++i) {
                Expression expression;
                Type type = (Type)methodType2.argsType().elementAt(i);
                if (type.identicalTo((expression = (Expression)this._arguments.elementAt(i)).getType())) continue;
                try {
                    this._arguments.setElementAt(new CastExpr(expression, type), i);
                    continue;
                }
                catch (TypeCheckError typeCheckError) {
                    throw new TypeCheckError(this);
                }
            }
            this._chosenMethodType = methodType2;
            this._type = methodType2.resultType();
            return this._type;
        }
        throw new TypeCheckError(this);
    }

    public Type typeCheckConstructor(SymbolTable symbolTable) throws TypeCheckError {
        Vector vector = this.findConstructors();
        if (vector == null) {
            throw new TypeCheckError("CONSTRUCTOR_NOT_FOUND", this._className);
        }
        int n = vector.size();
        int n2 = this._arguments.size();
        Vector vector2 = this.typeCheckArgs(symbolTable);
        int n3 = Integer.MAX_VALUE;
        this._type = null;
        for (int i = 0; i < n; ++i) {
            int n4;
            Constructor constructor = (Constructor)vector.elementAt(i);
            Class<?>[] classArray = constructor.getParameterTypes();
            Class<?> clazz = null;
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                clazz = classArray[n4];
                Type type = (Type)vector2.elementAt(n4);
                Object object = _internal2Java.maps(type, clazz);
                if (object != null) {
                    n5 += ((JavaType)object).distance;
                    continue;
                }
                if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    if (objectType.getJavaClass() == clazz) continue;
                    if (clazz.isAssignableFrom(objectType.getJavaClass())) {
                        ++n5;
                        continue;
                    }
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                n5 = Integer.MAX_VALUE;
                break;
            }
            if (n4 != n2 || n5 >= n3) continue;
            this._chosenConstructor = constructor;
            this._isExtConstructor = true;
            n3 = n5;
            this._type = this._clazz != null ? Type.newObjectType(this._clazz) : Type.newObjectType(this._className);
        }
        if (this._type != null) {
            return this._type;
        }
        throw new TypeCheckError("ARGUMENT_CONVERSION_ERR", this.getMethodSignature(vector2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Type typeCheckExternal(SymbolTable symbolTable) throws TypeCheckError {
        Vector vector;
        Class<?> clazz;
        int n = this._arguments.size();
        String string = this._fname.getLocalPart();
        if (this._fname.getLocalPart().equals("new")) {
            return this.typeCheckConstructor(symbolTable);
        }
        boolean bl = false;
        if (n == 0) {
            this._isStatic = true;
        }
        if (!this._isStatic) {
            if (this._namespace_format == 0 || this._namespace_format == 2) {
                bl = true;
            }
            clazz = (Expression)this._arguments.elementAt(0);
            Type type = ((Expression)((Object)clazz)).typeCheck(symbolTable);
            if (this._namespace_format == 1 && type instanceof ObjectType && this._clazz != null && this._clazz.isAssignableFrom(((ObjectType)type).getJavaClass())) {
                bl = true;
            }
            if (bl) {
                this._thisArgument = (Expression)this._arguments.elementAt(0);
                this._arguments.remove(0);
                --n;
                if (!(type instanceof ObjectType)) throw new TypeCheckError("NO_JAVA_FUNCT_THIS_REF", string);
                this._className = ((ObjectType)type).getJavaClassName();
            }
        } else if (this._className.length() == 0) {
            Parser parser = this.getParser();
            if (parser != null) {
                this.reportWarning(this, parser, "FUNCTION_RESOLVE_ERR", this._fname.toString());
            }
            this.unresolvedExternal = true;
            this._type = Type.Int;
            return this._type;
        }
        if ((vector = this.findMethods()) == null) {
            throw new TypeCheckError("METHOD_NOT_FOUND_ERR", this._className + "." + string);
        }
        clazz = null;
        int n2 = vector.size();
        Vector vector2 = this.typeCheckArgs(symbolTable);
        int n3 = Integer.MAX_VALUE;
        this._type = null;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Method method = (Method)vector.elementAt(i);
            Class<?>[] classArray = method.getParameterTypes();
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                clazz = classArray[n4];
                Type type = (Type)vector2.elementAt(n4);
                Object object = _internal2Java.maps(type, clazz);
                if (object != null) {
                    n5 += ((JavaType)object).distance;
                    continue;
                }
                if (type instanceof ReferenceType) {
                    ++n5;
                    continue;
                }
                if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    if (clazz.getName().equals(objectType.getJavaClassName())) {
                        n5 += 0;
                        continue;
                    }
                    if (clazz.isAssignableFrom(objectType.getJavaClass())) {
                        ++n5;
                        continue;
                    }
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                n5 = Integer.MAX_VALUE;
                break;
            }
            if (n4 != n) continue;
            clazz = method.getReturnType();
            this._type = (Type)_java2Internal.get(clazz);
            if (this._type == null) {
                this._type = Type.newObjectType(clazz);
            }
            if (this._type == null || n5 >= n3) continue;
            this._chosenMethod = method;
            n3 = n5;
        }
        if (this._chosenMethod != null && this._thisArgument == null && !Modifier.isStatic(this._chosenMethod.getModifiers())) {
            throw new TypeCheckError("NO_JAVA_FUNCT_THIS_REF", this.getMethodSignature(vector2));
        }
        if (this._type == null) throw new TypeCheckError("ARGUMENT_CONVERSION_ERR", this.getMethodSignature(vector2));
        if (this._type != Type.NodeSet) return this._type;
        this.getXSLTC().setMultiDocument(true);
        return this._type;
    }

    public Vector typeCheckArgs(SymbolTable symbolTable) throws TypeCheckError {
        Vector<Type> vector = new Vector<Type>();
        Enumeration enumeration = this._arguments.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            vector.addElement(expression.typeCheck(symbolTable));
        }
        return vector;
    }

    protected final Expression argument(int n) {
        return (Expression)this._arguments.elementAt(n);
    }

    protected final Expression argument() {
        return this.argument(0);
    }

    protected final int argumentCount() {
        return this._arguments.size();
    }

    protected final void setArgument(int n, Expression expression) {
        this._arguments.setElementAt(expression, n);
    }

    public void translateDesynthesized(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Type type = Type.Boolean;
        if (this._chosenMethodType != null) {
            type = this._chosenMethodType.resultType();
        }
        InstructionList instructionList = methodGenerator.getInstructionList();
        this.translate(classGenerator, methodGenerator);
        if (type instanceof BooleanType || type instanceof IntType) {
            this._falseList.add(instructionList.append(new IFEQ(null)));
        }
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        int n = this.argumentCount();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        boolean bl = classGenerator.getParser().getXSLTC().isSecureProcessing();
        if (this.isStandard() || this.isExtension()) {
            Object object;
            for (int i = 0; i < n; ++i) {
                object = this.argument(i);
                ((Expression)object).translate(classGenerator, methodGenerator);
                ((Expression)object).startIterator(classGenerator, methodGenerator);
            }
            String string = this._fname.toString().replace('-', '_') + "F";
            object = "";
            if (string.equals("sumF")) {
                object = "Lcom/sun/org/apache/xalan/internal/xsltc/DOM;";
                instructionList.append(methodGenerator.loadDOM());
            } else if (string.equals("normalize_spaceF") && this._chosenMethodType.toSignature((String)object).equals("()Ljava/lang/String;")) {
                object = "ILcom/sun/org/apache/xalan/internal/xsltc/DOM;";
                instructionList.append(methodGenerator.loadContextNode());
                instructionList.append(methodGenerator.loadDOM());
            }
            int n2 = constantPoolGen.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary", string, this._chosenMethodType.toSignature((String)object));
            instructionList.append(new INVOKESTATIC(n2));
        } else if (this.unresolvedExternal) {
            int n3 = constantPoolGen.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary", "unresolved_externalF", "(Ljava/lang/String;)V");
            instructionList.append(new PUSH(constantPoolGen, this._fname.toString()));
            instructionList.append(new INVOKESTATIC(n3));
        } else if (this._isExtConstructor) {
            Expression expression;
            int n4;
            if (bl) {
                this.translateUnallowedExtension(constantPoolGen, instructionList);
            }
            String string = this._chosenConstructor.getDeclaringClass().getName();
            Class<?>[] classArray = this._chosenConstructor.getParameterTypes();
            LocalVariableGen[] localVariableGenArray = new LocalVariableGen[n];
            for (n4 = 0; n4 < n; ++n4) {
                expression = this.argument(n4);
                Type type = expression.getType();
                expression.translate(classGenerator, methodGenerator);
                expression.startIterator(classGenerator, methodGenerator);
                type.translateTo(classGenerator, methodGenerator, classArray[n4]);
                localVariableGenArray[n4] = methodGenerator.addLocalVariable("function_call_tmp" + n4, type.toJCType(), instructionList.getEnd(), null);
                instructionList.append(type.STORE(localVariableGenArray[n4].getIndex()));
            }
            instructionList.append(new NEW(constantPoolGen.addClass(this._className)));
            instructionList.append(InstructionConstants.DUP);
            for (n4 = 0; n4 < n; ++n4) {
                expression = this.argument(n4);
                instructionList.append(expression.getType().LOAD(localVariableGenArray[n4].getIndex()));
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(FunctionCall.getSignature(classArray[i]));
            }
            stringBuffer.append(')');
            stringBuffer.append("V");
            int n5 = constantPoolGen.addMethodref(string, "<init>", stringBuffer.toString());
            instructionList.append(new INVOKESPECIAL(n5));
            Type.Object.translateFrom(classGenerator, methodGenerator, this._chosenConstructor.getDeclaringClass());
        } else {
            if (bl) {
                this.translateUnallowedExtension(constantPoolGen, instructionList);
            }
            String string = this._chosenMethod.getDeclaringClass().getName();
            Class<?>[] classArray = this._chosenMethod.getParameterTypes();
            if (this._thisArgument != null) {
                this._thisArgument.translate(classGenerator, methodGenerator);
            }
            for (int i = 0; i < n; ++i) {
                Expression expression = this.argument(i);
                expression.translate(classGenerator, methodGenerator);
                expression.startIterator(classGenerator, methodGenerator);
                expression.getType().translateTo(classGenerator, methodGenerator, classArray[i]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(FunctionCall.getSignature(classArray[i]));
            }
            stringBuffer.append(')');
            stringBuffer.append(FunctionCall.getSignature(this._chosenMethod.getReturnType()));
            if (this._thisArgument != null && this._clazz.isInterface()) {
                int n6 = constantPoolGen.addInterfaceMethodref(string, this._fname.getLocalPart(), stringBuffer.toString());
                instructionList.append(new INVOKEINTERFACE(n6, n + 1));
            } else {
                int n7 = constantPoolGen.addMethodref(string, this._fname.getLocalPart(), stringBuffer.toString());
                instructionList.append(this._thisArgument != null ? new INVOKEVIRTUAL(n7) : new INVOKESTATIC(n7));
            }
            this._type.translateFrom(classGenerator, methodGenerator, this._chosenMethod.getReturnType());
        }
    }

    public String toString() {
        return "funcall(" + this._fname + ", " + this._arguments + ')';
    }

    public boolean isStandard() {
        String string = this._fname.getNamespace();
        return string == null || string.equals("");
    }

    public boolean isExtension() {
        String string = this._fname.getNamespace();
        return string != null && string.equals(EXT_XSLTC);
    }

    private Vector findMethods() {
        Vector<Method> vector = null;
        String string = this._fname.getNamespace();
        if (this._className != null && this._className.length() > 0) {
            int n = this._arguments.size();
            try {
                Object object;
                if (this._clazz == null) {
                    this._clazz = ObjectFactory.findProviderClass(this._className, true);
                    if (this._clazz == null) {
                        object = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                        this.getParser().reportError(3, (ErrorMsg)object);
                    }
                }
                object = this._fname.getLocalPart();
                Method[] methodArray = this._clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    int n2 = methodArray[i].getModifiers();
                    if (!Modifier.isPublic(n2) || !methodArray[i].getName().equals(object) || methodArray[i].getParameterTypes().length != n) continue;
                    if (vector == null) {
                        vector = new Vector<Method>();
                    }
                    vector.addElement(methodArray[i]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                this.getParser().reportError(3, errorMsg);
            }
        }
        return vector;
    }

    private Vector findConstructors() {
        Vector vector = null;
        String string = this._fname.getNamespace();
        int n = this._arguments.size();
        try {
            Object object;
            if (this._clazz == null) {
                this._clazz = ObjectFactory.findProviderClass(this._className, true);
                if (this._clazz == null) {
                    object = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                    this.getParser().reportError(3, (ErrorMsg)object);
                }
            }
            object = this._clazz.getConstructors();
            for (int i = 0; i < ((Constructor<?>[])object).length; ++i) {
                int n2 = object[i].getModifiers();
                if (!Modifier.isPublic(n2) || object[i].getParameterTypes().length != n) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(object[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
            this.getParser().reportError(3, errorMsg);
        }
        return vector;
    }

    static final String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz2 = clazz;
            while (clazz2.isArray()) {
                stringBuffer.append("[");
                clazz2 = clazz2.getComponentType();
            }
            stringBuffer.append(FunctionCall.getSignature(clazz2));
            return stringBuffer.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String string = clazz.toString();
            ErrorMsg errorMsg = new ErrorMsg("UNKNOWN_SIG_TYPE_ERR", string);
            throw new Error(errorMsg.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    static final String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(FunctionCall.getSignature(classArray[i]));
        }
        return stringBuffer.append(')').append(FunctionCall.getSignature(method.getReturnType())).toString();
    }

    static final String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(FunctionCall.getSignature(classArray[i]));
        }
        return stringBuffer.append(")V").toString();
    }

    private String getMethodSignature(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(this._className);
        stringBuffer.append('.').append(this._fname.getLocalPart()).append('(');
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Type type = (Type)vector.elementAt(i);
            stringBuffer.append(type.toString());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static String replaceDash(String string) {
        char c = '-';
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && string.charAt(i - 1) == c) {
                stringBuffer.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            if (string.charAt(i) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void translateUnallowedExtension(ConstantPoolGen constantPoolGen, InstructionList instructionList) {
        int n = constantPoolGen.addMethodref("com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary", "unallowed_extension_functionF", "(Ljava/lang/String;)V");
        instructionList.append(new PUSH(constantPoolGen, this._fname.toString()));
        instructionList.append(new INVOKESTATIC(n));
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.w3c.dom.Node");
            Class<?> clazz2 = Class.forName("org.w3c.dom.NodeList");
            _internal2Java.put(Type.Boolean, new JavaType(Boolean.TYPE, 0));
            _internal2Java.put(Type.Boolean, new JavaType(Boolean.class, 1));
            _internal2Java.put(Type.Boolean, new JavaType(Object.class, 2));
            _internal2Java.put(Type.Real, new JavaType(Double.TYPE, 0));
            _internal2Java.put(Type.Real, new JavaType(Double.class, 1));
            _internal2Java.put(Type.Real, new JavaType(Float.TYPE, 2));
            _internal2Java.put(Type.Real, new JavaType(Long.TYPE, 3));
            _internal2Java.put(Type.Real, new JavaType(Integer.TYPE, 4));
            _internal2Java.put(Type.Real, new JavaType(Short.TYPE, 5));
            _internal2Java.put(Type.Real, new JavaType(Byte.TYPE, 6));
            _internal2Java.put(Type.Real, new JavaType(Character.TYPE, 7));
            _internal2Java.put(Type.Real, new JavaType(Object.class, 8));
            _internal2Java.put(Type.Int, new JavaType(Double.TYPE, 0));
            _internal2Java.put(Type.Int, new JavaType(Double.class, 1));
            _internal2Java.put(Type.Int, new JavaType(Float.TYPE, 2));
            _internal2Java.put(Type.Int, new JavaType(Long.TYPE, 3));
            _internal2Java.put(Type.Int, new JavaType(Integer.TYPE, 4));
            _internal2Java.put(Type.Int, new JavaType(Short.TYPE, 5));
            _internal2Java.put(Type.Int, new JavaType(Byte.TYPE, 6));
            _internal2Java.put(Type.Int, new JavaType(Character.TYPE, 7));
            _internal2Java.put(Type.Int, new JavaType(Object.class, 8));
            _internal2Java.put(Type.String, new JavaType(String.class, 0));
            _internal2Java.put(Type.String, new JavaType(Object.class, 1));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz2, 0));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz, 1));
            _internal2Java.put(Type.NodeSet, new JavaType(Object.class, 2));
            _internal2Java.put(Type.NodeSet, new JavaType(String.class, 3));
            _internal2Java.put(Type.Node, new JavaType(clazz2, 0));
            _internal2Java.put(Type.Node, new JavaType(clazz, 1));
            _internal2Java.put(Type.Node, new JavaType(Object.class, 2));
            _internal2Java.put(Type.Node, new JavaType(String.class, 3));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz2, 0));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz, 1));
            _internal2Java.put(Type.ResultTree, new JavaType(Object.class, 2));
            _internal2Java.put(Type.ResultTree, new JavaType(String.class, 3));
            _internal2Java.put(Type.Reference, new JavaType(Object.class, 0));
            _java2Internal.put(Boolean.TYPE, Type.Boolean);
            _java2Internal.put(Void.TYPE, Type.Void);
            _java2Internal.put(Character.TYPE, Type.Real);
            _java2Internal.put(Byte.TYPE, Type.Real);
            _java2Internal.put(Short.TYPE, Type.Real);
            _java2Internal.put(Integer.TYPE, Type.Real);
            _java2Internal.put(Long.TYPE, Type.Real);
            _java2Internal.put(Float.TYPE, Type.Real);
            _java2Internal.put(Double.TYPE, Type.Real);
            _java2Internal.put(String.class, Type.String);
            _java2Internal.put(Object.class, Type.Reference);
            _java2Internal.put(clazz2, Type.NodeSet);
            _java2Internal.put(clazz, Type.NodeSet);
            _extensionNamespaceTable.put(EXT_XALAN, "com.sun.org.apache.xalan.internal.lib.Extensions");
            _extensionNamespaceTable.put(EXSLT_COMMON, "com.sun.org.apache.xalan.internal.lib.ExsltCommon");
            _extensionNamespaceTable.put(EXSLT_MATH, "com.sun.org.apache.xalan.internal.lib.ExsltMath");
            _extensionNamespaceTable.put(EXSLT_SETS, "com.sun.org.apache.xalan.internal.lib.ExsltSets");
            _extensionNamespaceTable.put(EXSLT_DATETIME, "com.sun.org.apache.xalan.internal.lib.ExsltDatetime");
            _extensionNamespaceTable.put(EXSLT_STRINGS, "com.sun.org.apache.xalan.internal.lib.ExsltStrings");
            _extensionFunctionTable.put("http://exslt.org/common:nodeSet", "nodeset");
            _extensionFunctionTable.put("http://exslt.org/common:objectType", "objectType");
            _extensionFunctionTable.put("http://xml.apache.org/xalan:nodeset", "nodeset");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
    }

    static class JavaType {
        public Class type;
        public int distance;

        public JavaType(Class clazz, int n) {
            this.type = clazz;
            this.distance = n;
        }

        public boolean equals(Object object) {
            return object.equals(this.type);
        }
    }
}

