/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;
import sun.security.mscapi.RSAKeyPair;
import sun.security.rsa.RSAKeyFactory;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    static final int KEY_SIZE_MIN = 512;
    static final int KEY_SIZE_MAX = 16384;
    private static final int KEY_SIZE_DEFAULT = 1024;
    private int keySize;

    public RSAKeyPairGenerator() {
        this.initialize(1024, null);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        try {
            RSAKeyFactory.checkKeyLengths(n, null, 512, 16384);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidParameterException(invalidKeyException.getMessage());
        }
        this.keySize = n;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        int n;
        if (algorithmParameterSpec == null) {
            n = 1024;
        } else if (algorithmParameterSpec instanceof RSAKeyGenParameterSpec) {
            if (((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent() != null) {
                throw new InvalidAlgorithmParameterException("Exponent parameter is not supported");
            }
            n = ((RSAKeyGenParameterSpec)algorithmParameterSpec).getKeysize();
        } else {
            throw new InvalidAlgorithmParameterException("Params must be an instance of RSAKeyGenParameterSpec");
        }
        try {
            RSAKeyFactory.checkKeyLengths(n, null, 512, 16384);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("Invalid Key sizes", invalidKeyException);
        }
        this.keySize = n;
    }

    public KeyPair generateKeyPair() {
        try {
            RSAKeyPair rSAKeyPair = RSAKeyPairGenerator.generateRSAKeyPair(this.keySize, "{" + UUID.randomUUID().toString() + "}");
            return new KeyPair(rSAKeyPair.getPublic(), rSAKeyPair.getPrivate());
        }
        catch (KeyException keyException) {
            throw new ProviderException(keyException);
        }
    }

    private static native RSAKeyPair generateRSAKeyPair(int var0, String var1) throws KeyException;
}

