/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorListener;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorSaveEvent;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditor;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JHTMLEditorFCKeditor
implements JHTMLEditor.JHTMLEditorImplementation {
    private static final String PACKAGE_PREFIX = "/fckeditor/";
    private static final String EDITOR_INSTANCE = "HTMLeditor1";
    private final JHTMLEditor htmlEditor;
    private final String customJavascriptConfiguration;
    private static final String LS = Utils.LINE_SEPARATOR;
    private volatile Object tempResult;

    public JHTMLEditorFCKeditor(JHTMLEditor htmlEditor, Map<Object, Object> optionMap) {
        if (this.getClass().getResource("/fckeditor/fckeditor.js") == null) {
            throw new IllegalStateException("The FCKEditor distribution is missing from the classpath!");
        }
        this.htmlEditor = htmlEditor;
        this.customJavascriptConfiguration = (String)optionMap.get("FCKEditor Custom Configuration Script");
        htmlEditor.getWebBrowser().addWebBrowserListener(new WebBrowserAdapter(){

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                e.setDialogWindow(true);
            }
        });
    }

    @Override
    public WebServer.WebServerContent getWebServerContent(final WebServer.HTTPRequest httpRequest, final String resourcePath, final int instanceID) {
        if ("index.html".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    int index = resourcePath.lastIndexOf(46);
                    return 2.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                }

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>" + LS + "    <style type=\"text/css\">" + LS + "      body, form {margin: 0; padding: 0; overflow: auto;}" + LS + "    </style>" + LS + "    <script type=\"text/javascript\" src=\"fckeditor.js\"></script>" + LS + "    <script type=\"text/javascript\">" + LS + "      function FCKeditor_IsCompatibleBrowser() {" + LS + "        return true;" + LS + "      }" + LS + "      var sendCommand = " + "sendNSCommand" + ";" + LS + "      var htmlContent;" + LS + "      var htmlDirtyTracker;" + LS + "      var isDirtyTrackingActive = true;" + LS + "      function JH_checkDirty() {" + LS + "        var inst = FCKeditorAPI.GetInstance('" + JHTMLEditorFCKeditor.EDITOR_INSTANCE + "');" + LS + "        if(htmlContent == null) {" + LS + "          try {" + LS + "            htmlContent = inst.GetHTML();" + LS + "          } catch(e) {" + LS + "          }" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        } else {" + LS + "          try {" + LS + "            var newHtmlContent = inst.GetHTML();" + LS + "            if(newHtmlContent != htmlContent) {" + LS + "              htmlContent = null;" + LS + "              htmlDirtyTracker = null;" + LS + "              sendCommand('[Chrriis]JH_setDirty');" + LS + "            } else {" + LS + "              htmlContent = newHtmlContent;" + LS + "              htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "            }" + LS + "          } catch(e) {" + LS + "            htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "          }" + LS + "        }" + LS + "      }" + LS + "      function JH_clearDirtyIndicator() {" + LS + "        if(htmlDirtyTracker) {" + LS + "          clearTimeout(htmlDirtyTracker);" + LS + "        }" + LS + "        htmlContent = null;" + LS + "        if(isDirtyTrackingActive) {" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        }" + LS + "      }" + LS + "      function JH_setDirtyTrackingActive(isActive) {" + LS + "        isDirtyTrackingActive = isActive;" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_setData(html) {" + LS + "        var inst = FCKeditorAPI.GetInstance('" + JHTMLEditorFCKeditor.EDITOR_INSTANCE + "');" + LS + "        inst.SetHTML(decodeURIComponent(html));" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_sendData() {" + LS + "        document.jhtml_form.action = 'jhtml_sendData';" + LS + "        document.jhtml_form.submit();" + LS + "        return false;" + LS + "      }" + LS + "      function JH_doSave() {" + LS + "        document.jhtml_form.action = 'jhtml_save';" + LS + "        document.jhtml_form.submit();" + LS + "        return false;" + LS + "      }" + LS + "      function createEditor() {" + LS + "        var oFCKeditor = new FCKeditor('" + JHTMLEditorFCKeditor.EDITOR_INSTANCE + "');" + LS + "        oFCKeditor.Width = \"100%\";" + LS + "        oFCKeditor.Height = \"100%\";" + LS + "        oFCKeditor.BasePath = \"\";" + LS + (JHTMLEditorFCKeditor.this.customJavascriptConfiguration != null ? "        oFCKeditor.Config[\"CustomConfigurationsPath\"] = '" + WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(instanceID), "customConfigurationScript.js") + "';" + LS : "") + "        oFCKeditor.Create();" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function FCKeditor_OnComplete(editorInstance) {" + LS + "        editorInstance.LinkedField.form.onsubmit = JH_doSave;" + LS + "        sendCommand('[Chrriis]JH_setLoaded');" + LS + "      }" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "  <iframe style=\"display:none;\" name=\"j_iframe\"></iframe>" + LS + "  <form name=\"jhtml_form\" method=\"POST\" target=\"j_iframe\">" + LS + "    <script type=\"text/javascript\">" + LS + "      createEditor();" + LS + "    </script>" + "</form>" + LS + "  </body>" + LS + "</html>" + LS;
                    return 2.getInputStream((String)content);
                }
            };
        }
        if ("customConfigurationScript.js".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return 3.getDefaultMimeType((String)".js");
                }

                public InputStream getInputStream() {
                    return 3.getInputStream((String)JHTMLEditorFCKeditor.this.customJavascriptConfiguration);
                }
            };
        }
        if ("jhtml_save".equals(resourcePath)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String html = JHTMLEditor.convertLinksToLocal((String)httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(JHTMLEditorFCKeditor.EDITOR_INSTANCE));
                    HTMLEditorSaveEvent e = null;
                    HTMLEditorListener[] hTMLEditorListenerArray = JHTMLEditorFCKeditor.this.htmlEditor.getHTMLEditorListeners();
                    int n = hTMLEditorListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HTMLEditorListener listener = hTMLEditorListenerArray[n2];
                        if (e == null) {
                            e = new HTMLEditorSaveEvent(JHTMLEditorFCKeditor.this.htmlEditor, html);
                        }
                        listener.saveHTML(e);
                        ++n2;
                    }
                }
            });
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Save successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 5.getInputStream((String)content);
                }
            };
        }
        if ("jhtml_sendData".equals(resourcePath)) {
            String data = (String)httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(EDITOR_INSTANCE);
            this.tempResult = data;
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Send data successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 6.getInputStream((String)content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/upload.php".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <script type=\"text/javascript\">" + LS + "      alert('upload to local system are not allowed...');" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "    Upload successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 7.getInputStream((String)content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/connector.php".equals(resourcePath)) {
            Map queryParameterMap = httpRequest.getQueryParameterMap();
            String command = (String)queryParameterMap.get("Command");
            String content = null;
            if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                final String type = (String)queryParameterMap.get("Type");
                String currentDir = (String)queryParameterMap.get("CurrentFolder");
                File[] roots = File.listRoots();
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.append("<Connector command=\"").append(command).append("\" resourceType=\"").append(type).append("\">");
                sb.append("<CurrentFolder path=\"").append(currentDir).append("\" url=\"").append(WebServer.getDefaultWebServer().getResourcePathURL(currentDir, "")).append("\" />");
                if (("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) && currentDir.equals("/") && roots.length > 1) {
                    sb.append("<Folders>");
                    File[] fileArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String rootPath = file.getAbsolutePath();
                        if (Utils.IS_WINDOWS && rootPath.endsWith("\\")) {
                            rootPath = rootPath.substring(0, rootPath.length() - 1);
                        }
                        sb.append("<Folder name=\"").append(Utils.escapeXML((String)rootPath)).append("\"/>");
                        ++n2;
                    }
                    sb.append("</Folders>");
                } else {
                    File file;
                    int n;
                    int n3;
                    File[] fileArray;
                    if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                        sb.append("<Folders>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return !pathname.isFile() && !pathname.isHidden() && pathname.listFiles() != null;
                            }
                        });
                        n3 = fileArray.length;
                        n = 0;
                        while (n < n3) {
                            file = fileArray[n];
                            sb.append("<Folder name=\"").append(Utils.escapeXML((String)file.getName())).append("\"/>");
                            ++n;
                        }
                        sb.append("</Folders>");
                    }
                    if ("GetFoldersAndFiles".equals(command)) {
                        sb.append("<Files>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                if (!pathname.isFile()) {
                                    return false;
                                }
                                if ("Image".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".bmp") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".png");
                                }
                                if ("Flash".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".swf");
                                }
                                return true;
                            }
                        });
                        n3 = fileArray.length;
                        n = 0;
                        while (n < n3) {
                            file = fileArray[n];
                            sb.append("<File name=\"").append(Utils.escapeXML((String)file.getName())).append("\" size=\"").append(file.length() / 1000L).append("\"/>");
                            ++n;
                        }
                        sb.append("</Files>");
                    }
                }
                sb.append("</Connector>");
                content = sb.toString();
            }
            final String content_ = content;
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return "text/xml; charset=utf-8";
                }

                public InputStream getInputStream() {
                    return 10.getInputStream((String)content_);
                }
            };
        }
        return WebServer.getDefaultWebServer().getURLContent(WebServer.getDefaultWebServer().getClassPathResourceURL(JHTMLEditor.class.getName(), PACKAGE_PREFIX + resourcePath));
    }

    @Override
    public void clearDirtyIndicator() {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_clearDirtyIndicator();");
    }

    @Override
    public void setDirtyTrackingActive(boolean isDirtyTrackingActive) {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_setDirtyTrackingActive(" + isDirtyTrackingActive + ");");
    }

    @Override
    public String getHTMLContent() {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        if (!webBrowser.isNativePeerInitialized()) {
            return "";
        }
        this.tempResult = this;
        webBrowser.executeJavascript("JH_sendData();");
        int timeout = Integer.parseInt(NSSystemPropertySWT.HTMLEDITOR_GETHTMLCONTENT_TIMEOUT.get("1500"));
        long start = System.currentTimeMillis();
        do {
            EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                public boolean getValue() {
                    return JHTMLEditorFCKeditor.this.tempResult != JHTMLEditorFCKeditor.this;
                }
            }, 50);
            if (this.tempResult == this) continue;
            return (String)this.tempResult;
        } while (System.currentTimeMillis() - start <= (long)timeout);
        return null;
    }

    @Override
    public void setHTMLContent(String html) {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        NativeComponent nativeComponent = webBrowser.getNativeComponent();
        boolean isEnabled = nativeComponent.isEnabled();
        nativeComponent.setEnabled(false);
        new Message().syncSend(true);
        webBrowser.executeJavascript("JH_setData('" + Utils.encodeURL((String)html) + "');");
        new Message().syncSend(true);
        nativeComponent.setEnabled(isEnabled);
    }
}

