/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import reifnsk.minimap.ICustomChunk;
import reifnsk.minimap.ReiMinimap;

public class ChunkData {
    private static final int CHUNK_RELOAD_INTERVAL = 60;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int CHUNK_ARRAY_SIZE = 1024;
    private static final int CHUNK_SHIFT = 5;
    public final int xPosition;
    public final int zPosition;
    private abw chunk;
    private boolean chunkFileExist = true;
    private boolean chunkModified;
    private int chunkUpdateCount;
    private boolean chunkUpdate;
    private int lastRenderCount = reimm.getUpdateCount();
    private int lastAccessCount = reimm.getUpdateCount();
    private int lastUpdateCount = reimm.getUpdateCount();
    private int chunkReloadCount = reimm.getUpdateCount();
    int[] foliageColors = new int[256];
    int[] grassColors = new int[256];
    int[] waterColors = new int[256];
    int[] smoothFoliageColors = new int[256];
    int[] smoothGrassColors = new int[256];
    int[] smoothWaterColors = new int[256];
    float[] heightValues = new float[256];
    aav[] biomes = PLAINS;
    boolean enviromnentColorUpdateReq;
    boolean slime;
    private static aav[] PLAINS = new aav[256];
    private static final ReiMinimap reimm;
    private static final ChunkData[] cache;
    private static Minecraft minecraft;
    private static aab world;
    private static acn worldProvider;
    private static aba worldChunkManager;
    private static abt chunkProvider;
    private static acb chunkLoader;
    private static long seed;

    private ChunkData(int cx2, int cz2) {
        this.xPosition = cx2;
        this.zPosition = cz2;
        this.slime = seed != 0L && new Random(seed + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ 0x3AD8025FL).nextInt(10) == 0;
    }

    public final boolean isAtLocation(int cx2, int cz2) {
        return cx2 == this.xPosition && cz2 == this.zPosition;
    }

    boolean updateChunk(boolean chunkLoadFromFile) {
        boolean result = false;
        int currentCount = reimm.getUpdateCount();
        acb loader = chunkLoadFromFile ? chunkLoader : null;
        abw prevChunk = this.chunk;
        if (this.chunkReloadCount - currentCount <= 0) {
            this.chunkReloadCount = currentCount + 60;
            if (chunkProvider.a(this.xPosition, this.zPosition)) {
                this.chunk = chunkProvider.d(this.xPosition, this.zPosition);
                this.chunkFileExist = true;
            } else if (this.chunk == null && loader != null && this.chunkFileExist) {
                try {
                    this.chunk = loader.a(world, this.xPosition, this.zPosition);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                this.chunkFileExist = this.chunk != null;
                result = true;
            } else {
                this.chunkReloadCount = currentCount + 7;
            }
        }
        if (this.chunk == null) {
            this.chunk = prevChunk;
        }
        if (this.chunk != prevChunk || this.enviromnentColorUpdateReq) {
            this.updateEnvironmentColor();
            this.chunkUpdate = true;
        }
        if (this.chunk != null) {
            if (this.chunk instanceof ICustomChunk) {
                ICustomChunk icc = (ICustomChunk)((Object)this.chunk);
                if (this.chunkUpdateCount != icc.updateCount()) {
                    this.chunkUpdateCount = icc.updateCount();
                    this.chunkUpdate = true;
                }
            } else if (this.chunkModified != this.chunk.l || this.chunkModified && currentCount - this.lastUpdateCount >= 10) {
                this.chunkModified = this.chunk.l;
                this.chunkUpdate = true;
            }
        }
        return result;
    }

    public abw getChunk() {
        return this.chunk;
    }

    private void updateEnvironmentColor() {
        if (this.chunk != null) {
            byte[] biomesArray = this.chunk.m();
            this.biomes = Arrays.copyOf(this.biomes, 256);
            for (int i2 = 0; i2 < 256; ++i2) {
                int id2 = biomesArray[i2] & 0xFF;
                if (id2 == 255) {
                    this.enviromnentColorUpdateReq = true;
                    return;
                }
                aav biome = aav.a[id2];
                this.biomes[i2] = biome == null ? aav.c : biome;
            }
        }
        this.enviromnentColorUpdateReq = false;
        for (int i3 = 0; i3 < 256; ++i3) {
            aav bgb2 = this.biomes[i3];
            this.waterColors[i3] = bgb2.H;
            this.foliageColors[i3] = bgb2.l();
            this.grassColors[i3] = bgb2.k();
        }
        for (int z2 = -1; z2 <= 16; ++z2) {
            for (int x2 = -1; x2 <= 16; ++x2) {
                this.calcSmoothColor(x2, z2);
            }
        }
    }

    private void calcSmoothColor(int x2, int z2) {
        int setPtr = x2 & 0xF | (z2 & 0xF) << 4;
        ChunkData target = ChunkData.getChunkData((x2 += this.xPosition << 4) >> 4, (z2 += this.zPosition << 4) >> 4);
        if (target == null) {
            return;
        }
        int count = 0;
        int fr2 = 0;
        int fg2 = 0;
        int fb2 = 0;
        int gr2 = 0;
        int gg2 = 0;
        int gb2 = 0;
        int wr2 = 0;
        int wg2 = 0;
        int wb2 = 0;
        for (int bz2 = z2 - 1; bz2 <= z2 + 1; ++bz2) {
            for (int bx2 = x2 - 1; bx2 <= x2 + 1; ++bx2) {
                ChunkData cd2 = ChunkData.getChunkData(bx2 >> 4, bz2 >> 4);
                if (cd2 == null || cd2.biomes == null) continue;
                int p2 = bx2 & 0xF | (bz2 & 0xF) << 4;
                int foliageColor = cd2.foliageColors[p2];
                fr2 += foliageColor >> 16 & 0xFF;
                fg2 += foliageColor >> 8 & 0xFF;
                fb2 += foliageColor & 0xFF;
                int grassColor = cd2.grassColors[p2];
                gr2 += grassColor >> 16 & 0xFF;
                gg2 += grassColor >> 8 & 0xFF;
                gb2 += grassColor & 0xFF;
                int waterColor = cd2.waterColors[p2];
                wr2 += waterColor >> 16 & 0xFF;
                wg2 += waterColor >> 8 & 0xFF;
                wb2 += waterColor & 0xFF;
                ++count;
            }
        }
        target.smoothFoliageColors[setPtr] = (fr2 / count & 0xFF) << 16 | (fg2 / count & 0xFF) << 8 | fb2 / count & 0xFF;
        target.smoothGrassColors[setPtr] = (gr2 / count & 0xFF) << 16 | (gg2 / count & 0xFF) << 8 | gb2 / count & 0xFF;
        target.smoothWaterColors[setPtr] = (wr2 / count & 0xFF) << 16 | (wg2 / count & 0xFF) << 8 | wb2 / count & 0xFF;
    }

    static void init() {
        try {
            iz[] ws2;
            Arrays.fill(cache, null);
            minecraft = reimm.getMinecraft();
            world = reimm.getWorld();
            seed = 0L;
            if (Minecraft.x().D() != null && (ws2 = Minecraft.x().D().b) != null && ws2.length >= 1) {
                seed = ws2[0].G();
            }
            worldProvider = ChunkData.world.t;
            worldChunkManager = world.u();
            chunkProvider = world.K();
            chunkLoader = ChunkData.getChunkLoader(chunkProvider);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static acb getChunkLoader(abt chunkProvider) {
        try {
            for (Class<?> clazz = chunkProvider.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field f2 : clazz.getDeclaredFields()) {
                    if (f2.getType() != acb.class) continue;
                    f2.setAccessible(true);
                    return (acb)f2.get(chunkProvider);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkData getChunkData(int cx2, int cz2) {
        int ptr = ChunkData.chunkPointer(cx2, cz2);
        ChunkData data = cache[ptr];
        return data == null || !data.isAtLocation(cx2, cz2) ? null : data;
    }

    static ChunkData createChunkData(int cx2, int cz2) {
        int ptr = ChunkData.chunkPointer(cx2, cz2);
        ChunkData data = cache[ptr];
        return data == null || !data.isAtLocation(cx2, cz2) ? new ChunkData(cx2, cz2) : data;
    }

    private static int chunkPointer(int cx2, int cz2) {
        return (cz2 & 0x1F) << 5 | cx2 & 0x1F;
    }

    void setHeightValue(int x2, int z2, float value) {
        this.heightValues[z2 << 4 | x2] = value;
    }

    float getHeightValue(int x2, int z2) {
        return this.heightValues[z2 << 4 | x2];
    }

    static {
        Arrays.fill(PLAINS, aav.c);
        reimm = ReiMinimap.instance;
        cache = new ChunkData[1024];
    }
}

