/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import reifnsk.minimap.BlockAccess;
import reifnsk.minimap.BlockColor;
import reifnsk.minimap.BlockData;
import reifnsk.minimap.BlockType;

public class BlockDataPack {
    private static final int renderStandardBlock = 0;
    private static final int renderCrossedSquares = 1;
    private static final int renderBlockTorch = 2;
    private static final int renderBlockFire = 3;
    private static final int renderBlockFluids = 4;
    private static final int renderBlockRedstoneWire = 5;
    private static final int renderBlockCrops = 6;
    private static final int renderBlockDoor = 7;
    private static final int renderBlockLadder = 8;
    private static final int renderBlockMinecartTrack = 9;
    private static final int renderBlockStairs = 10;
    private static final int renderBlockFence = 11;
    private static final int renderBlockLever = 12;
    private static final int renderBlockCactus = 13;
    private static final int renderBlockBed = 14;
    private static final int renderBlockRepeater = 15;
    private static final int renderPistonBase = 16;
    private static final int renderPistonExtension = 17;
    private static final int renderBlockPane = 18;
    private static final int renderBlockStem = 19;
    private static final int renderBlockVine = 20;
    private static final int renderBlockFenceGate = 21;
    private static final int renderBlockChest = 22;
    private static final int renderBlockLilyPad = 23;
    private static final int renderBlockCauldron = 24;
    private static final int renderBlockBrewingStand = 25;
    private static final int renderBlockEndPortalFrame = 26;
    private static final int renderBlockDragonEgg = 27;
    private static final int renderBlockCocoa = 28;
    private static final int renderBlockTripWireSource = 29;
    private static final int renderBlockTripWire = 30;
    private static final int renderBlockLog = 31;
    private static final int renderBlockWall = 32;
    private static final int renderBlockFlowerpot = 33;
    private static final int renderBlockBeacon = 34;
    private static final int renderBlockAnvil = 35;
    private static final int renderBlockRepeater2 = 36;
    private static final int renderBlockComparator = 37;
    private static final int renderBlockHopper = 38;
    private static final int renderBlockModLoader = -1;
    protected static final int BLOCK_NUM = apa.r.length;
    protected static final int BLOCK_META_BITS = 4;
    protected static final int BLOCK_META = 16;
    protected static final int BLOCK_META_MASK = 15;
    protected static final int BLOCK_COLOR_NUM = BLOCK_NUM << 4;
    protected static BlockData[] blockData;
    protected static float[] height;
    protected static BlockData[] blockColorData;
    private static BlockColor[] defaultBlockColor;
    private static HashMap defaultBlockColorMap;
    public BlockColor[] blockColors;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BlockColor[] calcTextureColor(bjt texturePack) {
        if (texturePack instanceof bjq && defaultBlockColor != null) {
            return defaultBlockColor;
        }
        if (texturePack == null && defaultBlockColor != null) {
            return defaultBlockColor;
        }
        ZipFile zipFile = null;
        if (texturePack instanceof bjr) {
            try {
                for (Field f2 : bjr.class.getDeclaredFields()) {
                    if (f2.getType() != ZipFile.class) continue;
                    f2.setAccessible(true);
                    zipFile = (ZipFile)f2.get(texturePack);
                    break;
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (zipFile == null) {
                return defaultBlockColor;
            }
        }
        BlockColor[] result = new BlockColor[BLOCK_COLOR_NUM];
        boolean skipTexture = false;
        String textureName = null;
        BufferedImage image = null;
        int[] splitImage = null;
        int w2 = 0;
        int h2 = 0;
        int sw2 = 0;
        int sh2 = 0;
        HashMap<BlockData, BlockColor> map = new HashMap<BlockData, BlockColor>();
        if (defaultBlockColorMap != null) {
            map.putAll(defaultBlockColorMap);
        }
        for (BlockData bd2 : blockData) {
            block61: {
                if (!bd2.textureName.equals(textureName)) {
                    textureName = bd2.textureName;
                    String texturePath = null;
                    Pattern pattern = Pattern.compile("([^:]+):(.+)");
                    Matcher matcher = pattern.matcher(textureName);
                    if (matcher.matches()) {
                        texturePath = String.format("/mods/%s/textures/blocks/%s.png", matcher.group(1), matcher.group(2));
                    }
                    if (texturePath == null) {
                        texturePath = String.format("/textures/blocks/%s.png", textureName);
                    }
                    try {
                        block60: {
                            if (zipFile != null) {
                                ZipEntry zipentry = zipFile.getEntry(texturePath.substring(1));
                                if (zipentry != null) {
                                    image = ImageIO.read(zipFile.getInputStream(zipentry));
                                    break block60;
                                } else {
                                    skipTexture = true;
                                    continue;
                                }
                            }
                            try {
                                image = ImageIO.read(bjt.class.getResourceAsStream(texturePath));
                            }
                            catch (Exception e3) {
                                skipTexture = true;
                                continue;
                            }
                        }
                        skipTexture = false;
                        w2 = image.getWidth();
                        h2 = image.getHeight();
                        sw2 = w2;
                        sh2 = w2;
                        splitImage = BlockDataPack.calcColorArrays(image, bd2.renderPass, null);
                        break block61;
                    }
                    catch (IOException e4) {
                        skipTexture = true;
                        continue;
                    }
                }
                if (skipTexture) continue;
            }
            BlockColor bc2 = null;
            switch (bd2.renderType) {
                default: {
                    BlockType blockType = bd2.extend instanceof BlockType ? (BlockType)((Object)bd2.extend) : BlockType.NORMAL;
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    bc2 = new BlockColor(argb, blockType);
                    break;
                }
                case 1: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a2 = Math.max(argb >>> 24, 48) << 24;
                    argb = argb & 0xFFFFFF | a2;
                    bc2 = new BlockColor(argb, bd2.extend instanceof BlockType ? (BlockType)((Object)bd2.extend) : BlockType.NORMAL);
                    break;
                }
                case 2: {
                    int b2;
                    int g2;
                    int r2;
                    int argb1 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.4375f, 0.4375f, 0.5625f, 0.5625f);
                    int argb2 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.375f, 0.375f, 0.625f, 0.625f);
                    int a1 = argb1 >> 24 & 0xFF;
                    int a2 = argb2 >> 24 & 0xFF;
                    int a3 = a1 + a2;
                    if (a3 != 0) {
                        r2 = ((argb1 >> 16 & 0xFF) * a1 + (argb2 >> 16 & 0xFF) * a2) / a3;
                        g2 = ((argb1 >> 8 & 0xFF) * a1 + (argb2 >> 8 & 0xFF) * a2) / a3;
                        b2 = ((argb1 >> 0 & 0xFF) * a1 + (argb2 >> 0 & 0xFF) * a2) / a3;
                        bc2 = new BlockColor(Integer.MIN_VALUE | r2 << 16 | g2 << 8 | b2, BlockType.NORMAL);
                        break;
                    }
                    argb1 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.25f, 0.25f, 0.75f, 0.75f);
                    a1 = argb1 >> 24 & 0xFF;
                    a3 = a1 + (a2 = (argb2 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 1.0f, 1.0f)) >> 24 & 0xFF);
                    if (a3 == 0) break;
                    r2 = ((argb1 >> 16 & 0xFF) * a1 + (argb2 >> 16 & 0xFF) * a2) / a3;
                    g2 = ((argb1 >> 8 & 0xFF) * a1 + (argb2 >> 8 & 0xFF) * a2) / a3;
                    b2 = ((argb1 >> 0 & 0xFF) * a1 + (argb2 >> 0 & 0xFF) * a2) / a3;
                    bc2 = new BlockColor(Integer.MIN_VALUE | r2 << 16 | g2 << 8 | b2, BlockType.NORMAL);
                    break;
                }
                case 3: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 4: {
                    BlockType type = bd2.extend == apa.F || bd2.extend == apa.E ? BlockType.WATER : BlockType.NORMAL;
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), type);
                    break;
                }
                case 5: {
                    int meta = bd2.extend instanceof Integer ? (Integer)bd2.extend : 0;
                    float f3 = (float)meta / 15.0f;
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a4 = Math.max(argb >> 24 & 0xFF, 108);
                    int r3 = (int)((float)(argb >> 16 & 0xFF) * Math.max(0.3f, f3 * 0.6f + 0.4f));
                    int g3 = (int)((float)(argb >> 8 & 0xFF) * Math.max(0.0f, f3 * f3 * 0.7f - 0.5f));
                    bc2 = new BlockColor(a4 << 24 | r3 << 16 | g3 << 8, BlockType.NORMAL);
                    break;
                }
                case 6: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a5 = Math.max(argb >>> 24, 32) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a5, BlockType.NORMAL);
                    break;
                }
                case 7: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 8: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a6 = Math.min(argb >>> 24, 40) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a6, BlockType.NORMAL);
                    break;
                }
                case 9: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 10: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 11: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a7 = Math.min(argb >>> 24, 96) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a7, BlockType.NORMAL);
                    break;
                }
                case 12: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 13: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 14: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 15: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 16: {
                    int meta;
                    if (bd2.extend instanceof Integer && (meta = ((Integer)bd2.extend).intValue()) >= 10 && meta <= 13) {
                        bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.25f, 1.0f, 1.0f), BlockType.NORMAL);
                        break;
                    }
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 17: {
                    int meta;
                    if (bd2.extend instanceof Integer && (((meta = ((Integer)bd2.extend).intValue()) & 7) == 0 || (meta & 7) == 1)) {
                        bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                        break;
                    }
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 1.0f, 0.25f) & 0xFFFFFF | Integer.MIN_VALUE, BlockType.NORMAL);
                    break;
                }
                case 18: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a8 = Math.min(argb >>> 24, 40) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a8, BlockType.NORMAL);
                    break;
                }
                case 19: {
                    int meta = bd2.extend instanceof Integer ? (Integer)bd2.extend : 0;
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 1.0f, bd2.maxY);
                    if ((argb & 0xFF000000) == 0) break;
                    int a3 = Math.max(48, argb >> 24 & 0xFF);
                    int r2 = (argb >> 16 & 0xFF) * (meta * 32) / 255;
                    int g2 = (argb >> 8 & 0xFF) * (255 - meta * 8) / 255;
                    int b2 = (argb >> 0 & 0xFF) * (meta * 4) / 255;
                    bc2 = new BlockColor(a3 << 24 | r2 << 16 | g2 << 8 | b2 << 0, BlockType.NORMAL);
                    break;
                }
                case 20: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 1.0f, 1.0f);
                    if ((argb & 0xFF000000) == 0) break;
                    int a9 = Math.min(argb >>> 24, 32) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a9, BlockType.SIMPLE_FOLIAGE);
                    break;
                }
                case 21: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 1.0f, 1.0f);
                    if ((argb & 0xFF000000) == 0) break;
                    int a10 = Math.min(argb >>> 24, 128) << 24;
                    bc2 = new BlockColor(argb & 0xFFFFFF | a10, BlockType.NORMAL);
                    break;
                }
                case 22: {
                    bc2 = new BlockColor(BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ), BlockType.NORMAL);
                    break;
                }
                case 23: {
                    int argb = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if ((argb & 0xFF000000) == 0) break;
                    int a11 = argb & 0xFF000000;
                    int r4 = (argb >> 16 & 0xFF) * 32 / 255;
                    int g4 = (argb >> 8 & 0xFF) * 128 / 255;
                    int b3 = (argb >> 0 & 0xFF) * 48 / 255;
                    bc2 = new BlockColor(a11 | r4 << 16 | g4 << 8 | b3 << 0, BlockType.NORMAL);
                    break;
                }
                case 24: {
                    int b4;
                    int meta;
                    int g3;
                    int r3;
                    int top = BlockDataPack.calcColorInt(splitImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    int[] tempImage = splitImage;
                    int bottom = BlockDataPack.calcColorInt(tempImage, sw2, sh2, bd2.minX, bd2.minZ, bd2.maxX, bd2.maxZ);
                    if (bd2.extend instanceof Integer && (meta = ((Integer)bd2.extend).intValue()) > 0) {
                        r3 = ((bottom >> 16 & 0xFF) * 102 + 5508) / 255;
                        g3 = ((bottom >> 8 & 0xFF) * 102 + 9027) / 255;
                        b4 = ((bottom >> 0 & 0xFF) * 102 + 39015) / 255;
                        bottom = 0xFF000000 | r3 << 16 | g3 << 8 | b4 << 0;
                    }
                    int a4 = top >> 24;
                    int _a = 255 - a4;
                    int r5 = ((bottom >> 16 & 0xFF) * _a + (top >> 16 & 0xFF) * a4) / 255;
                    int g5 = ((bottom >> 8 & 0xFF) * _a + (top >> 8 & 0xFF) * a4) / 255;
                    int b5 = ((bottom >> 0 & 0xFF) * _a + (top >> 0 & 0xFF) * a4) / 255;
                    bc2 = new BlockColor(0xFF000000 | r5 << 16 | g5 << 8 | b5 << 0, BlockType.NORMAL);
                    break;
                }
                case 25: {
                    int[] tempImage = splitImage;
                    int base1 = BlockDataPack.calcColorInt(tempImage, sw2, sh2, 0.5625f, 0.3125f, 0.9375f, 0.6875f);
                    int base2 = BlockDataPack.calcColorInt(tempImage, sw2, sh2, 0.125f, 0.0625f, 0.5f, 0.4375f);
                    int base3 = BlockDataPack.calcColorInt(tempImage, sw2, sh2, 0.125f, 0.5625f, 0.5f, 0.9375f);
                    int r3 = (base1 >> 16 & 0xFF) + (base2 >> 16 & 0xFF) + (base3 >> 16 & 0xFF);
                    int g3 = (base1 >> 8 & 0xFF) + (base2 >> 8 & 0xFF) + (base3 >> 8 & 0xFF);
                    int b4 = (base1 >> 0 & 0xFF) + (base2 >> 0 & 0xFF) + (base3 >> 0 & 0xFF);
                    int meta = bd2.extend instanceof Integer ? (Integer)bd2.extend : 0;
                    int stand1 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.5f, 0.0f, 1.0f, 1.0f);
                    int stand2 = BlockDataPack.calcColorInt(splitImage, sw2, sh2, 0.0f, 0.0f, 0.5f, 1.0f);
                    switch (meta) {
                        case 0: {
                            r3 += (stand1 >> 16 & 0xFF) * 3;
                            g3 += (stand1 >> 8 & 0xFF) * 3;
                            b4 += (stand1 >> 0 & 0xFF) * 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            r3 += (stand1 >> 16 & 0xFF) * 2 + (stand2 >> 16 & 0xFF);
                            g3 += (stand1 >> 8 & 0xFF) * 2 + (stand2 >> 8 & 0xFF);
                            b4 += (stand1 >> 0 & 0xFF) * 2 + (stand2 >> 0 & 0xFF);
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: {
                            r3 += (stand1 >> 16 & 0xFF) + (stand2 >> 16 & 0xFF) * 2;
                            g3 += (stand1 >> 8 & 0xFF) + (stand2 >> 8 & 0xFF) * 2;
                            b4 += (stand1 >> 0 & 0xFF) + (stand2 >> 0 & 0xFF) * 2;
                            break;
                        }
                        case 7: {
                            r3 += (stand2 >> 16 & 0xFF) * 3;
                            g3 += (stand2 >> 8 & 0xFF) * 3;
                            b4 += (stand2 >> 0 & 0xFF) * 3;
                            break;
                        }
                    }
                    bc2 = new BlockColor(Integer.MIN_VALUE | (r3 /= 6) << 16 | (g3 /= 6) << 8 | (b4 /= 6) << 0, BlockType.NORMAL);
                    break;
                }
            }
            map.put(bd2, bc2);
        }
        if (texturePack == null) {
            defaultBlockColorMap = map;
        }
        int i2 = 0;
        while (i2 < BLOCK_COLOR_NUM) {
            result[i2] = (BlockColor)map.get(blockColorData[i2]);
            ++i2;
        }
        return result;
    }

    private static int[] calcColorArrays(BufferedImage image, int renderPass, List list) {
        boolean alpha = renderPass == 1;
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int sz2 = w2 * w2;
        int[] result = new int[sz2];
        if (w2 == h2) {
            image.getRGB(0, 0, w2, h2, result, 0, w2);
            return result;
        }
        int[] rgbArray = image.getRGB(0, 0, w2, h2, new int[w2 * h2], 0, w2);
        int[] factor = new int[h2 / w2];
        int num = 0;
        if (list == null) {
            Arrays.fill(factor, 1);
            num = factor.length;
        } else {
            for (Integer inte : list) {
                if (inte == null) continue;
                int i2 = inte;
                int j2 = i2 >>> 16;
                int k2 = i2 & 0xFFFF;
                if (j2 >= factor.length) continue;
                int n2 = j2;
                factor[n2] = factor[n2] + k2;
                num += k2;
            }
        }
        for (int i3 = 0; i3 < sz2; ++i3) {
            int aSum = 0;
            int rSum = 0;
            int gSum = 0;
            int bSum = 0;
            for (int j3 = 0; j3 < factor.length; ++j3) {
                int argb = rgbArray[j3 * sz2 + i3];
                aSum += (argb >> 24 & 0xFF) * factor[j3];
                rSum += (argb >> 16 & 0xFF) * factor[j3];
                gSum += (argb >> 8 & 0xFF) * factor[j3];
                bSum += (argb >> 0 & 0xFF) * factor[j3];
            }
            int a2 = BlockDataPack.clamp(aSum / num, 0, 255);
            int r2 = BlockDataPack.clamp(rSum / num, 0, 255);
            int g2 = BlockDataPack.clamp(gSum / num, 0, 255);
            int b2 = BlockDataPack.clamp(bSum / num, 0, 255);
            if (!alpha) {
                a2 = a2 <= 25 ? 0 : 255;
            }
            result[i3] = a2 << 24 | r2 << 16 | g2 << 8 | b2 << 0;
        }
        return result;
    }

    private static int clamp(int i2, int min, int max) {
        return i2 < min ? min : (i2 > max ? max : i2);
    }

    private static int calcColorInt(int[] image, int w2, int h2, float minX, float minZ, float maxX, float maxZ) {
        if (minX == maxX || minZ == maxZ) {
            return 0xFF00FF;
        }
        int startX = (int)Math.floor((float)w2 * Math.max(0.0f, minX < maxX ? minX : maxX));
        int startY = (int)Math.floor((float)h2 * Math.max(0.0f, minZ < maxZ ? minZ : maxZ));
        int endX = (int)Math.floor((float)w2 * Math.min(1.0f, minX < maxX ? maxX : minX));
        int endY = (int)Math.floor((float)h2 * Math.min(1.0f, minZ < maxZ ? maxZ : minZ));
        long a2 = 0L;
        long r2 = 0L;
        long g2 = 0L;
        long b2 = 0L;
        for (int y2 = startY; y2 < endY; ++y2) {
            for (int x2 = startX; x2 < endX; ++x2) {
                int argb = image[y2 * w2 + x2];
                int _a = argb >> 24 & 0xFF;
                a2 += (long)_a;
                r2 += (long)((argb >> 16 & 0xFF) * _a);
                g2 += (long)((argb >> 8 & 0xFF) * _a);
                b2 += (long)((argb >> 0 & 0xFF) * _a);
            }
        }
        if (a2 == 0L) {
            return 0xFF00FF;
        }
        double d2 = 1.0 / (double)a2;
        r2 = Math.min(255, Math.max(0, (int)((double)r2 * d2)));
        g2 = Math.min(255, Math.max(0, (int)((double)g2 * d2)));
        b2 = Math.min(255, Math.max(0, (int)((double)b2 * d2)));
        return (int)((a2 /= (long)image.length) << 24 | r2 << 16 | g2 << 8 | b2);
    }

    private static String getBlockTexture(apa block) {
        for (Class<?> clazz = block.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m2 : clazz.getMethods()) {
                if (m2.getReturnType() != String.class || m2.getParameterTypes().length != 0 || !m2.getName().equals("getTextureFile")) continue;
                try {
                    return (String)m2.invoke((Object)block, new Object[0]);
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static final int calcPointer(int id2, int meta) {
        assert (id2 >= 0 && id2 < BLOCK_NUM);
        assert (meta >= 0 && meta < 16);
        return id2 << 4 | meta;
    }

    private static boolean isPlasmaCraftFluidBlock(apa block) {
        assert (block != null);
        String className = block.getClass().getName();
        return className.equals("Plasmacraft.BlockCausticStationary") || className.equals("Plasmacraft.BlockCausticFlowing");
    }

    public BlockDataPack(bjt tpb) {
        this.blockColors = BlockDataPack.calcTextureColor(tpb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        height = new float[BLOCK_COLOR_NUM];
        blockColorData = new BlockData[BLOCK_COLOR_NUM];
        defaultBlockColor = null;
        HashMap<BlockData, BlockData> blockDataMap = new HashMap<BlockData, BlockData>();
        BlockAccess blockAccess = new BlockAccess();
        apa.O.a(true);
        try {
            for (int id2 = 0; id2 < BLOCK_NUM; ++id2) {
                apa block = apa.r[id2];
                if (block == null) continue;
                blockAccess.blockId = id2;
                int renderType = block.d();
                int renderPass = block.n();
                try {
                    for (int meta = 0; meta < 16; ++meta) {
                        String textureName;
                        int ptr;
                        Object extend = null;
                        int exmeta = meta;
                        if (id2 == apa.ae.cz) {
                            int n2 = exmeta = (exmeta & 7) >= 6 ? 108 : exmeta;
                        }
                        if (id2 == apa.aD.cz && meta >= 8) {
                            ptr = BlockDataPack.calcPointer(id2, meta);
                            BlockDataPack.blockColorData[ptr] = blockColorData[ptr & 0xFFFFFFFF];
                            continue;
                        }
                        blockAccess.blockMetadata = meta;
                        ptr = BlockDataPack.calcPointer(id2, meta);
                        try {
                            block.a(blockAccess, 0, 0, 0);
                        }
                        catch (Exception npe) {
                            // empty catch block
                        }
                        BlockDataPack.height[ptr] = (float)block.x();
                        boolean redstoneTorch = block instanceof anp;
                        lx icon = null;
                        try {
                            icon = block.a(redstoneTorch ? 0 : 1, exmeta);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        if (block instanceof aoe) {
                            icon = aoe.b("redstoneDust_cross");
                        } else if (block instanceof amc) {
                            icon = block.b_(blockAccess, 0, 0, 0, 0);
                        }
                        if (icon == null || (textureName = icon.i()) == null) continue;
                        if (id2 == apa.y.cz) {
                            extend = BlockType.GRASS;
                        } else if (id2 == apa.O.cz) {
                            switch (meta & 3) {
                                default: {
                                    extend = BlockType.FOLIAGE;
                                    break;
                                }
                                case 1: {
                                    extend = BlockType.FOLIAGE_PINE;
                                    break;
                                }
                                case 2: {
                                    extend = BlockType.FOLIAGE_BIRCH;
                                    break;
                                }
                            }
                        } else if (id2 == apa.ab.cz && meta != 0) {
                            extend = BlockType.SIMPLE_GRASS;
                        } else if (id2 == apa.aX.cz) {
                            extend = BlockType.ICE;
                        }
                        float minX = (float)block.u();
                        float minY = (float)block.w();
                        float minZ = (float)block.y();
                        float maxX = (float)block.v();
                        float maxY = (float)block.x();
                        float maxZ = (float)block.z();
                        switch (renderType) {
                            case 4: {
                                BlockDataPack.height[ptr] = Math.max(0.0f, 1.0f - (float)(meta + 1) / 9.0f);
                                extend = block;
                                break;
                            }
                            case 5: {
                                extend = meta;
                                break;
                            }
                            case 10: {
                                BlockDataPack.height[ptr] = (meta & 4) == 0 ? 0.75f : 1.0f;
                                break;
                            }
                            case 16: {
                                extend = meta;
                                break;
                            }
                            case 17: {
                                extend = meta;
                                break;
                            }
                            case 19: {
                                extend = Math.min(7, meta);
                                break;
                            }
                            case 24: {
                                BlockDataPack.height[ptr] = (float)(2656 + 432 * Math.min(3, meta)) / 256.0f;
                                extend = Math.min(3, meta);
                                break;
                            }
                            case 25: {
                                BlockDataPack.height[ptr] = 0.2f;
                                extend = meta & 7;
                                break;
                            }
                            case 26: {
                                boolean b2 = aoy.d(meta);
                                if (b2) {
                                    BlockDataPack.height[ptr] = 0.859375f;
                                }
                                extend = b2;
                                break;
                            }
                            case -1: {
                                extend = block;
                            }
                        }
                        BlockData temp = new BlockData(renderType, renderPass, textureName, minX, minY, minZ, maxX, maxY, maxZ, extend);
                        BlockData bd2 = (BlockData)blockDataMap.get(temp);
                        if (bd2 == null) {
                            bd2 = temp;
                            blockDataMap.put(bd2, bd2);
                        }
                        BlockDataPack.blockColorData[ptr] = bd2;
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e3) {
                    continue;
                }
            }
        }
        finally {
            apa.O.a(Minecraft.x().z.j);
        }
        blockData = blockDataMap.keySet().toArray(new BlockData[blockDataMap.size()]);
        Arrays.sort(blockData);
        defaultBlockColor = BlockDataPack.calcTextureColor(null);
    }
}

