/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.wrapper;

import com.q3hardcore.xcommands.util.ObfuscationHelper;
import com.q3hardcore.xcommands.wrapper.Coordinate;
import com.q3hardcore.xcommands.wrapper.WAxisAlignedBB;
import com.q3hardcore.xcommands.wrapper.WBiome;
import com.q3hardcore.xcommands.wrapper.WChunk;
import com.q3hardcore.xcommands.wrapper.WEntity;
import com.q3hardcore.xcommands.wrapper.WMovingObjectPosition;
import com.q3hardcore.xcommands.wrapper.WNBTTagCompound;
import com.q3hardcore.xcommands.wrapper.WSaveHandler;
import com.q3hardcore.xcommands.wrapper.WTileEntity;
import com.q3hardcore.xcommands.wrapper.WVec3D;
import com.q3hardcore.xcommands.wrapper.WWorldInfo;
import com.q3hardcore.xcommands.wrapper.WWorldProvider;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;

public class WWorld {
    private final aab world;

    public WWorld(aab aab2) {
        this.world = aab2;
    }

    public boolean equalTo(WWorld wWorld) {
        return this.rawHashCode() == wWorld.rawHashCode();
    }

    public int rawHashCode() {
        return this.world.hashCode();
    }

    public long getSeed() {
        return this.world.G();
    }

    public long getWorldTime() {
        return this.world.I();
    }

    public WWorldInfo getWorldInfo() {
        return new WWorldInfo(this.world.M());
    }

    public WVec3D getVecFromPool(double d2, double d3, double d4) {
        return new WVec3D(this.world.U().a(d2, d3, d4));
    }

    public int getBlockLightValue(int n2, int n3, int n4) {
        return this.world.m(n2, n3, n4);
    }

    public int getBlockId(int n2, int n3, int n4) {
        return this.world.a(n2, n3, n4);
    }

    public int getBlock(Coordinate coordinate, int n2) {
        return this.getBlockId(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ());
    }

    public int getBlockMetadata(int n2, int n3, int n4) {
        return this.world.h(n2, n3, n4);
    }

    public int getMetadata(Coordinate coordinate, int n2) {
        return this.getBlockMetadata(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ());
    }

    public Coordinate getSpawn() {
        return this.getWorldInfo().getSpawn();
    }

    public File getWorldDir() {
        return ObfuscationHelper.getWorldDir(this);
    }

    public boolean setBlock(int n2, int n3, int n4, int n5) {
        return this.world.f(n2, n3, n4, n5, 0, 2);
    }

    public void setBlock(Coordinate coordinate, int n2) {
        this.setBlock(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ(), n2);
    }

    public boolean setBlockWithNotify(int n2, int n3, int n4, int n5) {
        return this.world.c(n2, n3, n4, n5);
    }

    public void setBlockWithNotify(Coordinate coordinate, int n2) {
        this.setBlockWithNotify(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ(), n2);
    }

    public boolean setBlockMetadata(int n2, int n3, int n4, int n5) {
        return this.world.b(n2, n3, n4, n5, 4);
    }

    public void setMetadata(Coordinate coordinate, int n2) {
        this.setBlockMetadata(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ(), n2);
    }

    public void setBlockMetadataWithNotify(int n2, int n3, int n4, int n5) {
        this.world.b(n2, n3, n4, n5, 2);
    }

    public void setMetadataWithNotify(Coordinate coordinate, int n2) {
        this.setBlockMetadataWithNotify(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ(), n2);
    }

    public boolean setBlockAndMetadataWithNotify(int n2, int n3, int n4, int n5, int n6) {
        return this.world.f(n2, n3, n4, n5, n6, 2);
    }

    public void setSpawn(Coordinate coordinate) {
        this.getWorldInfo().setSpawn(coordinate);
    }

    public long getTime() {
        return this.getWorldInfo().getWorldTime();
    }

    public int[] getFormattedTime() {
        long l2 = this.getWorldTime();
        int n2 = (int)(l2 / 1000L / 24L);
        int n3 = (int)(l2 / 1000L % 24L);
        int n4 = (int)((double)(l2 % 1000L) / 1000.0 * 60.0);
        return new int[]{n4, n3, n2};
    }

    public String getPrettyTime() {
        int[] nArray = this.getFormattedTime();
        String string = nArray[1] < 10 ? "0" + nArray[1] : "" + nArray[1];
        String string2 = nArray[0] < 10 ? "0" + nArray[0] : "" + nArray[0];
        return "Day: " + nArray[2] + " at " + string + ":" + string2;
    }

    public void setTime(long l2) {
        this.getWorldInfo().setWorldTime(l2);
    }

    public String getName() {
        return this.getWorldInfo().getWorldName();
    }

    public WBiome getBiomeGenAt(int n2, int n3) {
        return new WBiome(this.world.u().a(n2, n3));
    }

    public boolean addWeatherEffect(WEntity wEntity) {
        return this.world.c(wEntity.getRawEntity());
    }

    public int getTopSolidOrLiquidBlock(int n2, int n3) {
        return this.world.i(n2, n3);
    }

    public int getSpawnX() {
        return this.getWorldInfo().getSpawnX();
    }

    public int getSpawnY() {
        return this.getWorldInfo().getSpawnY();
    }

    public int getSpawnZ() {
        return this.getWorldInfo().getSpawnZ();
    }

    public int getWorldType() {
        return this.getWorldProvider().getDimensionId();
    }

    public void spawnEntityInWorld(WEntity wEntity) {
        this.world.d(wEntity.getRawEntity());
    }

    public aqp getBlockTileEntity(int n2, int n3, int n4) {
        return this.world.r(n2, n3, n4);
    }

    public WTileEntity getBlockTileEntity2(int n2, int n3, int n4) {
        if (this.getBlockTileEntity(n2, n3, n4) == null) {
            return null;
        }
        return new WTileEntity(this.getBlockTileEntity(n2, n3, n4));
    }

    public List getEntitiesWithinAABBExcludingEntity(WEntity wEntity, WAxisAlignedBB wAxisAlignedBB) {
        return ObfuscationHelper.getEntitiesWithinAABBExcludingEntity(this, wEntity, wAxisAlignedBB);
    }

    public WChunk getChunkFromBlockCoords(int n2, int n3) {
        return new WChunk(this.world.d(n2, n3));
    }

    public boolean blockExists(int n2, int n3, int n4) {
        return this.world.f(n2, n3, n4);
    }

    public WMovingObjectPosition rayTraceBlocks(WVec3D wVec3D, WVec3D wVec3D2) {
        return new WMovingObjectPosition(this.world.a(wVec3D.getRaw(), wVec3D2.getRaw()));
    }

    public void changeWorldInfo(String string, Object object) {
        WNBTTagCompound wNBTTagCompound = this.getWorldInfo().getNBTTagCompound();
        if (object instanceof String) {
            wNBTTagCompound.setString(string, (String)object);
        } else if (object instanceof Boolean) {
            wNBTTagCompound.setBoolean(string, (Boolean)object);
        } else if (object instanceof Integer) {
            wNBTTagCompound.setInteger(string, (Integer)object);
        } else if (object instanceof Long) {
            wNBTTagCompound.setLong(string, (Long)object);
        }
        WWorldInfo wWorldInfo = WWorldInfo.instantiate(wNBTTagCompound);
        try {
            Field[] fieldArray;
            Field[] fieldArray2 = fieldArray = aab.class.getDeclaredFields();
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = fieldArray2[i2];
                field.setAccessible(true);
                if (!(field.get(this.world) instanceof ajv)) continue;
                field.set(this.world, wWorldInfo.getRaw());
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public aab getRaw() {
        return this.world;
    }

    public WWorldProvider getWorldProvider() {
        return new WWorldProvider(this.world.t);
    }

    public WSaveHandler getSaveHandler() {
        return new WSaveHandler(this.world.L());
    }
}

