/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.wrapper;

import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.util.FontColour;
import com.q3hardcore.xcommands.wrapper.Coordinate;
import com.q3hardcore.xcommands.wrapper.WChunkCoords;
import com.q3hardcore.xcommands.wrapper.WEntity;
import com.q3hardcore.xcommands.wrapper.WEntityLiving;
import com.q3hardcore.xcommands.wrapper.WFoodStats;
import com.q3hardcore.xcommands.wrapper.WICommandSender;
import com.q3hardcore.xcommands.wrapper.WIInventory;
import com.q3hardcore.xcommands.wrapper.WInventoryPlayer;
import com.q3hardcore.xcommands.wrapper.WItemStack;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import com.q3hardcore.xcommands.wrapper.WMovingObjectPosition;
import com.q3hardcore.xcommands.wrapper.WPlayerCapabilities;

public class WEntityPlayer
extends WEntityLiving {
    private final sq player;
    private final WICommandSender sender;

    public WEntityPlayer(sq sq2) {
        super(sq2);
        this.player = sq2;
        this.sender = new WICommandSender(sq2);
    }

    public double getBlockReachDistance() {
        if (this.getCapabilities().getIsCreativeMode()) {
            return 5.0;
        }
        return 4.5;
    }

    public void addChatMessage(String string) {
        try {
            this.player.b(string);
        }
        catch (Exception exception) {
            System.out.println(string);
        }
    }

    public int getFoodLevel() {
        return this.getFoodStats().getFoodLevel();
    }

    public void setFoodLevel(int n2) {
        this.getFoodStats().addStats(n2 -= this.getFoodLevel(), 1.2f);
    }

    public WMovingObjectPosition rayTrace() {
        return this.rayTrace(this.getBlockReachDistance(), 1.0f);
    }

    public void setPositionAndUpdate(double d2, double d3, double d4) {
        this.player.a(d2, d3, d4);
    }

    public WChunkCoords getSpawnChunk() {
        return new WChunkCoords(this.player.ck());
    }

    public void setSpawnChunk(WChunkCoords wChunkCoords, boolean bl2) {
        this.player.a(wChunkCoords.getRaw(), bl2);
    }

    public WPlayerCapabilities getCapabilities() {
        return new WPlayerCapabilities(this.player.ce);
    }

    public WInventoryPlayer getInventory() {
        return new WInventoryPlayer(this.player.bK);
    }

    public int inventoryHashCode() {
        return this.getInventory().getRaw().hashCode();
    }

    public WItemStack getCurrentItem() {
        return this.getInventory().getCurrentItem();
    }

    public void addItemStackToInventory(WItemStack wItemStack) {
        this.getInventory().addItemStackToInventory(wItemStack);
    }

    public WFoodStats getFoodStats() {
        return new WFoodStats(this.player.cn());
    }

    public String getUsername() {
        return this.player.bS;
    }

    public void sendPlayerAbilities() {
        this.player.n();
    }

    public WIInventory getInventoryEnderChest() {
        return new WIInventory(this.player.cp());
    }

    public void displayGUIChest(WIInventory wIInventory) {
        this.player.a(wIInventory.getRaw());
    }

    public sq getMinecraftPlayer() {
        return this.player;
    }

    public void sendMessage(String string) {
        this.sendMessage2(Helper.getColor(Helper.normalColor) + string);
    }

    public void sendMessage2(String string) {
        this.addChatMessage(string);
    }

    public void sendPrettyMessage(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length == 2) {
            this.sendMessage2((Object)((Object)FontColour.GREEN) + stringArray[0] + ":" + (Object)((Object)FontColour.WHITE) + stringArray[1]);
        } else {
            this.sendMessage2((Object)((Object)FontColour.WHITE) + string);
        }
    }

    public void sendError(String string) {
        this.sendMessage2(Helper.getColor(Helper.errorColor) + "ERROR: " + Helper.getColor(Helper.normalColor) + string);
    }

    public void sendError2(String string) {
        this.sendMessage2("ERROR: " + string);
    }

    public static boolean isEntityInstance(WEntity wEntity) {
        return wEntity.getRawEntity() instanceof sq;
    }

    public boolean isPlayerFirst() {
        try {
            return WMinecraftServer.getServer().getFirstPlayerName().equals(this.getUsername());
        }
        catch (Exception exception) {
            System.out.println("Couldn't determine first player.");
            return false;
        }
    }

    public WICommandSender getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.sender.getCommandSenderName();
    }

    public boolean isClear(Coordinate coordinate) {
        return this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ()) == 0 && this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY() + 1, coordinate.getBlockZ()) == 0 && this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY() - 1, coordinate.getBlockZ()) != 0;
    }

    public boolean isClearBelow(Coordinate coordinate) {
        return this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY(), coordinate.getBlockZ()) == 0 && this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY() + 1, coordinate.getBlockZ()) == 0 && this.getWorld().getBlockId(coordinate.getBlockX(), coordinate.getBlockY() - 1, coordinate.getBlockZ()) == 0;
    }
}

