/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.worldedit;

import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.worldedit.XCommandsBiomeType;
import com.q3hardcore.xcommands.wrapper.WAxisAlignedBB;
import com.q3hardcore.xcommands.wrapper.WBiome;
import com.q3hardcore.xcommands.wrapper.WBlock;
import com.q3hardcore.xcommands.wrapper.WChunk;
import com.q3hardcore.xcommands.wrapper.WEntity;
import com.q3hardcore.xcommands.wrapper.WEntityLiving;
import com.q3hardcore.xcommands.wrapper.WEntityPlayer;
import com.q3hardcore.xcommands.wrapper.WIInventory;
import com.q3hardcore.xcommands.wrapper.WItemStack;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.WWorld;
import com.q3hardcore.xcommands.wrapper.lists.LEntities;
import com.q3hardcore.xcommands.wrapper.lists.LWorldGen;
import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.regions.Region;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public final class XCommandsLocalWorld
extends LocalWorld {
    public WWorld world;
    public Random random;

    public XCommandsLocalWorld(WWorld wWorld) {
        this.world = wWorld;
        this.random = new Random();
    }

    public boolean equals(Object object) {
        if (object instanceof XCommandsLocalWorld) {
            return this.world.equalTo(((XCommandsLocalWorld)((Object)object)).world);
        }
        return false;
    }

    @Deprecated
    public boolean generateTree(EditSession editSession, Vector vector) {
        LWorldGen.Trees trees = new LWorldGen.Trees(true);
        return trees.generate(this.world, this.random, vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public boolean generateBigTree(EditSession editSession, Vector vector) {
        LWorldGen.BigTree bigTree = new LWorldGen.BigTree(true);
        return bigTree.generate(this.world, this.random, vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public boolean generateBirchTree(EditSession editSession, Vector vector) throws MaxChangedBlocksException {
        return new LWorldGen.Forest(true).generate(this.world, this.random, vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public boolean generateRedwoodTree(EditSession editSession, Vector vector) throws MaxChangedBlocksException {
        return new LWorldGen.Taiga1().generate(this.world, this.random, vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public boolean generateTallRedwoodTree(EditSession editSession, Vector vector) throws MaxChangedBlocksException {
        return new LWorldGen.Taiga2(true).generate(this.world, this.random, vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public int getBlockData(Vector vector) {
        return this.world.getBlockMetadata(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public int getBlockType(Vector vector) {
        return this.world.getBlockId(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    @Deprecated
    public void setBlockData(Vector vector, int n2) {
        this.world.setBlockMetadataWithNotify(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ(), n2);
    }

    @Deprecated
    public boolean setBlockType(Vector vector, int n2) {
        return this.world.setBlockWithNotify(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ(), n2);
    }

    public void dropItem(Vector vector, BaseItemStack baseItemStack) {
        WItemStack wItemStack = WItemStack.instantiate(baseItemStack.getType(), baseItemStack.getAmount(), baseItemStack.getDamage());
        LEntities.Item item = new LEntities.Item(this.world, vector.getX(), vector.getY(), vector.getZ(), wItemStack);
        this.world.spawnEntityInWorld(item);
    }

    public boolean clearContainerBlockContents(Vector vector) {
        try {
            WIInventory wIInventory = WIInventory.instantiate(this.world.getBlockTileEntity(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()));
            for (int i2 = 0; i2 < wIInventory.getSizeInventory(); ++i2) {
                wIInventory.setInventorySlotContents(i2, null);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean copyFromWorld(Vector vector, BaseBlock baseBlock) {
        baseBlock.setData(this.world.getBlockMetadata(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()));
        baseBlock.setType(this.world.getBlockId(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()));
        return true;
    }

    public boolean copyToWorld(Vector vector, BaseBlock baseBlock) {
        return this.world.setBlockAndMetadataWithNotify(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ(), baseBlock.getType(), baseBlock.getData());
    }

    public boolean regenerate(Region region, EditSession editSession) {
        return false;
    }

    public int removeEntities(EntityType entityType, Vector vector, int n2) {
        return 1;
    }

    public int getBlockLightLevel(Vector vector) {
        return this.world.getBlockLightValue(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public int killMobsDo(Vector vector, double d2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        WPlayer wPlayer;
        List list = this.world.getEntitiesWithinAABBExcludingEntity(null, WAxisAlignedBB.getBoundingBox(vector.getX() - d2, vector.getY() - d2, vector.getZ() - d2, vector.getX() + d2, vector.getY() + d2, vector.getZ() + d2));
        int n2 = 0;
        try {
            String string = WMinecraftServer.getServer().getFirstPlayerName();
            wPlayer = WMinecraftServer.getServer().getConfigurationManager().getPlayerForUsername(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wPlayer = null;
        }
        for (WEntity wEntity : list) {
            WEntityLiving wEntityLiving = WEntityLiving.instantiate(wEntity);
            if (wEntityLiving == null || WEntityPlayer.isEntityInstance(wEntityLiving) || !bl3 && wEntityLiving.isAnimal() || !bl4 && wEntityLiving.isNPC() || !bl5 && wEntityLiving.isPet()) continue;
            wEntityLiving.setEntityHealth(0);
            if (wPlayer != null) {
                wPlayer.getMinecraftPlayer().g.add(wEntityLiving.getEntityID());
            }
            ++n2;
        }
        return n2;
    }

    public int killMobs(Vector vector, double d2, int n2) {
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = (n2 & 4) != 0;
        boolean bl5 = (n2 & 0x100000) != 0;
        return this.killMobsDo(vector, d2, bl5, bl4, bl3, bl2);
    }

    public boolean isValidBlockType(int n2) {
        return n2 == 0 ? true : (n2 > -1 && n2 < WBlock.blocksList.length ? WBlock.blocksList[n2] != null : false);
    }

    public String getName() {
        return this.world.getName();
    }

    @Deprecated
    public void setBlockDataFast(Vector vector, int n2) {
        this.world.setBlock(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ(), n2);
    }

    public void simulateBlockMine(Vector vector) {
        int n2 = vector.getBlockX();
        int n3 = vector.getBlockY();
        int n4 = vector.getBlockZ();
        WBlock wBlock = new WBlock(WBlock.blocksList[this.world.getBlockId(n2, n3, n4)]);
        byte by2 = (byte)this.world.getBlockMetadata(n2, n3, n4);
        if (wBlock.isValid()) {
            wBlock.dropBlockAsItemWithChance(this.world, n2, n3, n4, by2, 1.0f, 0);
        }
    }

    public BiomeType getBiome(Vector2D vector2D) {
        WBiome wBiome = this.world.getBiomeGenAt(vector2D.getBlockX(), vector2D.getBlockZ());
        try {
            return XCommandsBiomeType.valueOf(wBiome.getBiomeName().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return BiomeType.UNKNOWN;
        }
    }

    public void setBiome(Vector2D vector2D, BiomeType biomeType) {
        if (biomeType instanceof XCommandsBiomeType) {
            WChunk wChunk;
            int n2;
            int n3 = ((XCommandsBiomeType)biomeType).getBiomeID();
            int n4 = vector2D.getBlockX();
            if (this.world.blockExists(n4, 0, n2 = vector2D.getBlockZ()) && (wChunk = this.world.getChunkFromBlockCoords(n4, n2)).isValid()) {
                byte[] byArray = wChunk.getBiomeArray();
                byArray[(n2 & 0xF) << 4 | n4 & 0xF] = (byte)n3;
                Proxy.INSTANCE.updateClientBiomeArray(n4, n2, byArray);
            }
        }
    }
}

